/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.tile.IHeatProvider;
import shukaro.artifice.tile.IHeatReceiver;
import shukaro.artifice.util.MiscUtils;

public class TileEntityHeatingCoil
extends TileEntity
implements IEnergyReceiver,
IHeatProvider {
    private EnergyStorage energyStorage = new EnergyStorage(1600);

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        IHeatReceiver target;
        if (this.energyStorage.getEnergyStored() > this.energyStorage.getMaxEnergyStored() / 2) {
            this.energyStorage.receiveEnergy(MiscUtils.provideEnergyToNeighbors(this.energyStorage.extractEnergy(ArtificeConfig.heatingCoilRate, false), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e), false);
        }
        if ((target = MiscUtils.getHeatReceiverNeighbor(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null && this.energyStorage.getEnergyStored() > 0 && target.getHeat() < target.getMaxHeat()) {
            int sent = target.receiveHeat(this.energyStorage.extractEnergy(ArtificeConfig.heatingCoilRate, false));
            this.energyStorage.receiveEnergy(ArtificeConfig.heatingCoilRate - sent, false);
        }
        if (this.energyStorage.getEnergyStored() > 0 && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 1) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        } else if (this.energyStorage.getEnergyStored() == 0 && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }
        this.energyStorage.extractEnergy(ArtificeConfig.coilLoss, false);
        if (this.energyStorage.getEnergyStored() > 0) {
            this.doFire();
        }
    }

    private void doFire() {
        AxisAlignedBB around = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).func_72314_b(0.1, 0.1, 0.1);
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, around);
        for (EntityLivingBase entity : entities) {
            entity.func_70015_d(1);
        }
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int i, boolean b) {
        return this.energyStorage.receiveEnergy(i, b);
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int extractHeat(int amount) {
        return this.energyStorage.extractEnergy(amount, false);
    }

    @Override
    public int getHeat() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxHeat() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energyStorage.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.energyStorage.writeToNBT(tag);
    }
}

