/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.tile;

import net.minecraft.nbt.NBTTagCompound;
import shukaro.artifice.tile.IHeatProvider;
import shukaro.artifice.tile.IHeatReceiver;

public class HeatStorage
implements IHeatProvider,
IHeatReceiver {
    private int heat;
    private int maxHeat;

    public HeatStorage(int maxHeat) {
        this.maxHeat = maxHeat;
        this.heat = 0;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public int extractHeat(int amount) {
        int toExtract = Math.min(this.heat, amount);
        this.heat -= toExtract;
        return toExtract;
    }

    @Override
    public int receiveHeat(int amount) {
        int toReceive = Math.min(this.maxHeat - this.heat, amount);
        this.heat += toReceive;
        return toReceive;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.heat = tag.func_74762_e("Heat");
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.heat < 0) {
            this.heat = 0;
        }
        tag.func_74768_a("Heat", this.heat);
    }
}

