/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.recipe;

import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.recipe.BoxCraftingHandler;
import shukaro.artifice.recipe.RecipeBox;
import shukaro.artifice.recipe.RecipeUpgrade;

public class ArtificeRecipes {
    public static void registerRecipes() {
        if (ArtificeConfig.basaltRecipes) {
            ArtificeRecipes.registerBasaltRecipes();
        }
        if (ArtificeConfig.marbleRecipes) {
            ArtificeRecipes.registerMarbleRecipes();
        }
        if (ArtificeConfig.limestoneRecipes) {
            ArtificeRecipes.registerLimestoneRecipes();
        }
        if (ArtificeConfig.oreRecipes) {
            ArtificeRecipes.registerOreRecipes();
        }
        if (ArtificeConfig.resourceRecipes) {
            ArtificeRecipes.registerResourceRecipes();
        }
        if (ArtificeConfig.floraRecipes) {
            ArtificeRecipes.registerDyeRecipes();
        }
        if (ArtificeConfig.sledgeRecipes) {
            ArtificeRecipes.registerSledgeRecipes();
        }
        if (ArtificeConfig.frameRecipes) {
            ArtificeRecipes.registerFrameRecipes();
        }
        if (ArtificeConfig.detectorRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockDetector, 1, 0), new Object[]{" Q ", "YXY", " Y ", Character.valueOf('Y'), new ItemStack(Items.field_151007_F, 1, 0), Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 0), Character.valueOf('Q'), new ItemStack(Items.field_151137_ax, 1, 0)}));
        }
        if (ArtificeConfig.steelSmelting) {
            ArtificeRecipes.registerSteelRecipes();
        }
        if (ArtificeConfig.blastWallRecipes) {
            ArtificeRecipes.registerBlastWallRecipes();
        }
        if (ArtificeConfig.glassWallRecipes) {
            ArtificeRecipes.registerGlassWallRecipes();
        }
        if (ArtificeConfig.scaffoldRecipes) {
            ArtificeRecipes.registerScaffoldRecipes();
        }
        if (ArtificeConfig.boxRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemBox, 16, 0), new Object[]{" Y ", "YXY", " Y ", Character.valueOf('Y'), "plankWood", Character.valueOf('X'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new RecipeBox());
            RecipeSorter.register((String)"artifice:box", RecipeBox.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
            MinecraftForge.EVENT_BUS.register((Object)new BoxCraftingHandler());
        }
        if (ArtificeConfig.sickleRecipes) {
            ArtificeRecipes.registerSickleRecipes();
        }
        if (ArtificeConfig.coinMinting) {
            ArtificeRecipes.registerCoinMinting();
        }
        if (ArtificeConfig.coinChanging) {
            ArtificeRecipes.registerCoinChanging();
        }
        if (ArtificeConfig.coinSmelting) {
            ArtificeRecipes.registerCoinSmelting();
        }
        if (ArtificeConfig.upgradeRecipes) {
            ArtificeRecipes.registerUpgrades();
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade());
            RecipeSorter.register((String)"artifice:upgrades", RecipeUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (ArtificeConfig.alternateSteel) {
            ArtificeRecipes.registerAlternateSteelRecipes();
        }
        if (ArtificeConfig.convenienceRecipes) {
            ArtificeRecipes.registerConvenienceRecipes();
        }
        if (ArtificeConfig.lampRecipes) {
            ArtificeRecipes.registerLampRecipes();
        }
        if (ArtificeConfig.enderOreRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151079_bi, 1, 0), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Item)ArtificeItems.itemResource, 1, 2)}));
        }
        if (ArtificeConfig.glowSandRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlowSand, 8, 0), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), new ItemStack((Block)Blocks.field_150354_m, 1, 0), Character.valueOf('Y'), Items.field_151114_aO}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlowSand, 8, 1), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), new ItemStack((Block)Blocks.field_150354_m, 1, 1), Character.valueOf('Y'), Items.field_151114_aO}));
        }
        if (ArtificeConfig.coloredTorchRecipes) {
            String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
            for (int i = 0; i < 16; ++i) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockColoredTorches[i], 8, 0), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150478_aa, Character.valueOf('Y'), "dye" + dyes[15 - i]}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Blocks.field_150478_aa, new Object[]{new ItemStack((Block)ArtificeBlocks.blockColoredTorches[i], 1, 0)}));
            }
        }
        if (ArtificeConfig.attunedRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockAttunedRedstoneReceiver), new Object[]{" Y ", "YXY", " Y ", Character.valueOf('Y'), Items.field_151079_bi, Character.valueOf('X'), Blocks.field_150451_bX}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockAttunedRedstoneTransmitter), new Object[]{"YYY", "YXY", "YYY", Character.valueOf('Y'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151079_bi}));
        }
        if (ArtificeConfig.logicRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 0), new Object[]{" Y ", "YXY", " Y ", Character.valueOf('Y'), Items.field_151128_bU, Character.valueOf('X'), Blocks.field_150451_bX}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 0), new Object[]{new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 1)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 1), new Object[]{new ItemStack((Block)ArtificeBlocks.blockLogicRedstone, 1, 0)}));
        }
        if (ArtificeConfig.craftKitRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCraftKit, 1, 0), new Object[]{"stickWood", "plankWood", "plankWood", "plankWood"}));
        }
        if (ArtificeConfig.uraniumBlockRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemResource, 9, 3), new Object[]{"blockUranium"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockUranium, 1, 1), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotUranium"}));
        }
        if (ArtificeConfig.nuclearBatteryRecipe) {
            ItemStack stack = new ItemStack((Block)ArtificeBlocks.blockNuclearBattery, 1, 0);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("charge", ArtificeConfig.nuclearBatteryCapacity);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stack, new Object[]{"CRC", "PUP", "CWC", Character.valueOf('C'), "cobblestone", Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('U'), "blockUranium", Character.valueOf('W'), Items.field_151131_as}));
        }
        if (ArtificeConfig.heatingCoilRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockHeatingCoil, 1, 0), new Object[]{"RIR", "INI", "RIR", Character.valueOf('N'), Blocks.field_150385_bj, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax}));
        }
    }

    private static void registerConvenienceRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150417_aV, 1, 0), 0.0f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150417_aV, 2, 3), new Object[]{"X", "X", Character.valueOf('X'), new ItemStack(Blocks.field_150417_aV, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150417_aV, 8, 1), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), new ItemStack(Blocks.field_150417_aV, 1, 0), Character.valueOf('Y'), new ItemStack(Items.field_151131_as)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150341_Y, 8, 0), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), new ItemStack(Blocks.field_150347_e), Character.valueOf('Y'), new ItemStack(Items.field_151131_as)}));
    }

    private static void registerAlternateSteelRecipes() {
        int cost = ArtificeConfig.alternateSteelRequirement;
        if (cost < 1) {
            cost = 1;
        }
        if (cost > 8) {
            cost = 8;
        }
        Object[] reagents = new Object[cost + 1];
        ItemStack fuel = new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE);
        reagents[0] = Items.field_151042_j;
        for (int i = 1; i < cost + 1; ++i) {
            reagents[i] = fuel.func_77946_l();
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 1), reagents));
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 1), new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 0), 1.0f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockSteel, 1, 0), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemSteelIngot, 9, 0), new Object[]{new ItemStack((Block)ArtificeBlocks.blockSteel, 1, 0)}));
    }

    private static void registerUpgrades() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 0), new Object[]{" Z ", "YXQ", "   ", Character.valueOf('X'), Items.field_151044_h, Character.valueOf('Y'), Items.field_151042_j, Character.valueOf('Q'), Blocks.field_150348_b, Character.valueOf('Z'), Items.field_151145_ak}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 1), new Object[]{"   ", "XQZ", " Y ", Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Q'), Items.field_151116_aA, Character.valueOf('Z'), Items.field_151042_j, Character.valueOf('Y'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 2), new Object[]{"   ", "YXZ", " X ", Character.valueOf('X'), "stickWood", Character.valueOf('Y'), Items.field_151116_aA, Character.valueOf('Z'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 3), new Object[]{"  X", " X ", "X  ", Character.valueOf('X'), Items.field_151007_F}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 4), new Object[]{" X ", " X ", " Y ", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), Blocks.field_150348_b}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 5), new Object[]{"   ", "XXX", " Y ", Character.valueOf('X'), Blocks.field_150411_aY, Character.valueOf('Y'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 6), new Object[]{"   ", "YXY", " X ", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), Items.field_151007_F}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 7), new Object[]{"   ", "YXY", " X ", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), Items.field_151007_F}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 8), new Object[]{"   ", "X X", "Y Y", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Y'), Items.field_151123_aH}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 9), new Object[]{" X ", " Y ", " Q ", Character.valueOf('Q'), Items.field_151054_z, Character.valueOf('Y'), Items.field_151123_aH, Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 15)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 10), new Object[]{"   ", "YXQ", " X ", Character.valueOf('X'), Items.field_151123_aH, Character.valueOf('Y'), Items.field_151116_aA, Character.valueOf('Q'), Items.field_151007_F}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 11), new Object[]{" Q ", " Y ", " X ", Character.valueOf('Q'), Items.field_151007_F, Character.valueOf('Y'), Items.field_151116_aA, Character.valueOf('X'), Items.field_151133_ar}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemUpgrade, 1, 12), new Object[]{" Q ", "XYX", " Z ", Character.valueOf('Y'), Blocks.field_150359_w, Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Z'), Items.field_151042_j, Character.valueOf('Q'), Items.field_151007_F}));
    }

    private static void registerCoinMinting() {
        String[] nuggets = new String[]{"nuggetCopper", "nuggetSilver", "nuggetGold", "nuggetPlatinum"};
        for (int i = 0; i < nuggets.length; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 3, i), new Object[]{nuggets[i], nuggets[i], nuggets[i]}));
        }
    }

    private static void registerCoinChanging() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 1, 1), new Object[]{"coinCopper", "coinCopper", "coinCopper", "coinCopper"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 1, 2), new Object[]{"coinSilver", "coinSilver", "coinSilver", "coinSilver"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 1, 3), new Object[]{"coinGold", "coinGold", "coinGold", "coinGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 4, 0), new Object[]{"coinSilver"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 4, 1), new Object[]{"coinGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemCoin, 4, 2), new Object[]{"coinPlatinum"}));
    }

    private static void registerCoinSmelting() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ArtificeItems.itemCoin, 1, 0), new ItemStack((Item)ArtificeItems.itemNugget, 1, 0), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ArtificeItems.itemCoin, 1, 1), new ItemStack((Item)ArtificeItems.itemNugget, 1, 1), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ArtificeItems.itemCoin, 1, 2), new ItemStack(Items.field_151074_bl, 1, 0), 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ArtificeItems.itemCoin, 1, 3), new ItemStack((Item)ArtificeItems.itemNugget, 1, 2), 0.0f);
    }

    private static void registerSickleRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSickleWood, 1, 0), new Object[]{"X ", " X", "Y ", Character.valueOf('X'), "plankWood", Character.valueOf('Y'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSickleStone, 1, 0), new Object[]{"X ", " X", "Y ", Character.valueOf('X'), Blocks.field_150347_e, Character.valueOf('Y'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSickleIron, 1, 0), new Object[]{"X ", " X", "Y ", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSickleGold, 1, 0), new Object[]{"X ", " X", "Y ", Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSickleDiamond, 1, 0), new Object[]{"X ", " X", "Y ", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('Y'), "stickWood"}));
    }

    private static void registerScaffoldRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockScaffold, 8, 0), new Object[]{" Y ", " X ", " Y ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 0), Character.valueOf('Y'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockScaffold, 8, 1), new Object[]{" Y ", " X ", " Y ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 1), Character.valueOf('Y'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockScaffold, 8, 2), new Object[]{" Y ", " X ", " Y ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 2), Character.valueOf('Y'), new ItemStack(Items.field_151042_j, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockScaffold, 8, 3), new Object[]{" Y ", " X ", " Y ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 3), Character.valueOf('Y'), "ingotSteel"}));
    }

    private static void registerGlassWallRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 2, 0), new Object[]{"YYY", " X ", " Z ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 0), Character.valueOf('Y'), Blocks.field_150410_aZ, Character.valueOf('Z'), Items.field_151119_aD}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 0), new Object[]{new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 0), "dyeBlack"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 2, 1), new Object[]{"YYY", " X ", " Z ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 1), Character.valueOf('Z'), Items.field_151119_aD, Character.valueOf('Y'), Blocks.field_150359_w}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 1), new Object[]{new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 1), "dyeBlack"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 4, 2), new Object[]{"QQQ", "YXY", " Z ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 2), Character.valueOf('Q'), Blocks.field_150359_w, Character.valueOf('Y'), Blocks.field_150343_Z, Character.valueOf('Z'), Items.field_151129_at}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 2), new Object[]{new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 2), "dyeBlack"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWall, 4, 3), new Object[]{"YYY", "QXQ", "YYY", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 3), Character.valueOf('Q'), Blocks.field_150359_w, Character.valueOf('Y'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockGlassWallDark, 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockGlassWall, 1, 3), "dyeBlack"}));
    }

    private static void registerBlastWallRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockReinforced, 2, 0), new Object[]{"   ", "YXY", " Z ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 0), Character.valueOf('Y'), Blocks.field_150417_aV, Character.valueOf('Z'), Items.field_151119_aD}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockReinforced, 2, 1), new Object[]{"   ", "YXY", " Z ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 1), Character.valueOf('Y'), Blocks.field_150336_V, Character.valueOf('Z'), Items.field_151119_aD}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockReinforced, 4, 2), new Object[]{"   ", "YXY", " Z ", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 2), Character.valueOf('Y'), Blocks.field_150343_Z, Character.valueOf('Z'), Items.field_151129_at}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockReinforced, 4, 3), new Object[]{"YYY", "YXY", "YYY", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockFrame, 1, 3), Character.valueOf('Y'), "ingotSteel"}));
    }

    private static void registerSteelRecipes() {
        GameRegistry.addSmelting((Item)Items.field_151042_j, (ItemStack)new ItemStack((Item)ArtificeItems.itemSteelIngot, 1, 0), (float)1.0f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockSteel, 1, 0), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemSteelIngot, 9, 0), new Object[]{new ItemStack((Block)ArtificeBlocks.blockSteel, 1, 0)}));
    }

    private static void registerFrameRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockFrame, 8, 0), new Object[]{"XYX", "YYY", "XYX", Character.valueOf('X'), "plankWood", Character.valueOf('Y'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockFrame, 8, 1), new Object[]{"XYX", "YYY", "XYX", Character.valueOf('X'), "plankWood", Character.valueOf('Y'), new ItemStack(Items.field_151042_j, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockFrame, 16, 2), new Object[]{"X X", " Y ", "X X", Character.valueOf('X'), new ItemStack(Items.field_151042_j, 1, 0), Character.valueOf('Y'), new ItemStack(Blocks.field_150339_S, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockFrame, 16, 3), new Object[]{"X X", " Y ", "X X", Character.valueOf('X'), "ingotSteel", Character.valueOf('Y'), "blockSteel"}));
    }

    private static void registerSledgeRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSledgeWood, 1, 0), new Object[]{" YX", " XY", "X  ", Character.valueOf('X'), "stickWood", Character.valueOf('Y'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSledgeStone, 1, 0), new Object[]{" YX", " XY", "X  ", Character.valueOf('X'), "stickWood", Character.valueOf('Y'), new ItemStack(Blocks.field_150347_e, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSledgeIron, 1, 0), new Object[]{" YX", " XY", "X  ", Character.valueOf('X'), "stickWood", Character.valueOf('Y'), new ItemStack(Items.field_151042_j, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSledgeGold, 1, 0), new Object[]{" YX", " XY", "X  ", Character.valueOf('X'), "stickWood", Character.valueOf('Y'), new ItemStack(Items.field_151043_k, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ArtificeItems.itemSledgeDiamond, 1, 0), new Object[]{" YX", " XY", "X  ", Character.valueOf('X'), "stickWood", Character.valueOf('Y'), new ItemStack(Items.field_151045_i, 1, 0)}));
    }

    private static void registerDyeRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemDye, 2, 1), new Object[]{new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 2, 2), new Object[]{"dyeBlue", "dyeYellow"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemDye, 2, 2), new Object[]{new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemDye, 2, 0), new Object[]{new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)ArtificeItems.itemDye, 2, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockFlora, 1, 3)}));
    }

    private static void registerBasaltRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 1), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 0), 0.1f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasalt, 4, 2), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasalt, 4, 3), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasalt, 2, 5), new Object[]{"X", "X", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 4), new Object[]{new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 4)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltBrickStairs, 4, 0), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltCobbleStairs, 4, 0), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 6, 0), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 6, 1), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 6, 2), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 6, 3), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockBasalt, 1, 4)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 1, 2), new Object[]{new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockBasaltSlab, 1, 2)}));
    }

    private static void registerMarbleRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 1), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 0), 0.1f);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarble, 4, 2), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarble, 4, 3), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarble, 2, 5), new Object[]{"X", "X", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 4), new Object[]{new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 4)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleBrickStairs, 4, 0), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleCobbleStairs, 4, 0), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 6, 0), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 6, 1), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 6, 2), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 6, 3), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockMarble, 1, 4)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 1, 2), new Object[]{new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockMarbleSlab, 1, 2)}));
    }

    private static void registerLimestoneRecipes() {
        for (int i = 0; i < ArtificeBlocks.blockLimestones.length; ++i) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 1), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 0), 0.1f);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 4, 2), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 0)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 4, 3), new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 2)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 2, 5), new Object[]{"X", "X", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 2)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 4), new Object[]{new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 3)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 4)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneBrickStairs[i], 4, 0), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 2)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneCobbleStairs[i], 4, 0), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 1)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 6, 0), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 2)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 6, 1), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 1)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 6, 2), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 3)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 6, 3), new Object[]{"XXX", Character.valueOf('X'), new ItemStack((Block)ArtificeBlocks.blockLimestones[i], 1, 4)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 1, 2), new Object[]{new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 1, 3)}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 1, 3), new Object[]{new ItemStack((Block)ArtificeBlocks.blockLimestoneSlabs[i], 1, 2)}));
        }
    }

    private static void registerLampRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[0], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeWhite"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[1], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeOrange"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[2], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeMagenta"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[3], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeLightBlue"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[4], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeYellow"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[5], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeLime"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[6], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyePink"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[7], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeGray"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[8], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeLightGray"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[9], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeCyan"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[10], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyePurple"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[11], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeBlue"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[12], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeBrown"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[13], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeGreen"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[14], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeRed"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[15], 1, 0), new Object[]{"blockGlass", "dustRedstone", "dustGlowstone", "dustGlowstone", "dyeBlack"}));
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLampsInverted[i], 1, 0), new Object[]{ArtificeBlocks.blockLamps[i]}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ArtificeBlocks.blockLamps[i], 1, 0), new Object[]{ArtificeBlocks.blockLampsInverted[i]}));
        }
    }

    private static void registerOreRecipes() {
        for (int i = 0; i < ArtificeBlocks.blockOres.length; ++i) {
            for (int j = 0; j < ArtificeBlocks.rockBlocks.length; ++j) {
                ItemStack stack = new ItemStack((Block)ArtificeBlocks.blockOres[i], 1, j);
                if (ItemHelper.getOreName((ItemStack)stack).equals("oreCoal")) {
                    ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151044_h), (ItemStack)stack, (float)0.1f);
                    continue;
                }
                if (ItemHelper.getOreName((ItemStack)stack).equals("oreIron")) {
                    ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151042_j), (ItemStack)stack, (float)0.7f);
                    continue;
                }
                if (ItemHelper.getOreName((ItemStack)stack).equals("oreLapis")) {
                    ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151100_aR, 1, 4), (ItemStack)stack, (float)0.2f);
                    continue;
                }
                if (ItemHelper.getOreName((ItemStack)stack).equals("oreGold")) {
                    ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151043_k), (ItemStack)stack, (float)1.0f);
                    continue;
                }
                if (ItemHelper.getOreName((ItemStack)stack).equals("oreDiamond")) {
                    ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151045_i), (ItemStack)stack, (float)1.0f);
                    continue;
                }
                if (ItemHelper.getOreName((ItemStack)stack).equals("oreRedstone")) {
                    ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151137_ax), (ItemStack)stack, (float)0.7f);
                    continue;
                }
                if (!ItemHelper.getOreName((ItemStack)stack).equals("oreEmerald")) continue;
                ItemHelper.addSmelting((ItemStack)new ItemStack(Items.field_151166_bC), (ItemStack)stack, (float)1.0f);
            }
        }
    }

    private static void registerResourceRecipes() {
        ItemHelper.addStorageRecipe((ItemStack)new ItemStack((Block)ArtificeBlocks.blockSulfur, 1, 1), (ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 0));
        ItemHelper.addReverseStorageRecipe((ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 0), (ItemStack)new ItemStack((Block)ArtificeBlocks.blockSulfur, 1, 1));
        ItemHelper.addSmelting((ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 0), (ItemStack)new ItemStack((Block)ArtificeBlocks.blockSulfur, 1, 0), (float)0.7f);
        for (int i = 0; i < ArtificeBlocks.rockBlocks.length; ++i) {
            ItemHelper.addSmelting((ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 0), (ItemStack)new ItemStack((Block)ArtificeBlocks.blockOres[12], 1, i), (float)0.7f);
        }
        ItemHelper.addStorageRecipe((ItemStack)new ItemStack((Block)ArtificeBlocks.blockNiter, 1, 1), (ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 1));
        ItemHelper.addReverseStorageRecipe((ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 1), (ItemStack)new ItemStack((Block)ArtificeBlocks.blockNiter, 1, 1));
        ItemHelper.addSmelting((ItemStack)new ItemStack((Item)ArtificeItems.itemResource, 1, 1), (ItemStack)new ItemStack((Block)ArtificeBlocks.blockNiter, 1, 0), (float)0.7f);
    }
}

