/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.item;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.util.NameMetaPair;

public class ItemSledge
extends ItemTool {
    private IIcon icon;
    private int lossChance;

    public ItemSledge(Item.ToolMaterial mat) {
        super(2.0f, mat, null);
        this.func_77637_a(ArtificeCore.mainTab);
        if (mat == Item.ToolMaterial.EMERALD) {
            this.func_77656_e(mat.func_77997_a() / 32);
        } else {
            this.func_77656_e(mat.func_77997_a() / 16);
        }
        this.func_77655_b("artifice.sledge." + this.field_77862_b.toString().toLowerCase(Locale.ENGLISH));
        this.lossChance = this.getLossChance(mat);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public int getLossChance(Item.ToolMaterial mat) {
        switch (mat) {
            case EMERALD: {
                return 20;
            }
            case GOLD: {
                return 25;
            }
            case IRON: {
                return 30;
            }
            case STONE: {
                return 40;
            }
            case WOOD: {
                return 50;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean advancedTooltips) {
        if (!ArtificeConfig.tooltips) {
            return;
        }
        NameMetaPair pair = new NameMetaPair(stack.func_77973_b(), 0);
        if (ArtificeRegistry.getTooltipMap().get(pair) != null) {
            for (String s : ArtificeRegistry.getTooltipMap().get(pair)) {
                if (!ArtificeConfig.flavorText && s.startsWith(ArtificeTooltips.commentCode)) continue;
                infoList.add(s);
            }
        }
    }

    public boolean func_150897_b(Block block) {
        return true;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return this.field_77862_b.func_77998_b();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icon = TextureHandler.registerIcon(reg, "sledge_" + this.field_77862_b.toString().toLowerCase(Locale.ENGLISH), "sledge");
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        try {
            ArrayList<ItemStack> dropped = ItemSledge.getIngredientsForBlock(world, x, y, z, player.func_70694_bm());
            if (dropped != null) {
                for (ItemStack is : dropped) {
                    if (world.field_73012_v.nextInt(100) <= this.lossChance) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, is.func_77946_l()));
                }
                world.func_147468_f(x, y, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
        }
        stack.func_77972_a(1, entity);
        return true;
    }

    public static ArrayList<ItemStack> getIngredientsForBlock(World world, int x, int y, int z, ItemStack held) {
        if (world.func_147437_c(x, y, z)) {
            return null;
        }
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        ArrayList drops = b.getDrops(world, x, y, z, meta, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held));
        ArrayList<ItemStack> smashedDrops = new ArrayList<ItemStack>();
        for (ItemStack normalDrop : drops) {
            ArrayList<ItemStack> ingredients = ItemSledge.getIngredientsForItemStack(normalDrop, world.field_73012_v);
            if (ingredients != null) {
                smashedDrops.addAll(ingredients);
                continue;
            }
            smashedDrops.add(normalDrop);
        }
        return smashedDrops;
    }

    private static ArrayList<ItemStack> getIngredientsForItemStack(ItemStack input, Random rand) {
        if (input != null) {
            for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) || recipe.func_77571_b() == null || !recipe.func_77571_b().func_77977_a().equals(input.func_77977_a()) || recipe.func_77571_b().func_77981_g() && recipe.func_77571_b().func_77960_j() != input.func_77960_j()) continue;
                if (recipe.func_77571_b().field_77994_a > 1) {
                    return null;
                }
                return ItemSledge.getIngredientsForRecipe(recipe);
            }
        }
        return null;
    }

    private static ArrayList<ItemStack> getIngredientsForRecipe(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return ItemSledge.getIngredientsForShapedRecipe((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return ItemSledge.getIngredientsForShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        return null;
    }

    private static ArrayList<ItemStack> getIngredientsForShapedRecipe(ShapedRecipes recipe) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (ItemStack input : recipe.field_77574_d) {
            ingredients.add(input);
        }
        return ingredients;
    }

    private static ArrayList<ItemStack> getIngredientsForShapedOreRecipe(ShapedOreRecipe recipe) {
        try {
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            Object[] objects = (Object[])ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)recipe, (int)3);
            ItemStack[] items = new ItemStack[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof ItemStack) {
                    items[i] = (ItemStack)objects[i];
                }
                if (!(objects[i] instanceof ArrayList) || ((ArrayList)objects[i]).size() <= 0) continue;
                items[i] = (ItemStack)((ArrayList)objects[i]).get(0);
            }
            for (ItemStack input : items) {
                if (input == null) continue;
                ingredients.add(input);
            }
            return ingredients;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }
}

