/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.NameMetaPair;

public class ItemSickle
extends ItemTool {
    private IIcon icon;
    private int radius;

    public ItemSickle(Item.ToolMaterial mat) {
        super(3.0f, mat, null);
        this.func_77637_a(ArtificeCore.mainTab);
        this.func_77656_e(mat.func_77997_a() / 2);
        this.func_77655_b("artifice.sickle." + this.field_77862_b.toString().toLowerCase(Locale.ENGLISH));
        this.radius = this.getRadius(mat);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public int getRadius(Item.ToolMaterial mat) {
        switch (mat) {
            case EMERALD: {
                return 5;
            }
            case GOLD: {
                return 4;
            }
            case IRON: {
                return 3;
            }
            case STONE: {
                return 2;
            }
            case WOOD: {
                return 1;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean advancedTooltips) {
        if (!ArtificeConfig.tooltips) {
            return;
        }
        NameMetaPair pair = new NameMetaPair(stack.func_77973_b(), 0);
        if (ArtificeRegistry.getTooltipMap().get(pair) != null) {
            for (String s : ArtificeRegistry.getTooltipMap().get(pair)) {
                if (!ArtificeConfig.flavorText && s.startsWith(ArtificeTooltips.commentCode)) continue;
                infoList.add(s);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icon = TextureHandler.registerIcon(reg, "sickle_" + this.field_77862_b.toString().toLowerCase(Locale.ENGLISH), "sickle");
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        BlockCoord coord = new BlockCoord(x, y, z);
        World world = player.field_70170_p;
        Block block = coord.getBlock((IBlockAccess)world);
        int radius = this.getRadius(this.field_77862_b);
        if (block instanceof IPlantable) {
            int count = 0;
            for (int i = -radius; i < radius; ++i) {
                for (int k = -radius; k < radius; ++k) {
                    Block b = world.func_147439_a(x + i, y, z + k);
                    int meta = world.func_72805_g(x + i, y, z + k);
                    if (!(b instanceof IPlantable) || !(coord.getDistance(x + i, y, z + k) <= (float)radius) || !b.canHarvestBlock(player, meta)) continue;
                    b.func_149636_a(world, player, x + i, y, z + k, meta);
                    world.func_147468_f(x + i, y, z + k);
                    ++count;
                }
            }
            if (!world.field_72995_K) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (stack.func_96631_a(count / 2, field_77697_d)) {
                player.func_71028_bD();
            }
            return true;
        }
        if (block != null && block.isLeaves((IBlockAccess)world, x, y, z)) {
            int count = 0;
            for (BlockCoord c : coord.getRadiusBlocks(radius)) {
                Block b = world.func_147439_a(c.x, c.y, c.z);
                int meta = world.func_72805_g(c.x, c.y, c.z);
                if (b == null || !(coord.getDistance(c) <= (float)radius) || !b.isLeaves((IBlockAccess)world, c.x, c.y, c.z)) continue;
                if (b.canHarvestBlock(player, meta)) {
                    b.func_149636_a(world, player, c.x, c.y, c.z, meta);
                }
                world.func_147468_f(c.x, c.y, c.z);
                ++count;
            }
            if (!world.field_72995_K) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            stack.func_77972_a(count / 4, (EntityLivingBase)player);
            if (stack.field_77994_a <= 0) {
                player.func_71028_bD();
            }
            return true;
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }
}

