/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.world;

import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.BlockArtifice;
import shukaro.artifice.block.world.ItemBlockOre;
import shukaro.artifice.net.ClientProxy;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.util.NameMetaPair;

public class BlockOre
extends BlockArtifice {
    private IIcon icon;
    private String name;
    private Integer color;
    private boolean glowing;
    private int index;

    public BlockOre(String name, int index) {
        this(name, false, null, index);
    }

    public BlockOre(String name, boolean glowing, Integer color, int index) {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        if (glowing) {
            this.func_149663_c("artifice." + name.toLowerCase(Locale.ENGLISH) + ".glowing");
        } else {
            this.func_149663_c("artifice." + name.toLowerCase(Locale.ENGLISH));
        }
        this.func_149647_a(ArtificeCore.worldTab);
        this.name = name;
        this.index = index;
        this.glowing = glowing;
        if (color != null) {
            this.color = color;
        }
        this.setHarvestLevel("pickaxe", 2);
        if (name.equals("oreCoal") || name.equals("oreSulfur")) {
            this.setHarvestLevel("pickaxe", 0);
        } else if (name.equals("oreIron") || name.equals("oreLapis") || name.equals("oreCopper") || name.equals("oreTin")) {
            this.setHarvestLevel("pickaxe", 1);
        } else if (name.equals("oreGold") || name.equals("oreDiamond") || name.equals("oreRedstone") || name.equals("oreEmerald")) {
            this.setHarvestLevel("pickaxe", 2);
        }
        if (this.glowing) {
            this.func_149715_a(0.625f);
            this.func_149675_a(true);
        }
        GameRegistry.registerBlock((Block)this, ItemBlockOre.class, (String)this.func_149739_a());
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int fortune) {
        super.func_149636_a(world, entityplayer, x, y, z, fortune);
        if (!this.name.equals("oreEnder")) {
            return;
        }
        if (!world.field_72995_K && world.field_73012_v.nextInt(100) < 20 && ArtificeConfig.spawnEndermen && !EnchantmentHelper.func_77502_d((EntityLivingBase)entityplayer)) {
            int tries = world.field_73012_v.nextInt(20);
            for (int i = 0; i < tries; ++i) {
                int spawnZ;
                int spawnY;
                int spawnX = x + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3);
                if (!this.canSpawnEnder(world, spawnX, spawnY = y + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3), spawnZ = z + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3))) continue;
                EntityEnderman ender = new EntityEnderman(world);
                ender.func_70012_b((double)spawnX + world.field_73012_v.nextDouble(), (double)spawnY + world.field_73012_v.nextDouble(), (double)spawnZ + world.field_73012_v.nextDouble(), world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
                world.func_72838_d((Entity)ender);
                ender.func_70656_aK();
                ender.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                break;
            }
        }
    }

    private boolean canSpawnEnder(World world, int x, int y, int z) {
        return !(world.func_147439_a(x, y, z) != null && !world.func_147437_c(x, y, z) || world.func_147439_a(x, y + 1, z) != null && !world.func_147437_c(x, y + 1, z) || world.func_147439_a(x, y + 2, z) != null && !world.func_147437_c(x, y + 2, z));
    }

    public int func_149738_a(World p_149738_1_) {
        return 30;
    }

    private void activate(World world, int x, int y, int z) {
        if (this.color == null) {
            return;
        }
        this.sparkle(world, x, y, z);
        if (!this.glowing) {
            world.func_147465_d(x, y, z, (Block)ArtificeBlocks.blockOresGlowing[this.index], world.func_72805_g(x, y, z), 3);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.glowing) {
            world.func_147465_d(x, y, z, (Block)ArtificeBlocks.blockOres[this.index], world.func_72805_g(x, y, z), 3);
        }
    }

    private void sparkle(World world, int x, int y, int z) {
        if (this.index == 5) {
            Random random = world.field_73012_v;
            double d0 = 0.0625;
            for (int l = 0; l < 6; ++l) {
                double d1 = (float)x + random.nextFloat();
                double d2 = (float)y + random.nextFloat();
                double d3 = (float)z + random.nextFloat();
                if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                    d2 = (double)(y + 1) + d0;
                }
                if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                    d2 = (double)(y + 0) - d0;
                }
                if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                    d3 = (double)(z + 1) + d0;
                }
                if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                    d3 = (double)(z + 0) - d0;
                }
                if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                    d1 = (double)(x + 1) + d0;
                }
                if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                    d1 = (double)(x + 0) - d0;
                }
                if (!(d1 < (double)x || d1 > (double)(x + 1) || d2 < 0.0 || d2 > (double)(y + 1) || d3 < (double)z) && !(d3 > (double)(z + 1))) continue;
                world.func_72869_a("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
            }
        }
        if (this.index == 13) {
            for (int i = 0; i < 4; ++i) {
                double dx = (double)x + 0.5 + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                double dy = (double)y + 0.5 + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                double dz = (double)z + 0.5 + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                world.func_72869_a("portal", dx, dy, dz, world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.glowing) {
            this.sparkle(world, x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        this.activate(world, x, y, z);
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.activate(world, x, y, z);
        super.func_149724_b(world, x, y, z, entity);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.activate(world, x, y, z);
        super.func_149699_a(world, x, y, z, player);
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        if (this.name.equals("oreCoal")) {
            return Blocks.field_150365_q.quantityDropped(0, fortune, rand);
        }
        if (this.name.equals("oreLapis")) {
            return Blocks.field_150369_x.quantityDropped(0, fortune, rand);
        }
        if (this.name.equals("oreDiamond")) {
            return Blocks.field_150482_ag.quantityDropped(0, fortune, rand);
        }
        if (this.name.equals("oreRedstone")) {
            return Blocks.field_150450_ax.quantityDropped(0, fortune, rand);
        }
        if (this.name.equals("oreEmerald")) {
            return Blocks.field_150412_bA.quantityDropped(0, fortune, rand);
        }
        if (this.name.equals("oreSulfur")) {
            return ArtificeBlocks.blockSulfur.quantityDropped(0, fortune, rand);
        }
        if (this.name.equals("oreEnder")) {
            return ArtificeBlocks.blockEnderOre.quantityDropped(0, fortune, rand);
        }
        return 1;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        if (this.name.equals("oreCoal")) {
            return Blocks.field_150365_q.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreIron")) {
            return Blocks.field_150366_p.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreLapis")) {
            return Blocks.field_150369_x.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreGold")) {
            return Blocks.field_150352_o.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreDiamond")) {
            return Blocks.field_150482_ag.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreRedstone")) {
            return Blocks.field_150450_ax.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreEmerald")) {
            return Blocks.field_150412_bA.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreSulfur")) {
            return ArtificeBlocks.blockSulfur.func_149650_a(0, rand, fortune);
        }
        if (this.name.equals("oreEnder")) {
            return ArtificeBlocks.blockEnderOre.func_149650_a(0, rand, fortune);
        }
        return ItemHelper.getOre((String)this.name).func_77973_b();
    }

    @Override
    public int func_149692_a(int meta) {
        if (this.name.equals("oreLapis")) {
            return Blocks.field_150369_x.func_149692_a(meta);
        }
        if (this.name.equals("oreCoal") || this.name.equals("oreIron") || this.name.equals("oreGold") || this.name.equals("oreDiamond") || this.name.equals("oreRedstone") || this.name.equals("oreEmerald") || this.name.equals("oreSulfur")) {
            return 0;
        }
        if (this.name.equals("oreEnder")) {
            return ArtificeBlocks.blockEnderOre.func_149692_a(meta);
        }
        return ItemHelper.getOre((String)this.name).func_77960_j();
    }

    public int getExpDrop(IBlockAccess world, int meta, int fortune) {
        if (this.name.equals("oreCoal")) {
            return Blocks.field_150365_q.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreIron")) {
            return Blocks.field_150366_p.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreLapis")) {
            return Blocks.field_150369_x.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreGold")) {
            return Blocks.field_150352_o.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreDiamond")) {
            return Blocks.field_150482_ag.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreRedstone")) {
            return Blocks.field_150450_ax.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreEmerald")) {
            return Blocks.field_150412_bA.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreSulfur")) {
            return ArtificeBlocks.blockSulfur.getExpDrop(world, meta, fortune);
        }
        if (this.name.equals("oreEnder")) {
            return ArtificeBlocks.blockEnderOre.getExpDrop(world, meta, fortune);
        }
        if (Block.func_149634_a((Item)ItemHelper.getOre((String)this.name).func_77973_b()) != this) {
            return Block.func_149634_a((Item)ItemHelper.getOre((String)this.name).func_77973_b()).getExpDrop(world, meta, fortune);
        }
        return 0;
    }

    public ItemStack func_149644_j(int p_149644_1_) {
        if (this.name.equals("oreCoal")) {
            return new ItemStack(Blocks.field_150365_q);
        }
        if (this.name.equals("oreIron")) {
            return new ItemStack(Blocks.field_150366_p);
        }
        if (this.name.equals("oreLapis")) {
            return new ItemStack(Blocks.field_150369_x);
        }
        if (this.name.equals("oreGold")) {
            return new ItemStack(Blocks.field_150352_o);
        }
        if (this.name.equals("oreDiamond")) {
            return new ItemStack(Blocks.field_150482_ag);
        }
        if (this.name.equals("oreRedstone")) {
            return new ItemStack(Blocks.field_150450_ax);
        }
        if (this.name.equals("oreEmerald")) {
            return new ItemStack(Blocks.field_150412_bA);
        }
        if (this.name.equals("oreSulfur")) {
            return new ItemStack((Block)ArtificeBlocks.blockSulfur);
        }
        if (this.name.equals("oreEnder")) {
            return new ItemStack((Block)ArtificeBlocks.blockEnderOre);
        }
        return new ItemStack(Block.func_149634_a((Item)ItemHelper.getOre((String)this.name).func_77973_b()));
    }

    @Override
    public void func_149651_a(IIconRegister reg) {
        this.icon = TextureHandler.registerIcon(reg, this.name, "ores");
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.icon;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        return this.icon;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        if (!this.glowing) {
            for (int i = 0; i < ArtificeBlocks.rockBlocks.length; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return true;
    }

    public int func_149645_b() {
        return ArtificeConfig.oreRenderID;
    }

    public static NameMetaPair getOre(NameMetaPair ore, Block rock) {
        String oreName = ItemHelper.getOreName((ItemStack)ore.getStack());
        if (!oreName.equals("Unknown")) {
            for (int i = 0; i < ArtificeBlocks.rockBlocks.length; ++i) {
                if (!ArtificeBlocks.rockBlocks[i].equals(rock)) continue;
                return new NameMetaPair((Block)ArtificeBlocks.oreMappings.get((Object)oreName), i);
            }
        }
        return null;
    }

    public static class BlockOreDummy
    extends Block {
        public BlockOreDummy() {
            super(Material.field_151576_e);
        }

        public IIcon func_149691_a(int side, int meta) {
            return ArtificeBlocks.rockBlocks[meta].func_149691_a(side, 0);
        }

        public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
            int meta = block.func_72805_g(x, y, z);
            return ArtificeBlocks.rockBlocks[meta].func_149691_a(side, 0);
        }

        @SideOnly(value=Side.CLIENT)
        public int func_149741_i(int meta) {
            return ArtificeBlocks.rockBlocks[meta].func_149741_i(meta);
        }

        @SideOnly(value=Side.CLIENT)
        public int func_149720_d(IBlockAccess block, int x, int y, int z) {
            int meta = block.func_72805_g(x, y, z);
            return ArtificeBlocks.rockBlocks[meta].func_149741_i(meta);
        }
    }
}

