/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.functional;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.ItemBlockArtifice;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.tile.TileEntityNuclearBattery;
import shukaro.artifice.util.FormatCodes;
import shukaro.artifice.util.MiscUtils;

public class BlockNuclearBattery
extends Block
implements ITileEntityProvider {
    private IIcon[] icons = new IIcon[4];

    public BlockNuclearBattery() {
        super(Material.field_151573_f);
        this.func_149647_a(ArtificeCore.mainTab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("artifice.nuclearbattery");
        GameRegistry.registerBlock((Block)this, ItemBlockArtifice.class, (String)this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons[0] = TextureHandler.registerIcon(reg, "full", "nuclearbattery");
        this.icons[1] = TextureHandler.registerIcon(reg, "partial", "nuclearbattery");
        this.icons[2] = TextureHandler.registerIcon(reg, "low", "nuclearbattery");
        this.icons[3] = TextureHandler.registerIcon(reg, "empty", "nuclearbattery");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta < this.icons.length ? this.icons[meta] : this.icons[0];
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        ItemStack stack = new ItemStack(item, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("charge", ArtificeConfig.nuclearBatteryCapacity);
        stack.func_77982_d(tag);
        list.add(stack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!world.field_72995_K && player.func_70694_bm() == null && (te = world.func_147438_o(x, y, z)) instanceof TileEntityNuclearBattery) {
            TileEntityNuclearBattery teb = (TileEntityNuclearBattery)te;
            MiscUtils.addChatMessage(player, FormatCodes.Yellow.code + teb.getEnergyStored(ForgeDirection.DOWN) + FormatCodes.Reset.code + " " + StatCollector.func_74838_a((String)"chat.artifice.rf") + " @ " + FormatCodes.Aqua.code + teb.getMaxRate() + FormatCodes.Reset.code + " " + StatCollector.func_74838_a((String)"chat.artifice.rft"));
            return true;
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return (3 - meta) * 2;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.func_149689_a(world, x, y, z, living, stack);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityNuclearBattery) {
            TileEntityNuclearBattery teb = (TileEntityNuclearBattery)te;
            if (stack.func_77942_o()) {
                teb.setEnergy(stack.func_77978_p().func_74762_e("charge"));
            } else {
                teb.setEnergy(ArtificeConfig.nuclearBatteryCapacity);
            }
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity te;
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_71020_j(0.025f);
        }
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (te = world.func_147438_o(x, y, z)) instanceof TileEntityNuclearBattery) {
            ItemStack stack = new ItemStack(world.func_147439_a(x, y, z), 1, 0);
            TileEntityNuclearBattery teb = (TileEntityNuclearBattery)te;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("charge", teb.getEnergyStored(ForgeDirection.DOWN));
            stack.func_77982_d(tag);
            if (!player.field_71075_bZ.field_75098_d) {
                MiscUtils.dropStack(world, x, y, z, stack);
            }
        }
        return world.func_147468_f(x, y, z);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityNuclearBattery();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }
}

