/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.functional;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.ItemBlockArtifice;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.tile.TileEntityLogic;
import shukaro.artifice.util.FormatCodes;
import shukaro.artifice.util.MiscUtils;

public class BlockLogicRedstone
extends Block
implements ITileEntityProvider {
    private IIcon disabled;
    private IIcon output;
    private IIcon positive;
    private IIcon negative;

    public BlockLogicRedstone() {
        super(Material.field_151576_e);
        this.func_149647_a(ArtificeCore.mainTab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("artifice.logicredstone");
        GameRegistry.registerBlock((Block)this, ItemBlockArtifice.class, (String)this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.disabled = TextureHandler.registerIcon(reg, "disabled", "logic");
        this.output = TextureHandler.registerIcon(reg, "output", "logic");
        this.positive = TextureHandler.registerIcon(reg, "positive", "logic");
        this.negative = TextureHandler.registerIcon(reg, "negative", "logic");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.disabled;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityLogic) {
            TileEntityLogic tel = (TileEntityLogic)te;
            switch (tel.sides[side].ordinal()) {
                case 0: {
                    return this.disabled;
                }
                case 1: {
                    return this.output;
                }
                case 2: {
                    return this.positive;
                }
                case 3: {
                    return this.negative;
                }
            }
            return this.disabled;
        }
        return this.disabled;
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() == null) {
            TileEntity te;
            if (player.func_70093_af()) {
                side = ForgeDirection.OPPOSITES[side];
            }
            if ((te = world.func_147438_o(x, y, z)) instanceof TileEntityLogic) {
                TileEntityLogic tel = (TileEntityLogic)te;
                int i = tel.sides[side].ordinal() + 1;
                if (i > 3) {
                    i = 0;
                }
                tel.sides[side] = TileEntityLogic.SideState.values()[i];
                if (!world.field_72995_K) {
                    int meta = world.func_72805_g(x, y, z);
                    MiscUtils.addChatMessage(player, FormatCodes.Italic.code + (meta == 0 ? StatCollector.func_74838_a((String)"chat.artifice.digital") : StatCollector.func_74838_a((String)"chat.artifice.analog")) + " " + FormatCodes.Yellow.code + StatCollector.func_74838_a((String)("chat.artifice.side." + side)) + " " + FormatCodes.Reset.code + StatCollector.func_74838_a((String)"chat.artifice.set") + " " + FormatCodes.Aqua.code + StatCollector.func_74838_a((String)("chat.artifice.set." + tel.sides[side].name().toLowerCase(Locale.ENGLISH))));
                }
                tel.func_145845_h();
                world.func_147471_g(x, y, z);
                return true;
            }
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityLogic) {
            TileEntityLogic tel = (TileEntityLogic)te;
            tel.func_145845_h();
        }
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityLogic) {
            TileEntityLogic tel = (TileEntityLogic)te;
            return tel.sides[ForgeDirection.OPPOSITES[side]] == TileEntityLogic.SideState.OUTPUT ? tel.power : 0;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityLogic) {
            TileEntityLogic tel = (TileEntityLogic)te;
            switch (side) {
                case -1: {
                    return tel.sides[1] != TileEntityLogic.SideState.DISABLED;
                }
                case 0: {
                    return tel.sides[2] != TileEntityLogic.SideState.DISABLED;
                }
                case 1: {
                    return tel.sides[5] != TileEntityLogic.SideState.DISABLED;
                }
                case 2: {
                    return tel.sides[3] != TileEntityLogic.SideState.DISABLED;
                }
                case 3: {
                    return tel.sides[4] != TileEntityLogic.SideState.DISABLED;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityLogic();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }
}

