/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.functional;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.functional.ItemBlockAttunedRedstone;
import shukaro.artifice.event.Tracking;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.tile.TileEntityAttuned;
import shukaro.artifice.util.FormatCodes;
import shukaro.artifice.util.MiscUtils;

public class BlockAttunedRedstone
extends Block
implements ITileEntityProvider {
    private IIcon powered;
    private IIcon unpowered;
    private boolean transmitter;

    public BlockAttunedRedstone(boolean transmitter) {
        super(Material.field_151576_e);
        this.func_149647_a(ArtificeCore.mainTab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("artifice.attunedredstone." + (transmitter ? "transmitter" : "receiver"));
        this.transmitter = transmitter;
        GameRegistry.registerBlock((Block)this, ItemBlockAttunedRedstone.class, (String)this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.powered = TextureHandler.registerIcon(reg, "powered" + (this.transmitter ? "transmitter" : "receiver"), "attuned");
        this.unpowered = TextureHandler.registerIcon(reg, "unpowered" + (this.transmitter ? "transmitter" : "receiver"), "attuned");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.unpowered;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityAttuned) {
            return ((TileEntityAttuned)te).power > 0 ? this.powered : this.unpowered;
        }
        return this.unpowered;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!world.field_72995_K && player.func_70694_bm() == null && (te = world.func_147438_o(x, y, z)) instanceof TileEntityAttuned) {
            TileEntityAttuned tea = (TileEntityAttuned)te;
            if (tea.frequency.length() > 0) {
                MiscUtils.addChatMessage(player, FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.artifice.frequency") + " " + FormatCodes.Aqua.code + tea.frequency);
            } else {
                MiscUtils.addChatMessage(player, FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.artifice.nofrequency"));
            }
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack stack = new ItemStack(world.func_147439_a(x, y, z), 1, 0);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityAttuned) {
            TileEntityAttuned tea = (TileEntityAttuned)te;
            if (tea.frequency.length() > 0) {
                stack.func_151001_c(tea.frequency);
            }
        }
        return stack;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityAttuned) {
            TileEntityAttuned tea = (TileEntityAttuned)te;
            return this.transmitter ? tea.power : 0;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149744_f() {
        return this.transmitter;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityAttuned) {
            TileEntityAttuned tea = (TileEntityAttuned)te;
            if (tea.frequency.length() > 0) {
                Tracking.updateFrequency(tea.frequency);
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.func_149689_a(world, x, y, z, living, stack);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityAttuned) {
            TileEntityAttuned tea = (TileEntityAttuned)te;
            if (stack.func_82837_s()) {
                tea.frequency = stack.func_82833_r();
                Tracking.updateFrequency(tea.frequency);
            }
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity te;
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_71020_j(0.025f);
        }
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (te = world.func_147438_o(x, y, z)) instanceof TileEntityAttuned) {
            ItemStack stack = new ItemStack(world.func_147439_a(x, y, z), 1, 0);
            TileEntityAttuned tea = (TileEntityAttuned)te;
            if (tea.frequency.length() > 0) {
                stack.func_151001_c(tea.frequency);
                Tracking.updateFrequency(stack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                MiscUtils.dropStack(world, x, y, z, stack);
            }
        }
        return world.func_147468_f(x, y, z);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAttuned();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }
}

