/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.decorative;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.render.TextureHandler;

public class BlockRockSlab
extends BlockSlab {
    private static String[] types = new String[]{"brick", "cobble", "paver", "antipaver"};
    private IIcon paverSide;
    private IIcon[] icons = new IIcon[types.length];
    private boolean isDouble;
    private String name;
    private int color = 0xFFFFFF;

    public BlockRockSlab(String name, boolean isDouble) {
        super(isDouble, Material.field_151576_e);
        this.func_149647_a(ArtificeCore.worldTab);
        this.func_149713_g(0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149663_c("artifice." + name + (isDouble ? ".doubleslab" : ".slab"));
        this.name = name;
        this.isDouble = isDouble;
    }

    public BlockRockSlab(String name, int color, boolean isDouble) {
        this(name, isDouble);
        this.color = color;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        if (this.isDouble) {
            if (this == ArtificeBlocks.blockBasaltDoubleSlab) {
                return Item.func_150898_a((Block)ArtificeBlocks.blockBasaltSlab);
            }
            if (this == ArtificeBlocks.blockMarbleDoubleSlab) {
                return Item.func_150898_a((Block)ArtificeBlocks.blockMarbleSlab);
            }
            int i = 0;
            for (BlockRockSlab b : ArtificeBlocks.blockLimestoneDoubleSlabs) {
                if (this == b) {
                    return Item.func_150898_a((Block)ArtificeBlocks.blockLimestoneSlabs[i]);
                }
                ++i;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return this.func_149650_a(world.func_72805_g(x, y, z), world.field_73012_v, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        if (!this.isDouble) {
            for (int i = 0; i < types.length; ++i) {
                list.add(new ItemStack(id, 1, i));
            }
        }
    }

    public String func_150002_b(int meta) {
        int n = meta = meta > 7 ? meta - 8 : meta;
        if (meta >= types.length) {
            meta = 0;
        }
        return "tile.artifice." + this.name + (this.isDouble ? ".doubleslab." : ".slab.") + types[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.paverSide = TextureHandler.registerIcon(reg, "paverside", this.name.split("[.]")[0]);
        for (int i = 0; i < ArtificeBlocks.rockBlocks.length; ++i) {
            if (!ArtificeBlocks.rockBlocks[i].func_149739_a().contains(this.name)) continue;
            TextureHandler.registerConnectedTexture(reg, (Block)this, 2, 0, "paver", this.name.split("[.]")[0]);
            TextureHandler.registerConnectedTexture(reg, (Block)this, 2, 1, "paver", this.name.split("[.]")[0]);
            this.icons[2] = TextureHandler.getConnectedTexture((Block)this, (int)2, (int)0).icon;
            TextureHandler.registerConnectedTexture(reg, (Block)this, 3, 0, "antipaver", this.name.split("[.]")[0]);
            TextureHandler.registerConnectedTexture(reg, (Block)this, 3, 1, "antipaver", this.name.split("[.]")[0]);
            this.icons[3] = TextureHandler.getConnectedTexture((Block)this, (int)3, (int)0).icon;
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if ((meta &= 7) > types.length) {
            meta = 0;
        }
        if (meta == 2 || meta == 3) {
            if (side == 0 || side == 1) {
                return this.icons[meta];
            }
            return this.paverSide;
        }
        if (meta == 0) {
            meta = 2;
        }
        if (this.name.split("[.]")[0].equals("basalt")) {
            return ArtificeBlocks.blockBasalt.func_149691_a(side, meta);
        }
        if (this.name.split("[.]")[0].equals("marble")) {
            return ArtificeBlocks.blockMarble.func_149691_a(side, meta);
        }
        return ArtificeBlocks.blockLimestones[0].func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        int meta = block.func_72805_g(x, y, z) & 7;
        return this.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess block, int x, int y, int z) {
        return this.color;
    }
}

