/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeEnchants;
import shukaro.artifice.ArtificeFluids;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.ArtificeTiles;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.ArtificeWorld;
import shukaro.artifice.command.CommandCalc;
import shukaro.artifice.compat.AE2;
import shukaro.artifice.compat.Buildcraft;
import shukaro.artifice.compat.CarpentersBlocks;
import shukaro.artifice.compat.EE3;
import shukaro.artifice.compat.FMP;
import shukaro.artifice.compat.Forestry;
import shukaro.artifice.compat.ICompat;
import shukaro.artifice.compat.IMC;
import shukaro.artifice.compat.MFR;
import shukaro.artifice.compat.Vanilla;
import shukaro.artifice.event.ArtificeEventHandler;
import shukaro.artifice.event.ArtificeTickHandler;
import shukaro.artifice.gui.ArtificeCreativeTab;
import shukaro.artifice.net.CommonProxy;
import shukaro.artifice.recipe.ArtificeRecipes;

@Mod(modid="Artifice", name="Artifice", version="1.7.10R1.1.4", dependencies="required-after:CoFHCore;after:BuildCraft|Core;after:EE3;after:Forestry;after:MineFactoryReloaded;after:Thaumcraft;after:Railcraft")
public class ArtificeCore {
    @SidedProxy(clientSide="shukaro.artifice.net.ClientProxy", serverSide="shukaro.artifice.net.CommonProxy")
    public static CommonProxy proxy;
    public static final String modID = "Artifice";
    public static final String modName = "Artifice";
    public static final String modChannel = "Artifice";
    public static final String modVersion = "1.7.10R1.1.4";
    public static Logger logger;
    public static ArtificeEventHandler eventHandler;
    public static ArtificeTickHandler tickHandler;
    public static final ArtificeCreativeTab mainTab;
    public static final ArtificeCreativeTab worldTab;
    @Mod.Instance(value="Artifice")
    public static ArtificeCore instance;
    private ArrayList<ICompat> compats = new ArrayList();

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandCalc());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.compats.add(new Buildcraft());
        this.compats.add(new EE3());
        this.compats.add(new FMP());
        this.compats.add(new Forestry());
        this.compats.add(new CarpentersBlocks());
        this.compats.add(new MFR());
        this.compats.add(new AE2());
        this.compats.add(new Vanilla());
        logger = evt.getModLog();
        eventHandler = new ArtificeEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        tickHandler = new ArtificeTickHandler();
        FMLCommonHandler.instance().bus().register((Object)tickHandler);
        ArtificeConfig.initClient(evt);
        ArtificeConfig.initCommon(evt);
        ArtificeFluids.initFluids();
        ArtificeBlocks.initBlocks();
        ArtificeTiles.initTiles();
        ArtificeItems.initItems();
        ArtificeEnchants.initEnchants();
        ArtificeWorld.initWorldGen();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        ArtificeTooltips.initTooltips();
        ArtificeRecipes.registerRecipes();
        proxy.init();
        for (ICompat c : this.compats) {
            if (c.getModID() != null && !Loader.isModLoaded((String)c.getModID())) continue;
            logger.debug("Loading compat " + c.getClass().getName());
            c.load();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        ArtificeBlocks.initOreMappings();
        ArtificeBlocks.initOreSet();
        ArtificeBlocks.registerOreVariants();
        ArtificeBlocks.registerBasaltsAndMarbles();
        if (ArtificeConfig.floraBoneMeal) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                for (int i = 0; i < 4; ++i) {
                    biome.addFlower((Block)ArtificeBlocks.blockFlora, i, 10);
                }
            }
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        IMC.processIMC(event);
    }

    @Mod.EventHandler
    public void missingMappings(FMLMissingMappingsEvent event) {
        List missing = event.get();
        for (FMLMissingMappingsEvent.MissingMapping m : missing) {
            if (!m.name.contains("dobule")) continue;
            if (m.type == GameRegistry.Type.BLOCK) {
                m.remap((Block)Block.field_149771_c.func_82594_a(m.name.replace("dobule", "double")));
                continue;
            }
            if (m.type != GameRegistry.Type.ITEM) continue;
            m.remap((Item)Item.field_150901_e.func_82594_a(m.name.replace("dobule", "double")));
        }
    }

    static {
        mainTab = new ArtificeCreativeTab("Artifice");
        worldTab = new ArtificeCreativeTab("Artifice Worldgen");
    }
}

