/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeRegistry;
import shukaro.artifice.block.decorative.BlockColoredTorch;
import shukaro.artifice.block.decorative.BlockLamp;
import shukaro.artifice.block.decorative.BlockRockSlab;
import shukaro.artifice.block.decorative.BlockStairsArtifice;
import shukaro.artifice.block.decorative.BlockSteel;
import shukaro.artifice.block.decorative.ItemBlockSlabArtifice;
import shukaro.artifice.block.fluid.BlockFluidBitumen;
import shukaro.artifice.block.fluid.BlockFluidCreosote;
import shukaro.artifice.block.fluid.BlockFluidFuel;
import shukaro.artifice.block.fluid.BlockFluidOil;
import shukaro.artifice.block.frame.BlockFrame;
import shukaro.artifice.block.frame.BlockFrameBase;
import shukaro.artifice.block.frame.BlockFrameBlastWall;
import shukaro.artifice.block.frame.BlockFrameDetector;
import shukaro.artifice.block.frame.BlockFrameGlassWall;
import shukaro.artifice.block.frame.BlockFrameScaffold;
import shukaro.artifice.block.functional.BlockAttunedRedstone;
import shukaro.artifice.block.functional.BlockHeatingCoil;
import shukaro.artifice.block.functional.BlockLogicRedstone;
import shukaro.artifice.block.functional.BlockNuclearBattery;
import shukaro.artifice.block.world.BlockBasicOre;
import shukaro.artifice.block.world.BlockCharredLog;
import shukaro.artifice.block.world.BlockEnderOre;
import shukaro.artifice.block.world.BlockFlora;
import shukaro.artifice.block.world.BlockGlowSand;
import shukaro.artifice.block.world.BlockLotus;
import shukaro.artifice.block.world.BlockNiter;
import shukaro.artifice.block.world.BlockOre;
import shukaro.artifice.block.world.BlockRock;
import shukaro.artifice.block.world.BlockSulfur;
import shukaro.artifice.block.world.BlockTephra;
import shukaro.artifice.util.MinecraftColors;
import shukaro.artifice.util.NameMetaPair;

public class ArtificeBlocks {
    public static BlockFrame blockFrame;
    public static BlockFlora blockFlora;
    public static BlockLotus blockLotus;
    public static BlockRock blockBasalt;
    public static BlockRock blockMarble;
    public static BlockStairsArtifice blockBasaltBrickStairs;
    public static BlockStairsArtifice blockMarbleBrickStairs;
    public static BlockStairsArtifice blockBasaltCobbleStairs;
    public static BlockStairsArtifice blockMarbleCobbleStairs;
    public static BlockRockSlab blockBasaltSlab;
    public static BlockRockSlab blockBasaltDoubleSlab;
    public static BlockRockSlab blockMarbleSlab;
    public static BlockRockSlab blockMarbleDoubleSlab;
    public static BlockFrame blockDetector;
    public static BlockSteel blockSteel;
    public static BlockFrameBlastWall blockReinforced;
    public static BlockFrameGlassWall blockGlassWall;
    public static BlockFrameGlassWall blockGlassWallDark;
    public static BlockFrameScaffold blockScaffold;
    public static BlockLamp[] blockLamps;
    public static BlockLamp[] blockLampsInverted;
    public static BlockRock[] blockLimestones;
    public static BlockRockSlab[] blockLimestoneSlabs;
    public static BlockRockSlab[] blockLimestoneDoubleSlabs;
    public static BlockStairsArtifice[] blockLimestoneBrickStairs;
    public static BlockStairsArtifice[] blockLimestoneCobbleStairs;
    public static String[] oreNames;
    public static BlockOre[] blockOres;
    public static BlockOre[] blockOresGlowing;
    public static BlockSulfur blockSulfur;
    public static BlockEnderOre blockEnderOre;
    public static BlockEnderOre blockEnderOreGlowing;
    public static BlockNiter blockNiter;
    public static Block blockOil;
    public static Block blockFuel;
    public static Block blockBitumen;
    public static Block blockCreosote;
    public static BlockGlowSand blockGlowSand;
    public static BlockColoredTorch[] blockColoredTorches;
    public static BlockCharredLog blockCharredLog;
    public static BlockTephra blockTephra;
    public static BlockAttunedRedstone blockAttunedRedstoneTransmitter;
    public static BlockAttunedRedstone blockAttunedRedstoneReceiver;
    public static BlockLogicRedstone blockLogicRedstone;
    public static BlockBasicOre blockUranium;
    public static BlockNuclearBattery blockNuclearBattery;
    public static BlockHeatingCoil blockHeatingCoil;
    public static String[] rockColorNames;
    public static int[] rockColors;
    public static Block[] rockBlocks;
    public static String[] rockBlockNames;
    public static Block blockDummy;
    public static TMap<String, Block> oreMappings;
    public static Set<NameMetaPair> oreSet;

    public static void initBlocks() {
        int i;
        int i2;
        blockFlora = new BlockFlora();
        blockLotus = new BlockLotus();
        blockBasalt = new BlockRock("basalt");
        ArtificeBlocks.rockBlocks[0] = blockBasalt;
        blockMarble = new BlockRock("marble");
        ArtificeBlocks.rockBlocks[1] = blockMarble;
        blockBasaltBrickStairs = new BlockStairsArtifice(blockBasalt, 2);
        blockMarbleBrickStairs = new BlockStairsArtifice(blockMarble, 2);
        blockBasaltCobbleStairs = new BlockStairsArtifice(blockBasalt, 1);
        blockMarbleCobbleStairs = new BlockStairsArtifice(blockMarble, 1);
        blockBasaltSlab = new BlockRockSlab("basalt", false);
        blockBasaltDoubleSlab = new BlockRockSlab("basalt", true);
        blockMarbleSlab = new BlockRockSlab("marble", false);
        blockMarbleDoubleSlab = new BlockRockSlab("marble", true);
        for (i2 = 0; i2 < blockLimestones.length; ++i2) {
            ArtificeBlocks.blockLimestones[i2] = new BlockRock("limestone." + rockColorNames[i2], rockColors[i2]);
            ArtificeBlocks.rockBlocks[i2 + 2] = blockLimestones[i2];
            ArtificeBlocks.blockLimestoneSlabs[i2] = new BlockRockSlab("limestone." + rockColorNames[i2], rockColors[i2], false);
            ArtificeBlocks.blockLimestoneDoubleSlabs[i2] = new BlockRockSlab("limestone." + rockColorNames[i2], rockColors[i2], true);
            ArtificeBlocks.blockLimestoneBrickStairs[i2] = new BlockStairsArtifice(blockLimestones[i2], 2, rockColors[i2]);
            ArtificeBlocks.blockLimestoneCobbleStairs[i2] = new BlockStairsArtifice(blockLimestones[i2], 1, rockColors[i2]);
        }
        for (i2 = 0; i2 < oreNames.length; ++i2) {
            if (oreNames[i2].equals("oreRedstone") || oreNames[i2].equals("oreEnder")) {
                ArtificeBlocks.blockOres[i2] = new BlockOre(oreNames[i2], false, 0, i2);
                ArtificeBlocks.blockOresGlowing[i2] = new BlockOre(oreNames[i2], true, 0, i2);
                continue;
            }
            ArtificeBlocks.blockOres[i2] = new BlockOre(oreNames[i2], i2);
        }
        blockDummy = new BlockOre.BlockOreDummy();
        blockSulfur = new BlockSulfur();
        blockEnderOre = new BlockEnderOre(false);
        blockEnderOreGlowing = new BlockEnderOre(true);
        blockNiter = new BlockNiter();
        blockOil = FluidRegistry.getFluid((String)"oil").getBlock() == null ? new BlockFluidOil() : FluidRegistry.getFluid((String)"oil").getBlock();
        blockFuel = FluidRegistry.getFluid((String)"fuel").getBlock() == null ? new BlockFluidFuel() : FluidRegistry.getFluid((String)"fuel").getBlock();
        blockBitumen = FluidRegistry.getFluid((String)"bitumen").getBlock() == null ? new BlockFluidBitumen() : FluidRegistry.getFluid((String)"bitumen").getBlock();
        blockCreosote = FluidRegistry.getFluid((String)"creosote").getBlock() == null ? new BlockFluidCreosote() : FluidRegistry.getFluid((String)"creosote").getBlock();
        blockGlowSand = new BlockGlowSand();
        for (i2 = 0; i2 < blockColoredTorches.length; ++i2) {
            ArtificeBlocks.blockColoredTorches[i2] = new BlockColoredTorch(i2);
        }
        blockCharredLog = new BlockCharredLog();
        blockTephra = new BlockTephra();
        blockAttunedRedstoneTransmitter = new BlockAttunedRedstone(true);
        blockAttunedRedstoneReceiver = new BlockAttunedRedstone(false);
        blockLogicRedstone = new BlockLogicRedstone();
        GameRegistry.registerBlock((Block)blockBasaltSlab, ItemBlockSlabArtifice.class, (String)(blockBasalt.func_149739_a() + ".slab"));
        GameRegistry.registerBlock((Block)blockBasaltDoubleSlab, ItemBlockSlabArtifice.class, (String)(blockBasalt.func_149739_a() + ".doubleslab"));
        GameRegistry.registerBlock((Block)blockMarbleSlab, ItemBlockSlabArtifice.class, (String)(blockMarble.func_149739_a() + ".slab"));
        GameRegistry.registerBlock((Block)blockMarbleDoubleSlab, ItemBlockSlabArtifice.class, (String)(blockMarble.func_149739_a() + ".doubleslab"));
        for (i2 = 0; i2 < blockLimestones.length; ++i2) {
            GameRegistry.registerBlock((Block)blockLimestoneSlabs[i2], ItemBlockSlabArtifice.class, (String)(blockLimestones[i2].func_149739_a() + ".slab"));
            GameRegistry.registerBlock((Block)blockLimestoneDoubleSlabs[i2], ItemBlockSlabArtifice.class, (String)(blockLimestones[i2].func_149739_a() + ".doubleslab"));
        }
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)new ItemStack((Block)blockMarble));
        OreDictionary.registerOre((String)"blockBasalt", (ItemStack)new ItemStack((Block)blockBasalt));
        for (BlockRock limeStone : blockLimestones) {
            OreDictionary.registerOre((String)"blockLimestone", (ItemStack)new ItemStack((Block)limeStone));
        }
        OreDictionary.registerOre((String)"oreSulfur", (ItemStack)new ItemStack((Block)blockSulfur, 1, 0));
        OreDictionary.registerOre((String)"oreSaltpeter", (ItemStack)new ItemStack((Block)blockNiter, 1, 1));
        OreDictionary.registerOre((String)"oreEnder", (ItemStack)new ItemStack((Block)blockEnderOre, 1, 0));
        blockFrame = new BlockFrameBase();
        blockDetector = new BlockFrameDetector();
        blockReinforced = new BlockFrameBlastWall();
        blockGlassWall = new BlockFrameGlassWall(false);
        blockGlassWallDark = new BlockFrameGlassWall(true);
        blockScaffold = new BlockFrameScaffold();
        for (i = 0; i < ArtificeConfig.tiers.length; ++i) {
            OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack((Block)blockGlassWall, 1, i));
            OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack((Block)blockGlassWallDark, 1, i));
        }
        blockSteel = new BlockSteel();
        if (ArtificeConfig.steelOreDict) {
            OreDictionary.registerOre((String)"blockSteel", (ItemStack)new ItemStack((Block)blockSteel));
        }
        for (i = 0; i < 16; ++i) {
            ArtificeBlocks.blockLamps[i] = new BlockLamp(MinecraftColors.values()[i], false);
            ArtificeBlocks.blockLampsInverted[i] = new BlockLamp(MinecraftColors.values()[i], true);
        }
        blockUranium = new BlockBasicOre("uranium", 2);
        OreDictionary.registerOre((String)"oreUranium", (ItemStack)new ItemStack((Block)blockUranium, 1, 0));
        OreDictionary.registerOre((String)"blockUranium", (ItemStack)new ItemStack((Block)blockUranium, 1, 1));
        blockNuclearBattery = new BlockNuclearBattery();
        blockHeatingCoil = new BlockHeatingCoil();
    }

    public static void initOreMappings() {
        oreMappings = new THashMap();
        for (int j = 0; j < oreNames.length; ++j) {
            oreMappings.put((Object)oreNames[j], (Object)blockOres[j]);
        }
    }

    public static void initOreSet() {
        oreSet = new THashSet();
        for (String s : oreNames) {
            if (OreDictionaryArbiter.getOres((String)s) == null) continue;
            for (ItemStack stack : OreDictionaryArbiter.getOres((String)s)) {
                if (stack == null) continue;
                oreSet.add(new NameMetaPair(stack.func_77973_b(), stack.func_77960_j()));
            }
        }
    }

    public static void registerOreVariants() {
        for (int i = 0; i < oreNames.length; ++i) {
            for (int j = 0; j < rockBlocks.length; ++j) {
                OreDictionary.registerOre((String)oreNames[i], (ItemStack)new ItemStack((Block)blockOres[i], 1, j));
            }
        }
    }

    public static void registerBasaltsAndMarbles() {
        for (ItemStack ore : OreDictionary.getOres((String)"blockMarble")) {
            ArtificeRegistry.registerMarbleType(ore);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"marble")) {
            ArtificeRegistry.registerMarbleType(ore);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"blockBasalt")) {
            ArtificeRegistry.registerBasaltType(ore);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"basalt")) {
            ArtificeRegistry.registerBasaltType(ore);
        }
    }

    static {
        blockLamps = new BlockLamp[16];
        blockLampsInverted = new BlockLamp[16];
        blockLimestones = new BlockRock[7];
        blockLimestoneSlabs = new BlockRockSlab[7];
        blockLimestoneDoubleSlabs = new BlockRockSlab[7];
        blockLimestoneBrickStairs = new BlockStairsArtifice[7];
        blockLimestoneCobbleStairs = new BlockStairsArtifice[7];
        oreNames = new String[]{"oreCoal", "oreIron", "oreLapis", "oreGold", "oreDiamond", "oreRedstone", "oreEmerald", "oreCopper", "oreTin", "oreSilver", "oreLead", "oreNickel", "oreSulfur", "oreEnder", "oreUranium"};
        blockOres = new BlockOre[oreNames.length];
        blockOresGlowing = new BlockOre[oreNames.length];
        blockColoredTorches = new BlockColoredTorch[16];
        rockColorNames = new String[]{"gray", "lightgray", "brown", "tan", "reddish", "bluish", "greenish"};
        rockColors = new int[]{0xB0B0B0, 0xFFFFFF, 12362119, 15853509, 11706528, 10526898, 10531488};
        rockBlocks = new Block[9];
        rockBlockNames = new String[]{"basalt", "marble", "limestone.gray", "limestone.lightgray", "limestone.brown", "limestone.tan", "limestone.reddish", "limestone.bluish", "limestone.greenish"};
    }
}

