/*
 * Decompiled with CFR 0.152.
 */
package fathzer.javaluator;

import fathzer.javaluator.BracketPair;
import fathzer.javaluator.Function;
import fathzer.javaluator.Operator;

public class Token {
    static final Token FUNCTION_ARG_SEPARATOR = new Token(Kind.FUNCTION_SEPARATOR, null);
    private Kind kind;
    private Object content;

    static Token buildLiteral(String literal) {
        return new Token(Kind.LITERAL, literal);
    }

    static Token buildOperator(Operator ope) {
        return new Token(Kind.OPERATOR, ope);
    }

    static Token buildFunction(Function function) {
        return new Token(Kind.FUNCTION, function);
    }

    static Token buildOpenToken(BracketPair pair) {
        return new Token(Kind.OPEN_BRACKET, pair);
    }

    static Token buildCloseToken(BracketPair pair) {
        return new Token(Kind.CLOSE_BRACKET, pair);
    }

    private Token(Kind kind, Object content) {
        if (kind.equals((Object)Kind.OPERATOR) && !(content instanceof Operator) || kind.equals((Object)Kind.FUNCTION) && !(content instanceof Function) || kind.equals((Object)Kind.LITERAL) && !(content instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.kind = kind;
        this.content = content;
    }

    BracketPair getBrackets() {
        return (BracketPair)this.content;
    }

    Operator getOperator() {
        return (Operator)this.content;
    }

    Function getFunction() {
        return (Function)this.content;
    }

    Kind getKind() {
        return this.kind;
    }

    public boolean isOperator() {
        return this.kind.equals((Object)Kind.OPERATOR);
    }

    public boolean isFunction() {
        return this.kind.equals((Object)Kind.FUNCTION);
    }

    public boolean isOpenBracket() {
        return this.kind.equals((Object)Kind.OPEN_BRACKET);
    }

    public boolean isCloseBracket() {
        return this.kind.equals((Object)Kind.CLOSE_BRACKET);
    }

    public boolean isFunctionArgumentSeparator() {
        return this.kind.equals((Object)Kind.FUNCTION_SEPARATOR);
    }

    public boolean isLiteral() {
        return this.kind.equals((Object)Kind.LITERAL);
    }

    Operator.Associativity getAssociativity() {
        return this.getOperator().getAssociativity();
    }

    int getPrecedence() {
        return this.getOperator().getPrecedence();
    }

    String getLiteral() {
        if (!this.kind.equals((Object)Kind.LITERAL)) {
            throw new IllegalArgumentException();
        }
        return (String)this.content;
    }

    private static enum Kind {
        OPEN_BRACKET,
        CLOSE_BRACKET,
        FUNCTION_SEPARATOR,
        FUNCTION,
        OPERATOR,
        LITERAL;

    }
}

