/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.blocks.grill;

import com.foodplus.core.FoodPlusItems;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GrillRecipeManager {
    private static final GrillRecipeManager SMELTING_BASE = new GrillRecipeManager();
    private Map smeltingList = new HashMap();
    private Map experienceList = new HashMap();

    public static GrillRecipeManager smelting() {
        return SMELTING_BASE;
    }

    private GrillRecipeManager() {
        this.addItemRecipe(FoodPlusItems.Sausage, new ItemStack(FoodPlusItems.GrilledSausage, 1), 0.7f);
        this.addItemRecipe(FoodPlusItems.RawCheeseSandwich, new ItemStack(FoodPlusItems.GrilledCheeseSandwich, 1), 0.7f);
        this.addItemRecipe(FoodPlusItems.FishVegetables, new ItemStack(FoodPlusItems.GrilledFish, 1), 0.7f);
        this.addItemRecipe(Items.field_151174_bG, new ItemStack(FoodPlusItems.GrilledPotato, 1), 0.7f);
        this.addBlockRecipe((Block)Blocks.field_150338_P, new ItemStack(FoodPlusItems.GrilledMushroom1, 1), 0.7f);
        this.addBlockRecipe((Block)Blocks.field_150337_Q, new ItemStack(FoodPlusItems.GrilledMushroom2, 1), 0.7f);
    }

    public void addBlockRecipe(Block p_151393_1_, ItemStack p_151393_2_, float p_151393_3_) {
        this.addItemRecipe(Item.func_150898_a((Block)p_151393_1_), p_151393_2_, p_151393_3_);
    }

    public void addItemRecipe(Item p_151396_1_, ItemStack p_151396_2_, float p_151396_3_) {
        this.func_151394_a(new ItemStack(p_151396_1_, 1, Short.MAX_VALUE), p_151396_2_, p_151396_3_);
    }

    public void func_151394_a(ItemStack p_151394_1_, ItemStack p_151394_2_, float p_151394_3_) {
        this.smeltingList.put(p_151394_1_, p_151394_2_);
        this.experienceList.put(p_151394_2_, Float.valueOf(p_151394_3_));
    }

    public void addLists(Item item, ItemStack itemstack, float experience) {
        this.putLists(new ItemStack(item, 1, Short.MAX_VALUE), itemstack, experience);
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }

    public void putLists(ItemStack itemstack, ItemStack itemstack2, float experience) {
        this.smeltingList.put(itemstack, itemstack2);
        this.experienceList.put(itemstack2, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack itemstack) {
        Map.Entry entry;
        Iterator iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.canBeSmelted(itemstack, (ItemStack)(entry = iterator.next()).getKey()));
        return (ItemStack)entry.getValue();
    }

    private boolean canBeSmelted(ItemStack itemstack, ItemStack itemstack2) {
        return itemstack2.func_77973_b() == itemstack.func_77973_b() && (itemstack2.func_77960_j() == Short.MAX_VALUE || itemstack2.func_77960_j() == itemstack.func_77960_j());
    }

    public float giveExperience(ItemStack itemstack) {
        Map.Entry entry;
        Iterator iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.canBeSmelted(itemstack, (ItemStack)(entry = iterator.next()).getKey()));
        if (itemstack.func_77973_b().getSmeltingExperience(itemstack) != -1.0f) {
            return itemstack.func_77973_b().getSmeltingExperience(itemstack);
        }
        return ((Float)entry.getValue()).floatValue();
    }
}

