/*
 * Decompiled with CFR 0.152.
 */
package net.thecondemned.LumySkinPatch;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import net.thecondemned.LumySkinPatch.Logger;
import net.thecondemned.LumySkinPatch.Profile;
import net.thecondemned.LumySkinPatch.PropertiesValueBase64;
import net.thecondemned.LumySkinPatch.UUID;

class MojangAPI {
    private static final String uuidurl = "https://api.mojang.com/profiles/minecraft";
    private static final String profileurl = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static HashMap<String, UUID> cacheUUID = new HashMap();
    private static HashMap<String, Profile> cacheProfile = new HashMap();

    MojangAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID getPlayerUUID(String playername) {
        if (cacheUUID.containsKey(playername)) {
            return cacheUUID.get(playername);
        }
        try {
            String json = MojangAPI.readUrlPOST(uuidurl, "[\"" + playername + "\"]", "application/json");
            Gson gson = new Gson();
            List res = (List)gson.fromJson(json, new TypeToken<List<UUID>>(){}.getType());
            if (res.size() == 1) {
                cacheUUID.put(playername, (UUID)res.get(0));
                return (UUID)res.get(0);
            }
            cacheUUID.put(playername, null);
            return null;
        }
        catch (Exception ex) {
            HashMap<String, UUID> hashMap = cacheUUID;
            synchronized (hashMap) {
                if (cacheUUID.containsKey(playername)) {
                    return cacheUUID.get(playername);
                }
            }
            Logger.Log("Error during getPlayerUUID for playername: " + playername + " | " + ex.getMessage());
            cacheUUID.put(playername, null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Profile getProfile(String uuid) {
        HashMap<String, Profile> hashMap = cacheProfile;
        synchronized (hashMap) {
            if (cacheProfile.containsKey(uuid)) {
                return cacheProfile.get(uuid);
            }
        }
        try {
            PropertiesValueBase64 vB64;
            String json = MojangAPI.readUrlGET(profileurl + uuid);
            Gson gson = new Gson();
            Profile res = gson.fromJson(json, Profile.class);
            byte[] decoded = DatatypeConverter.parseBase64Binary((String)res.properties[0].value);
            String decodedJson = new String(decoded, "UTF-8");
            res.properties[0].valueBase64 = vB64 = gson.fromJson(decodedJson, PropertiesValueBase64.class);
            HashMap<String, Profile> hashMap2 = cacheProfile;
            synchronized (hashMap2) {
                cacheProfile.put(uuid, res);
            }
            return res;
        }
        catch (Exception ex) {
            HashMap<String, Profile> hashMap3 = cacheProfile;
            synchronized (hashMap3) {
                if (cacheProfile.containsKey(uuid)) {
                    return cacheProfile.get(uuid);
                }
            }
            Logger.Log("Error during getProfile for uuid: " + uuid + " | " + ex.getMessage());
            hashMap3 = cacheProfile;
            synchronized (hashMap3) {
                cacheProfile.put(uuid, null);
            }
            return null;
        }
    }

    private static String readUrlGET(String urlString) throws MalformedURLException, ProtocolException, IOException, InterruptedException {
        String ret = "";
        HttpURLConnection con = null;
        try {
            String inputLine;
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.connect();
            if (con.getResponseCode() == 429) {
                Logger.Log("Too Many Request for getting url " + urlString + " - Waiting 30 seconds...");
                Thread.sleep(30000L);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.connect();
            }
            StringBuffer response = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
                response.append('\n');
            }
            ret = response.toString();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return ret;
    }

    private static String readUrlPOST(String urlString, String urlParameters, String contentType) throws MalformedURLException, ProtocolException, IOException {
        String ret = "";
        HttpURLConnection con = null;
        try {
            String inputLine;
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
            byte[] postData = urlParameters.getBytes("UTF-8");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", contentType);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.write(postData);
            StringBuffer response = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
                response.append('\n');
            }
            ret = response.toString();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return ret;
    }
}

