/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mca.core.MCA;
import mca.core.minecraft.ModBlocks;
import mca.core.minecraft.ModItems;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumDestinyChoice;
import mca.enums.EnumDialogueType;
import mca.tile.TileTombstone;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import radixcore.math.Point3D;
import radixcore.packets.AbstractPacket;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;
import radixcore.util.SchematicHandler;

public class PacketDestinyChoice
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketDestinyChoice, IMessage> {
    private EnumDestinyChoice choice;

    public PacketDestinyChoice() {
    }

    public PacketDestinyChoice(EnumDestinyChoice choice) {
        this.choice = choice;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.choice = EnumDestinyChoice.fromId(byteBuf.readInt());
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.choice.getId());
    }

    public IMessage onMessage(PacketDestinyChoice packet, MessageContext context) {
        EntityPlayerMP player = (EntityPlayerMP)this.getPlayer(context);
        NBTPlayerData data = MCA.getPlayerData((EntityPlayer)player);
        WorldServer world = (WorldServer)player.field_70170_p;
        if (packet.choice == EnumDestinyChoice.NONE || packet.choice == EnumDestinyChoice.CANCEL) {
            PlayerManager manager = world.func_73040_p();
            for (int x = -20; x < 20; ++x) {
                for (int z = -20; z < 20; ++z) {
                    for (int y = -5; y < 10; ++y) {
                        manager.func_151250_a((int)player.field_70165_t + x, (int)player.field_70163_u + y, (int)player.field_70161_v + z);
                    }
                }
            }
            if (packet.choice == EnumDestinyChoice.CANCEL) {
                player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.crystalBall));
            }
        } else {
            if (MinecraftServer.func_71276_C().func_71262_S() && !MCA.getConfig().serverEnableStructureSpawning) {
                return null;
            }
            if (packet.choice == EnumDestinyChoice.FAMILY) {
                SchematicHandler.spawnStructureRelativeToPlayer((String)"/assets/mca/schematic/family.schematic", (EntityPlayer)player);
                boolean isSpouseMale = data.getGenderPreference() == 0 ? true : (data.getGenderPreference() == 2 ? false : world.field_73012_v.nextBoolean());
                EntityHuman spouse = new EntityHuman((World)world, isSpouseMale);
                spouse.func_70107_b(player.field_70165_t - 2.0, player.field_70163_u, player.field_70161_v);
                world.func_72838_d((Entity)spouse);
                PlayerMemory spouseMemory = spouse.getPlayerMemory((EntityPlayer)player);
                spouse.setMarriedTo((Entity)player);
                spouseMemory.setHearts(100);
                spouseMemory.setDialogueType(EnumDialogueType.SPOUSE);
                for (int numChildren = RadixMath.getNumberInRange((int)0, (int)2); numChildren > 0; --numChildren) {
                    boolean isPlayerMale = data.getIsMale();
                    String motherName = "N/A";
                    int motherId = 0;
                    String fatherName = "N/A";
                    int fatherId = 0;
                    if (isPlayerMale) {
                        fatherName = player.func_70005_c_();
                        fatherId = data.getPermanentId();
                        motherName = spouse.getName();
                        motherId = spouse.getPermanentId();
                    } else {
                        motherName = player.func_70005_c_();
                        motherId = data.getPermanentId();
                        fatherName = spouse.getName();
                        fatherId = spouse.getPermanentId();
                    }
                    EntityHuman child = new EntityHuman((World)world, RadixLogic.getBooleanWithProbability((int)50), true, motherName, fatherName, motherId, fatherId, true);
                    child.func_70107_b(player.field_70165_t + (double)RadixMath.getNumberInRange((int)1, (int)3), player.field_70163_u, player.field_70161_v);
                    world.func_72838_d((Entity)child);
                    PlayerMemory childMemory = child.getPlayerMemory((EntityPlayer)player);
                    childMemory.setHearts(100);
                    childMemory.setDialogueType(EnumDialogueType.CHILDP);
                }
            } else if (packet.choice == EnumDestinyChoice.ALONE) {
                SchematicHandler.spawnStructureRelativeToPlayer((String)"/assets/mca/schematic/bachelor.schematic", (EntityPlayer)player);
            } else if (packet.choice == EnumDestinyChoice.VILLAGE) {
                SchematicHandler.spawnStructureRelativeToPlayer((String)"/assets/mca/schematic/village1.schematic", (EntityPlayer)player);
                for (Point3D point : RadixLogic.getNearbyBlocks((Entity)player, (Block)Blocks.field_150474_ac, (int)70)) {
                    BlockHelper.setBlock((World)player.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ, (Block)Blocks.field_150350_a);
                    MCA.naturallySpawnVillagers(new Point3D(point.iPosX, point.iPosY, point.iPosZ), (World)world, -1);
                }
                for (Point3D point : RadixLogic.getNearbyBlocks((Entity)player, (Block)Blocks.field_150357_h, (int)70)) {
                    BlockHelper.setBlock((World)player.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ, (Block)ModBlocks.tombstone, (int)4);
                    TileTombstone tile = (TileTombstone)BlockHelper.getTileEntity((World)player.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ);
                    if (tile == null) continue;
                    tile.signText[1] = RadixLogic.getBooleanWithProbability((int)50) ? MCA.getLanguageManager().getString("name.male") : MCA.getLanguageManager().getString("name.female");
                    tile.signText[2] = "RIP";
                }
            }
        }
        player.field_70170_p.func_72956_a((Entity)player, "portal.travel", 0.5f, 2.0f);
        return null;
    }
}

