/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.party;

import com.gildedgames.util.core.nbt.NBT;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.data.ByteDecoder;
import net.aetherteam.aether.data.ByteEncoder;
import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.data.IEncodableByte;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.dungeons.DungeonSliderLabyrinth;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketMemberDungeonJoin;
import net.aetherteam.aether.packets.PacketPartyClientInfo;
import net.aetherteam.aether.packets.PacketPartyEvent;
import net.aetherteam.aether.packets.PacketPartyListChange;
import net.aetherteam.aether.party.MemberType;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.party.PartyType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class Party
implements NBT,
IEncodableByte {
    private UUID id;
    private String name;
    private PlayerAether leader;
    private HashMap<UUID, PlayerAether> members = new HashMap();
    private HashMap<UUID, PlayerAether> pendingMembers = new HashMap();
    private int memberSizeLimit = 4;
    private PartyType type;
    private HashMap<DungeonPosition, Integer> dungeonMap = new HashMap();

    public Party() {
    }

    public Party(String name, PartyType type, PlayerAether leader) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.type = type;
        this.leader = leader;
        this.members.put(this.leader.getUniqueID(), this.leader);
        this.leader.setParty(this);
        this.leader.setPartyMemberType(MemberType.LEADER);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendRequestPacket(PlayerAether target) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.MEMBER_REQUEST_ADD, this.id, null, null, target, null));
    }

    public void requestPlayer(PlayerAether target, PlayerAether source) {
        if (this.leader != source) {
            Aether.print("Failure to request " + target.getUsername() + " because source is not leader of party " + this.getName());
            return;
        }
        Aether.print(target.getUsername() + " added to requested list of party: " + this.getName());
        this.pendingMembers.put(target.getUniqueID(), target);
        this.refreshMemberClients();
    }

    @SideOnly(value=Side.CLIENT)
    public void sendRemovePlayerRequestPacket(PlayerAether target) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.MEMBER_REQUEST_REMOVE, this.id, null, null, target, null));
    }

    @SideOnly(value=Side.SERVER)
    public void removePlayerRequest(PlayerAether target, PlayerAether source) {
        if (this.leader != source) {
            Aether.print("Failure to remove " + target.getUsername() + " because source is not leader of party " + this.getName());
            return;
        }
        Aether.print(target.getUsername() + " removed from requested list of party: " + this.getName());
        this.pendingMembers.remove(target.getUniqueID());
        this.refreshMemberClients();
    }

    @SideOnly(value=Side.CLIENT)
    public void sendJoinPacket(PlayerAether target) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.MEMBER_JOIN, this.id, this.name, null, target, null));
    }

    public void join(PlayerAether target) {
        if (!this.pendingMembers.containsKey(target.getUniqueID()) && !this.type.equals((Object)PartyType.OPEN)) {
            Aether.print("Failure to add player " + target.getUsername() + " to party: " + this.getName());
            return;
        }
        this.pendingMembers.remove(target.getUniqueID());
        this.members.put(target.getUniqueID(), target);
        target.setParty(this);
        target.setPartyMemberType(MemberType.MEMBER);
        Aether.print("added Player '" + target.getUsername() + "' to the party: " + this.getName());
        target.markDirty();
        this.refreshMemberClients();
    }

    @SideOnly(value=Side.CLIENT)
    public void sendLeavePacket(PlayerAether target) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.MEMBER_LEAVE, this.id, this.getName(), null, target, null));
    }

    public void leave(PlayerAether target, PlayerAether source) {
        if (source != this.leader && source != target || !this.members.containsKey(source.getUniqueID()) || !this.members.containsKey(target.getUniqueID())) {
            Aether.print("Failure to remove " + target.getUsername() + " from party " + this.getName());
            return;
        }
        this.members.remove(target.getUniqueID());
        target.setParty(null);
        target.setPartyMemberType(MemberType.MEMBER);
        target.markDirty();
        this.refreshMemberClients();
        Aether.print("Removed Player '" + target.getUsername() + "' from the party: " + this.getName());
        if (this.members.size() == 0 || target.equals(this.leader) && source.equals(this.leader)) {
            PartyController.instance().removeParty(this.id, source);
        }
    }

    public void promoteTo(PlayerAether target, MemberType type, PlayerAether source) {
        if (source != this.leader) {
            return;
        }
        target.setPartyMemberType(type);
        target.markDirty();
        Aether.print(target.getUsername() + " changed Member Type to " + type.name());
        if (type == MemberType.LEADER) {
            this.leader.setPartyMemberType(MemberType.MEMBER);
            this.leader.markDirty();
            this.leader = target;
            this.refreshMemberClients();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean sendChangeNamePacket(String newName) {
        if (PartyController.instance().doesPartyWithNameExist(newName)) {
            return false;
        }
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.PARTY_NAME_CHANGE, this.id, newName, null, null, null));
        return true;
    }

    public void changeName(String newName, PlayerAether source) {
        if (source != this.leader || !PartyController.instance().doesPartyWithNameExist(newName) || newName.isEmpty()) {
            Aether.print("Failure to change name of " + this.getName() + " to " + newName);
            return;
        }
        Aether.print("Changed name of " + this.getName() + " to " + newName);
        PartyController.instance().getParties().remove(this.getID());
        this.name = newName;
        PartyController.instance().getParties().put(this.getID(), this);
        this.refreshMemberClients();
        AetherPacketHandler.sendToAll(new PacketPartyListChange());
    }

    public void sendChangeTypePacket(PartyType newType) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.PARTY_TYPE_CHANGE, this.id, null, newType, null, null));
    }

    public void changeType(PartyType newType, PlayerAether source) {
        if (source != this.leader || newType == null) {
            Aether.print("Failure to change type of party: " + this.getName());
            return;
        }
        this.type = newType;
        Aether.print("Changed type of " + this.getName() + " to " + this.type.toString());
        this.refreshMemberClients();
        AetherPacketHandler.sendToAll(new PacketPartyListChange());
    }

    public Dungeon getDungeon(World world, DungeonPosition dungeonPosition) {
        Dungeon dungeon;
        dungeonPosition.dimensionID = world.field_73011_w.field_76574_g;
        Integer dungeonId = this.dungeonMap.get(dungeonPosition);
        if (dungeonId != null) {
            dungeon = DungeonHandler.instance().getDungeon(dungeonId);
            if (dungeon != null) {
                return dungeon;
            }
            this.dungeonMap.remove(dungeonPosition);
        }
        dungeon = new DungeonSliderLabyrinth();
        dungeon.generate(dungeonPosition);
        this.dungeonMap.put(dungeonPosition, dungeon.dungeonId);
        return dungeon;
    }

    public void refreshMemberClients() {
        Aether.print("Refreshing member clients of party: " + this.getName());
        this.sendPacketToMembers(new PacketPartyClientInfo(this));
    }

    public void sendPacketToMembers(AetherPacket packet) {
        for (PlayerAether playerInfo : this.getAllMembers()) {
            if (playerInfo.entityPlayer == null) continue;
            AetherPacketHandler.sendTo(packet, (EntityPlayerMP)playerInfo.entityPlayer);
        }
    }

    public void sendPlayerJoinedDungeonNotification(PlayerAether player, Dungeon dungeon, DungeonPosition position) {
        ArrayList<EntityPlayer> membersInDungeon = dungeon.getMembers();
        for (PlayerAether playerInfo : this.getAllMembers()) {
            if (membersInDungeon.contains(playerInfo.entityPlayer)) {
                AetherPacketHandler.sendTo(new PacketMemberDungeonJoin(position, true, player), (EntityPlayerMP)playerInfo.entityPlayer);
                continue;
            }
            if (playerInfo.entityPlayer.field_71093_bK == Aether.getDungeonDimensionID()) continue;
            AetherPacketHandler.sendTo(new PacketMemberDungeonJoin(position, false, player), (EntityPlayerMP)playerInfo.entityPlayer);
        }
    }

    public void write(NBTTagCompound output) {
        output.func_74778_a("id", this.id.toString());
        output.func_74778_a("name", this.name);
        output.func_74778_a("partyLeader", this.leader.getProfile().getUUID().toString());
        NBTTagList members = new NBTTagList();
        for (UUID uuid : this.members.keySet()) {
            members.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        NBTTagList pendingMembers = new NBTTagList();
        for (UUID uuid : this.pendingMembers.keySet()) {
            members.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        output.func_74782_a("members", (NBTBase)members);
        output.func_74782_a("pendingMembers", (NBTBase)pendingMembers);
        output.func_74768_a("memberSizeLimit", this.memberSizeLimit);
        output.func_74778_a("type", this.type.name());
        output.func_74773_a("dungeonMap", ByteEncoder.encodeIntMap(this.dungeonMap));
    }

    public void read(NBTTagCompound input) {
        this.id = UUID.fromString(input.func_74779_i("id"));
        this.name = input.func_74779_i("name");
        this.leader = PlayerAether.get(UUID.fromString(input.func_74779_i("partyLeader")));
        NBTTagList members = input.func_150295_c("members", 10);
        for (int i = 0; i < members.func_74745_c(); ++i) {
            UUID uuid = UUID.fromString(members.func_150307_f(i));
            this.members.put(uuid, PlayerAether.get(uuid));
        }
        NBTTagList pendingMembers = input.func_150295_c("pendingMembers", 10);
        for (int i = 0; i < pendingMembers.func_74745_c(); ++i) {
            UUID uuid = UUID.fromString(pendingMembers.func_150307_f(i));
            this.members.put(uuid, PlayerAether.get(uuid));
        }
        this.memberSizeLimit = input.func_74762_e("memberSizeLimit");
        this.type = PartyType.getTypeFromString(input.func_74779_i("type"));
        this.dungeonMap = ByteDecoder.decodeIntMap(DungeonPosition.class, input.func_74770_j("dungeonMap"));
    }

    @Override
    public void writeData(ByteBuf output) {
        output.writeLong(this.id.getMostSignificantBits());
        output.writeLong(this.id.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)output, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)output, (String)this.type.name());
        output.writeLong(this.leader.getProfile().getUUID().getMostSignificantBits());
        output.writeLong(this.leader.getProfile().getUUID().getLeastSignificantBits());
    }

    @Override
    public void readData(ByteBuf input) {
        this.id = new UUID(input.readLong(), input.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)input);
        this.type = PartyType.getTypeFromString(ByteBufUtils.readUTF8String((ByteBuf)input));
        this.leader = PlayerAether.get(new UUID(input.readLong(), input.readLong()));
    }

    public UUID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (Aether.isServer()) {
            Aether.print("Setting name of party: " + name);
            this.refreshMemberClients();
        }
    }

    public PlayerAether getLeader() {
        return this.leader;
    }

    public void setLeader(PlayerAether leader) {
        this.leader = leader;
        if (Aether.isServer()) {
            Aether.print("Setting leader of party: " + this.getName() + " to " + leader.getUsername());
            this.refreshMemberClients();
        }
    }

    public int getMemberSizeLimit() {
        return this.memberSizeLimit;
    }

    public PartyType getType() {
        return this.type;
    }

    public void setType(PartyType type) {
        this.type = type;
        if (Aether.isServer()) {
            Aether.print("Setting type of party: " + this.getName());
            this.refreshMemberClients();
        }
    }

    public Collection<PlayerAether> getAllMembers() {
        return this.members.values();
    }

    public Collection<PlayerAether> getAllPendingMembers() {
        return this.pendingMembers.values();
    }

    public Collection<UUID> getAllMemberUUIDs() {
        return this.members.keySet();
    }

    public Collection<UUID> getAllPendingMemberUUIDs() {
        return this.pendingMembers.keySet();
    }

    public ArrayList<PlayerAether> getOnlineMembers() {
        ArrayList<PlayerAether> onlineMembers = new ArrayList<PlayerAether>();
        for (PlayerAether player : this.getAllMembers()) {
            if (!player.loggedIn) continue;
            onlineMembers.add(player);
        }
        return onlineMembers;
    }

    public Collection<PlayerAether> getPendingMembers() {
        return this.pendingMembers.values();
    }

    public void addPendingMember(PlayerAether player) {
        this.pendingMembers.put(player.getUniqueID(), player);
        if (Aether.isServer()) {
            this.refreshMemberClients();
        }
    }

    public void removePendingMember(PlayerAether player) {
        this.pendingMembers.remove(player.getUniqueID());
        if (Aether.isServer()) {
            this.refreshMemberClients();
        }
    }

    public void setRequestedMembers(ArrayList<PlayerAether> requestedMembers) {
        this.pendingMembers.clear();
        for (PlayerAether aePlayer : requestedMembers) {
            this.pendingMembers.put(aePlayer.getUniqueID(), aePlayer);
        }
        if (Aether.isServer()) {
            this.refreshMemberClients();
        }
    }

    public void setMembers(ArrayList<PlayerAether> members) {
        this.members.clear();
        for (PlayerAether aePlayer : members) {
            this.members.put(aePlayer.getUniqueID(), aePlayer);
        }
        if (Aether.isServer()) {
            this.refreshMemberClients();
        }
    }
}

