/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.party.MemberType;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.party.PartyType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPartyEvent
extends AetherPacket<PacketPartyEvent> {
    private PartyEvent event;
    private UUID partyID;
    private String partyName;
    private PartyType partyType;
    private PlayerAether partyMember;
    private MemberType memberType;

    public PacketPartyEvent() {
    }

    public PacketPartyEvent(PartyEvent event, UUID partyID, String partyName, PartyType partyType, PlayerAether partyMember, MemberType memberType) {
        this.event = event;
        this.partyID = partyID;
        this.partyName = partyName;
        this.partyType = partyType;
        this.partyMember = partyMember;
        this.memberType = memberType;
    }

    public void fromBytes(ByteBuf buf) {
        this.event = PartyEvent.values[buf.readByte()];
        this.partyID = new UUID(buf.readLong(), buf.readLong());
        if (this.event.requiresPartyName) {
            this.partyName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        if (this.event.requiresPartyType) {
            this.partyType = PartyType.getTypeFromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        if (this.event.requiresMemberName) {
            this.partyMember = PlayerAether.get(new UUID(buf.readLong(), buf.readLong()));
        }
        if (this.event.requiresMemberType) {
            this.memberType = MemberType.getTypeFromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.event.ordinal());
        buf.writeLong(this.partyID.getMostSignificantBits());
        buf.writeLong(this.partyID.getLeastSignificantBits());
        if (this.event.requiresPartyName) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.partyName);
        }
        if (this.event.requiresPartyType) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.partyType.name());
        }
        if (this.event.requiresMemberName) {
            buf.writeLong(this.partyMember.getUniqueID().getMostSignificantBits());
            buf.writeLong(this.partyMember.getUniqueID().getLeastSignificantBits());
        }
        if (this.event.requiresMemberType) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.memberType.name());
        }
    }

    @Override
    public void handleClientSide(PacketPartyEvent message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketPartyEvent message, EntityPlayer player) {
        PlayerAether source = PlayerAether.get(player);
        switch (message.event) {
            case PARTY_CREATE: {
                PartyController.instance().addParty(message.partyName, message.partyType, source);
                break;
            }
            case PARTY_DISBAND: {
                PartyController.instance().removeParty(message.partyID, source);
                break;
            }
            case PARTY_NAME_CHANGE: {
                Party party = source.getParty();
                if (party == null) break;
                party.changeName(message.partyName, source);
                break;
            }
            case PARTY_TYPE_CHANGE: {
                Party party = source.getParty();
                if (party == null) break;
                party.changeType(message.partyType, source);
                break;
            }
            case MEMBER_REQUEST_ADD: {
                Party party = source.getParty();
                if (party == null) break;
                party.requestPlayer(message.partyMember, source);
                break;
            }
            case MEMBER_REQUEST_REMOVE: {
                Party party = source.getParty();
                if (party == null) break;
                party.removePlayerRequest(message.partyMember, source);
                break;
            }
            case MEMBER_JOIN: {
                Party party = PartyController.instance().getParty(message.partyID);
                if (party == null) break;
                party.join(source);
                break;
            }
            case MEMBER_LEAVE: {
                Party party = source.getParty();
                if (party == null) break;
                party.leave(message.partyMember, source);
                break;
            }
            case MEMBER_TYPE_CHANGE: {
                Party party = source.getParty();
                if (party == null) break;
                party.promoteTo(message.partyMember, message.memberType, source);
                break;
            }
        }
    }

    public static enum PartyEvent {
        PARTY_CREATE(true, true, false, false),
        PARTY_DISBAND(true, false, false, false),
        PARTY_NAME_CHANGE(true, false, false, false),
        PARTY_TYPE_CHANGE(false, true, false, false),
        MEMBER_REQUEST_ADD(false, false, true, false),
        MEMBER_REQUEST_REMOVE(false, false, true, false),
        MEMBER_JOIN(true, false, true, false),
        MEMBER_LEAVE(false, false, true, false),
        MEMBER_TYPE_CHANGE(false, false, true, true);

        public boolean requiresPartyName;
        public boolean requiresPartyType;
        public boolean requiresMemberName;
        public boolean requiresMemberType;
        public static PartyEvent[] values;

        private PartyEvent(boolean requiresPartyName, boolean requiresPartyType, boolean requiresMemberName, boolean requiresMemberType) {
            this.requiresPartyName = requiresPartyName;
            this.requiresPartyType = requiresPartyType;
            this.requiresMemberName = requiresMemberName;
            this.requiresMemberType = requiresMemberType;
        }

        static {
            values = PartyEvent.values();
        }
    }
}

