/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.packets;

import io.netty.buffer.ByteBuf;
import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketDungeonEnter
extends AetherPacket<PacketDungeonEnter> {
    private DungeonPosition dungeonPosition;

    public PacketDungeonEnter() {
    }

    public PacketDungeonEnter(DungeonPosition dungeonPosition) {
        this.dungeonPosition = dungeonPosition;
    }

    public void fromBytes(ByteBuf buf) {
        this.dungeonPosition = new DungeonPosition(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dungeonPosition.x);
        buf.writeInt(this.dungeonPosition.y);
        buf.writeInt(this.dungeonPosition.z);
        buf.writeInt(this.dungeonPosition.dimensionID);
    }

    @Override
    public void handleClientSide(PacketDungeonEnter message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketDungeonEnter message, EntityPlayer player) {
        PlayerAether hook = PlayerAether.get(player);
        Dungeon dungeon = hook.getDungeon(player.field_70170_p, message.dungeonPosition);
        if (hook.getParty() != null) {
            hook.getParty().sendPlayerJoinedDungeonNotification(hook, dungeon, message.dungeonPosition);
        }
        dungeon.enter((EntityPlayerMP)player);
    }
}

