/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.notifications.actions;

import net.aetherteam.aether.Aether;
import net.aetherteam.aether.notifications.Notification;
import net.aetherteam.aether.notifications.NotificationHandler;
import net.aetherteam.aether.notifications.actions.NotificationAction;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.player.PlayerAether;

public class PartyRequestAction
implements NotificationAction {
    @Override
    public boolean executeAccept(Notification notification) {
        PlayerAether recruiter = notification.getSender();
        Party party = recruiter.getParty();
        PlayerAether receiver = notification.getReceiver();
        boolean partyJoined = false;
        if (receiver.entityPlayer.field_71093_bK != Aether.getDungeonDimensionID()) {
            if (recruiter.getPartyMemberType().canRecruit()) {
                party.sendJoinPacket(notification.getReceiver());
                partyJoined = true;
            }
            NotificationHandler.instance().removeNotification(notification);
            NotificationHandler.instance().removeSentNotification(notification, true);
        }
        return partyJoined;
    }

    @Override
    public boolean executeDecline(Notification notification) {
        Party party = notification.getSender().getParty();
        if (party != null) {
            party.sendRemovePlayerRequestPacket(notification.getReceiver());
        }
        NotificationHandler.instance().removeNotification(notification);
        NotificationHandler.instance().removeSentNotification(notification, true);
        return true;
    }

    @Override
    public String acceptMessage(Notification notification) {
        Party party = notification.getSender().getParty();
        return "You have joined the " + (party != null ? '\"' + party.getName() + '\"' + " " : "") + "party!";
    }

    @Override
    public String failedMessage(Notification notification) {
        PlayerAether receiver = notification.getReceiver();
        if (receiver.entityPlayer.field_71093_bK == Aether.getDungeonDimensionID()) {
            return "Sorry, but you can't join new Parties while in a Dungeon";
        }
        return "Sorry, the requested party no longer exists :(";
    }

    @Override
    public boolean isRelevant(Notification notification) {
        PlayerAether recruiter = notification.getSender();
        Party party = recruiter.getParty();
        PlayerAether receiver = notification.getReceiver();
        return party != null && !party.equals(receiver.getParty());
    }
}

