/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.notifications;

import java.util.UUID;
import net.aetherteam.aether.notifications.NotificationType;
import net.aetherteam.aether.notifications.actions.NotificationAction;
import net.aetherteam.aether.notifications.description.NotificationContents;
import net.aetherteam.aether.player.PlayerAether;

public class Notification {
    private String headerText;
    private PlayerAether sender;
    private PlayerAether receiver;
    private NotificationType type;
    private NotificationContents contents;
    private NotificationAction action;
    private UUID party;

    public Notification(NotificationType type, String headerText, String partyName, PlayerAether receiver) {
        this.headerText = headerText;
        this.receiver = receiver;
        this.type = type;
        this.action = type.action;
        this.contents = type.contents;
    }

    public Notification(NotificationType type, PlayerAether sender, PlayerAether receiver) {
        this.headerText = "Notification Received!";
        this.sender = sender;
        this.receiver = receiver;
        this.type = type;
        this.action = type.action;
        this.contents = type.contents;
        this.party = sender.getParty().getID();
    }

    public Notification(NotificationType type, String headerText, PlayerAether sender, PlayerAether receiver) {
        this.headerText = headerText;
        this.sender = sender;
        this.receiver = receiver;
        this.type = type;
        this.action = type.action;
        this.contents = type.contents;
        this.party = sender.getParty() != null ? sender.getParty().getID() : null;
    }

    public Notification(NotificationType type, PlayerAether sender, PlayerAether receiver, NotificationAction action, NotificationContents contents) {
        this.headerText = "Notification Received!";
        this.sender = sender;
        this.receiver = receiver;
        this.type = type;
        this.contents = contents;
        this.action = action;
        this.party = sender.getParty() != null ? sender.getParty().getID() : null;
    }

    public Notification(NotificationType type, String headerText, PlayerAether sender, PlayerAether receiver, NotificationAction action, NotificationContents contents) {
        this.headerText = headerText;
        this.sender = sender;
        this.receiver = receiver;
        this.type = type;
        this.contents = contents;
        this.action = action;
        this.party = sender.getParty() != null ? sender.getParty().getID() : null;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public PlayerAether getSender() {
        return this.sender;
    }

    public PlayerAether getReceiver() {
        return this.receiver;
    }

    public String getTypeName() {
        return this.type.typeName;
    }

    public NotificationContents getContents() {
        return this.contents;
    }

    public NotificationAction getAction() {
        return this.action;
    }

    public NotificationType getType() {
        return this.type;
    }

    public UUID getPartyID() {
        return this.party;
    }

    public void executeAction(boolean accept) {
        if (this.action != null) {
            if (accept) {
                this.action.executeAccept(this);
            } else {
                this.action.executeDecline(this);
            }
        }
    }
}

