/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.util;

import com.gildedgames.util.core.nbt.NBT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.aetherteam.aether.entities.util.GroupAggressor;
import net.aetherteam.aether.entities.util.IGroupEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public class EntityGroup
implements NBT {
    private static int nextPackID = Integer.MIN_VALUE;
    private static Map<Integer, EntityGroup> packs = new HashMap<Integer, EntityGroup>();
    private int size;
    private int id;
    private int optimalSize;
    private boolean hasLeader;
    List<GroupAggressor> agressors = new ArrayList<GroupAggressor>();
    int tickCounter = 0;

    public EntityGroup() {
    }

    public EntityGroup(int id) {
        this.id = id;
    }

    public static int getNextID() {
        return nextPackID++;
    }

    public static void onUpdate() {
        for (EntityGroup pack : packs.values()) {
            ++pack.tickCounter;
            pack.removeDeadAndOldAgressors();
        }
    }

    public int getID() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public int getOptimalSize() {
        return this.optimalSize;
    }

    public void setOptimalSize(int size) {
        this.optimalSize = size;
        this.refresh();
    }

    public void setSize(int size) {
        this.size = size;
        this.refresh();
    }

    public boolean hasLeader() {
        return this.hasLeader;
    }

    public void onAnimalDeath(IGroupEntity groupEntity) {
        if (groupEntity.isGroupLeader()) {
            this.hasLeader = false;
        }
        --this.size;
        this.refresh();
    }

    public void onAnimalJoin(IGroupEntity groupEntity) {
        if (groupEntity.isGroupLeader()) {
            this.hasLeader = true;
        }
        ++this.size;
        this.refresh();
    }

    public void addOrRenewAggressor(EntityLivingBase entity) {
        GroupAggressor agressor;
        Iterator<GroupAggressor> iterator = this.agressors.iterator();
        do {
            if (!iterator.hasNext()) {
                this.agressors.add(new GroupAggressor(this, entity, this.tickCounter));
                return;
            }
            agressor = iterator.next();
        } while (agressor.agressor != entity);
        agressor.time = this.tickCounter;
    }

    public EntityLivingBase findNearestAggressor(EntityLivingBase entity) {
        double d0 = Double.MAX_VALUE;
        GroupAggressor agressor = null;
        for (GroupAggressor agressor1 : this.agressors) {
            double d1 = agressor1.agressor.func_70068_e((Entity)entity);
            if (!(d1 <= d0)) continue;
            agressor = agressor1;
            d0 = d1;
        }
        return agressor != null ? agressor.agressor : null;
    }

    private void removeDeadAndOldAgressors() {
        Iterator<GroupAggressor> iterator = this.agressors.iterator();
        while (iterator.hasNext()) {
            GroupAggressor agressor = iterator.next();
            if (agressor.agressor.func_70089_S() && this.tickCounter - agressor.time <= 2200) continue;
            iterator.remove();
        }
    }

    private void refresh() {
        packs.put(this.id, this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EntityGroup)) {
            return false;
        }
        EntityGroup pack = (EntityGroup)object;
        return pack.getID() == this.getID();
    }

    public void write(NBTTagCompound output) {
        output.func_74768_a("packID", this.id);
        output.func_74768_a("optimalPackSize", this.optimalSize);
        output.func_74768_a("size", this.size);
        output.func_74768_a("nextPackID", nextPackID);
        output.func_74768_a("tickCounter", this.tickCounter);
        output.func_74757_a("hasLeader", this.hasLeader);
    }

    public void read(NBTTagCompound input) {
        this.id = input.func_74762_e("packID");
        this.optimalSize = input.func_74762_e("optimalPackSize");
        this.size = input.func_74762_e("size");
        nextPackID = input.func_74762_e("nextPackID");
        this.hasLeader = input.func_74767_n("hasLeader");
        this.tickCounter = input.func_74762_e("tickCounter");
        this.refresh();
    }
}

