/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.mounts.moa;

import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.entities.mounts.moa.MoaColor;
import net.aetherteam.aether.entities.util.EntitySaddleMount;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.items.ItemMoaEgg;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMoa
extends EntitySaddleMount {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int maxJumps;
    protected int ticksOffGround;
    protected int ticksUntilFlap;
    protected int secsUntilFlying;
    protected int secsUntilWalking;
    protected int secsUntilHungry;
    protected int secsUntilEgg;

    public EntityMoa(World world) {
        super(world);
        this.initAI();
        this.func_70105_a(1.0f, 2.0f);
        this.field_70138_W = 1.0f;
        this.secsUntilEgg = this.getRandomEggTime();
    }

    public EntityMoa(World world, MoaColor color) {
        this(world);
        this.setColor(color);
    }

    public int getRandomEggTime() {
        return 400 + this.field_70146_Z.nextInt(25);
    }

    public void initAI() {
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)0.3f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.25));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.25, Items.field_151015_O, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        MoaColor color = MoaColor.getRandomColor(this.field_70170_p);
        this.field_70180_af.func_75682_a(18, (Object)((byte)color.ID));
        this.field_70180_af.func_75682_a(19, (Object)((byte)color.jumps));
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    public boolean isHungry() {
        return (this.field_70180_af.func_75683_a(22) & 1) != 0;
    }

    public void setHungry(boolean hungry) {
        this.field_70180_af.func_75692_b(22, (Object)((byte)(hungry ? 1 : 0)));
    }

    public byte getAmountFed() {
        return this.field_70180_af.func_75683_a(21);
    }

    public void setAmountFed(int amountFed) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)amountFed));
    }

    public void increaseAmountFed(int amountFed) {
        this.setAmountFed(this.getAmountFed() + amountFed);
    }

    public boolean isPlayerGrown() {
        return (this.field_70180_af.func_75683_a(20) & 1) != 0;
    }

    public void setPlayerGrown(boolean playerGrown) {
        if (playerGrown) {
            this.field_70180_af.func_75692_b(20, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(20, (Object)0);
        }
    }

    public int getMaxJumps() {
        return this.maxJumps;
    }

    public void setMaxJumps(int maxJumps) {
        this.maxJumps = maxJumps;
    }

    public int getRemainingJumps() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setRemainingJumps(int jumps) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)jumps));
    }

    public MoaColor getColor() {
        return MoaColor.getColor(this.field_70180_af.func_75683_a(18));
    }

    public void setColor(MoaColor color) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)color.ID));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setMaxJumps(this.getColor().jumps);
        if (this.field_70703_bu) {
            this.field_70181_x += (double)0.05f;
        }
        this.updateWingRotation();
        this.func_70069_a(0.0f);
        if (this.secsUntilHungry > 0) {
            if (this.field_70173_aa % 20 == 0) {
                --this.secsUntilHungry;
            }
        } else if (!this.isHungry()) {
            this.setHungry(true);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.field_70153_n == null) {
            if (this.secsUntilEgg > 0) {
                if (this.field_70173_aa % 20 == 0) {
                    --this.secsUntilEgg;
                }
            } else if (this.field_70122_E) {
                this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_70099_a(ItemMoaEgg.getStackFromColor(this.getColor()), 0.0f);
                this.secsUntilEgg = this.getRandomEggTime();
            }
        }
    }

    public void resetHunger() {
        if (!this.field_70170_p.field_72995_K) {
            this.setHungry(false);
        }
        this.secsUntilHungry = 40 + this.field_70146_Z.nextInt(40);
    }

    public void updateWingRotation() {
        boolean onGround;
        boolean bl = onGround = !this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v));
        if (!onGround) {
            if (this.ticksUntilFlap == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "mob.bat.takeoff", 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                this.ticksUntilFlap = 11;
            } else {
                --this.ticksUntilFlap;
            }
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = Aether.minMax(0.01f, 1.0f, this.destPos);
        if (onGround) {
            this.destPos = 0.0f;
        }
        this.wingRotation += 0.533f;
    }

    @Override
    public void onMountedJump(float par1, float par2) {
        if (this.getRemainingJumps() > 0 && this.field_70181_x < 0.0) {
            this.field_70181_x = 0.6;
            if (!this.field_70122_E) {
                this.field_70170_p.func_72956_a((Entity)this, "aether:aemob.aerbunny.hop", 0.5f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                if (!this.field_70170_p.field_72995_K) {
                    this.setRemainingJumps(this.getRemainingJumps() - 1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    double d5 = this.field_70165_t - this.field_70165_t;
                    double d6 = this.field_70163_u - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                    double d7 = this.field_70161_v - this.field_70161_v;
                    double range = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
                    for (int multiply = 0; multiply < 15; ++multiply) {
                        Aether.proxy.spawnCloudSmoke(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, new Random(), 0.5, d5 / range, d6 / range, d7 / range, 0.3);
                    }
                }
            }
        }
    }

    @Override
    public float getMountedMoveSpeed() {
        return 0.3f;
    }

    public void setToAdult() {
        this.func_70873_a(0);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        Item currentItem;
        if (this.isPlayerGrown() && this.isHungry() && this.func_70631_g_() && player.func_71045_bC() != null && this.getAmountFed() < 3 && (currentItem = player.func_71045_bC().func_77973_b()) == AetherItems.AechorPetal) {
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
            this.increaseAmountFed(1);
            if (this.getAmountFed() >= 3) {
                this.setToAdult();
            } else {
                this.resetHunger();
            }
        }
        return super.func_70085_c(player);
    }

    @Override
    public boolean canSaddle() {
        return !this.func_70631_g_() && this.isPlayerGrown();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("playerGrown", this.isPlayerGrown());
        nbt.func_74768_a("remainingJumps", this.getRemainingJumps());
        nbt.func_74768_a("color", this.getColor().ID);
        nbt.func_74774_a("amountFed", this.getAmountFed());
        nbt.func_74757_a("isHungry", this.isHungry());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setPlayerGrown(nbt.func_74767_n("playerGrown"));
        this.setRemainingJumps(nbt.func_74762_e("remainingJumps"));
        this.setColor(MoaColor.getColor(nbt.func_74762_e("color")));
        this.setAmountFed(nbt.func_74771_c("amountFed"));
        this.setHungry(nbt.func_74767_n("isHungry"));
    }

    protected String func_70639_aQ() {
        return "aether:aemob.moa.say";
    }

    protected String func_70621_aR() {
        return "aether:aemob.moa.say";
    }

    protected String func_70673_aS() {
        return "aether:aemob.moa.say";
    }

    @Override
    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.pig.step", 0.15f, 1.0f);
    }

    @Override
    protected void func_70628_a(boolean var1, int var2) {
        super.func_70628_a(var1, var2);
        this.func_145779_a(Items.field_151008_G, 3);
    }

    protected void func_70069_a(float f) {
        boolean blockBeneath;
        boolean bl = blockBeneath = !this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
        if (!this.field_70122_E && !this.field_70703_bu && this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
            this.field_70181_x *= 0.6;
        }
        if (blockBeneath) {
            this.setRemainingJumps(this.maxJumps);
        }
    }

    public void func_70664_aZ() {
        if (this.field_70153_n == null) {
            super.func_70664_aZ();
        }
    }

    public double func_70042_X() {
        return 1.55;
    }

    public EntityAgeable func_90011_a(EntityAgeable matingAnimal) {
        return new EntityMoa(this.field_70170_p, this.getColor());
    }

    @Override
    public ItemStack getPickedResult(MovingObjectPosition target) {
        return ItemMoaEgg.getStackFromColor(this.getColor());
    }

    public IEntityLivingData func_110161_a(IEntityLivingData livingData) {
        this.setPlayerGrown(true);
        return super.func_110161_a(livingData);
    }

    @Override
    public int spawnEggID() {
        return -1;
    }
}

