/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.bosses.slider;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherConfig;
import net.aetherteam.aether.AetherLoot;
import net.aetherteam.aether.AetherNameGen;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.util.Rotation;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.entities.EntityAetherCoin;
import net.aetherteam.aether.entities.bosses.EntityBossMob;
import net.aetherteam.aether.entities.dungeon.EntityRewardItemStack;
import net.aetherteam.aether.entities.dungeon.RewardType;
import net.aetherteam.aether.enums.EnumBossType;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.items.tools.EnumAetherToolType;
import net.aetherteam.aether.items.tools.ItemAetherTool;
import net.aetherteam.aether.player.PlayerAether;
import net.aetherteam.aether.tile_entities.util.TileEntityMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySlider
extends EntityBossMob {
    private static final HashSet<Block> blockBans = new HashSet();
    private double originPointX;
    private double originPointY;
    private double originPointZ;
    private Entity target;
    private int chatCooldown = 60;
    private int time;
    private ArrayList<EntityPlayer> fightingMembers = new ArrayList();
    private boolean missObstacleNextTick = false;
    private static int LOOT_AMOUNT_DROPPED;
    private static int LOOT_AMOUNT_EXTRA;
    private float slideVelocity;
    private int moveCooldown;
    private int direction;
    private boolean originSet;
    private boolean moving = false;
    private boolean hasDungeon;
    private boolean battlegroundSet = false;
    private double distanceToSlide;
    private double distanceSlided;

    public EntitySlider(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_70606_j(500.0f);
        this.setBossName(AetherNameGen.gen());
    }

    public EntitySlider(World world, double x, double y, double z) {
        this(world);
        this.setSpawn(x, y, z);
        this.func_70107_b(x, y, z);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)AetherNameGen.gen());
    }

    public void func_70071_h_() {
        if (this.chatCooldown > 0) {
            --this.chatCooldown;
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        super.func_70071_h_();
        this.updateStats();
        if (!this.isAwake()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getDungeon() != null) {
                if (!this.battlegroundSet) {
                    int x = MathHelper.func_76128_c((double)(this.field_70165_t - 9.0));
                    int y = MathHelper.func_76128_c((double)this.field_70163_u);
                    int z = MathHelper.func_76128_c((double)(this.field_70161_v - 1.0));
                    this.field_70170_p.func_147465_d(x, y, z, AetherBlocks.SliderLabyrinthDoor, 0, 3);
                    TileEntityMultiBlock tileEntity = (TileEntityMultiBlock)this.field_70170_p.func_147438_o(x, y, z);
                    tileEntity.setRotationAndRefresh(Rotation.EAST);
                    this.battlegroundSet = true;
                }
                this.hasDungeon = true;
            }
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 2.3);
            if (player != null && this.isAttackingPlayer(player)) {
                this.field_70170_p.func_72956_a((Entity)this, "aether:aeboss.slider.collide", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                player.field_70181_x += 0.35;
                player.field_70159_w *= 2.0;
                player.field_70179_y *= 2.0;
                this.field_70724_aR = 20;
            }
            if (!this.fightingMembers.isEmpty()) {
                int newTarget = this.field_70170_p.field_73012_v.nextInt(this.fightingMembers.size());
                if (this.fightingMembers.size() > 1) {
                    boolean shouldSwitchTarget = false;
                    ++this.time;
                    if (this.time == 398) {
                        shouldSwitchTarget = true;
                    }
                    if (shouldSwitchTarget && this.fightingMembers.get(newTarget) != null && this.target != this.fightingMembers.get(newTarget)) {
                        this.target = (Entity)this.fightingMembers.get(newTarget);
                        this.time = 0;
                    }
                }
                if (this.target.field_70128_L && this.fightingMembers.get(newTarget) != null) {
                    this.target = (Entity)this.fightingMembers.get(newTarget);
                }
                ArrayList<EntityPlayer> deadMembers = new ArrayList<EntityPlayer>();
                for (EntityPlayer member : this.fightingMembers) {
                    if (!(member.func_110143_aJ() <= 0.0f)) continue;
                    deadMembers.add(member);
                }
                for (EntityPlayer deadMember : deadMembers) {
                    this.fightingMembers.remove(deadMember);
                }
            } else {
                this.reset();
                return;
            }
            if (this.moveCooldown > 0) {
                --this.moveCooldown;
                return;
            }
            if (this.moving) {
                if (this.slideVelocity < 1.0f) {
                    this.slideVelocity += 0.045f;
                }
                if (this.slideVelocity > 1.0f) {
                    this.slideVelocity = 1.0f;
                }
                if (this.direction == 0) {
                    this.field_70159_w = -this.slideVelocity;
                }
                if (this.direction == 1) {
                    this.field_70159_w = this.slideVelocity;
                }
                if (this.direction == 2) {
                    this.field_70181_x = -this.slideVelocity;
                }
                if (this.direction == 3) {
                    this.field_70181_x = this.slideVelocity;
                }
                if (this.direction == 4) {
                    this.field_70179_y = -this.slideVelocity;
                }
                if (this.direction == 5) {
                    this.field_70179_y = this.slideVelocity;
                }
                this.distanceSlided += (double)this.slideVelocity;
                if (this.distanceSlided >= this.distanceToSlide) {
                    float add = (float)(this.distanceToSlide - this.distanceSlided);
                    if (this.direction == 0) {
                        this.field_70159_w += (double)(-add);
                    }
                    if (this.direction == 1) {
                        this.field_70159_w += (double)add;
                    }
                    if (this.direction == 2) {
                        this.field_70181_x += (double)(-add);
                    }
                    if (this.direction == 3) {
                        this.field_70181_x += (double)add;
                    }
                    if (this.direction == 4) {
                        this.field_70179_y += (double)(-add);
                    }
                    if (this.direction == 5) {
                        this.field_70179_y += (double)add;
                    }
                    this.stop();
                }
                if (this.smash()) {
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 3.0f, (0.625f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    this.field_70170_p.func_72956_a((Entity)this, "aether:aeboss.slider.collide", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                } else if (this.field_70123_F && this.direction != 2 & this.direction != 3) {
                    this.missObstacleNextTick = true;
                    this.stop();
                }
            } else if (this.target != null) {
                this.direction = this.calculateDirection(this.target);
                this.distanceToSlide = this.calculateDistanceToSlide(this.target);
                this.moving = true;
                this.distanceSlided = 0.0;
                this.slideVelocity = 0.0f;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.missObstacleNextTick = false;
            } else {
                this.reset();
            }
        }
    }

    private boolean isAttackingPlayer(EntityPlayer player) {
        if (this.field_70724_aR <= 0) {
            if (player.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
                return player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f);
            }
            return player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 6.0f);
        }
        return false;
    }

    public void func_70108_f(Entity collidingEntity) {
        super.func_70108_f(collidingEntity);
    }

    private void sendMessage(EntityPlayer player, String s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatCooldown <= 0 && side.isClient()) {
            Aether.proxy.displayMessage(player, s);
            this.chatCooldown = 60;
        }
    }

    public boolean canAttackSlider(EntityPlayer player) {
        ItemStack equippedItem = player.func_71045_bC();
        String tipPrefix = null;
        if (equippedItem != null) {
            if (!(equippedItem.func_77973_b() instanceof ItemPickaxe)) {
                if (equippedItem.func_77973_b() instanceof ItemAetherTool) {
                    ItemAetherTool aetherTool = (ItemAetherTool)equippedItem.func_77973_b();
                    if (aetherTool.toolType == EnumAetherToolType.PICKAXE) {
                        return true;
                    }
                }
                tipPrefix = "A " + equippedItem.func_77973_b().func_77653_i(equippedItem) + " wouldn't work on this.";
            }
        } else {
            tipPrefix = "My fist wouldn't work on this.";
        }
        if (tipPrefix != null) {
            this.sendMessage(player, "Hmm. It's a rock-solid block. " + tipPrefix);
            return false;
        }
        return true;
    }

    @Override
    protected void func_70785_a(Entity entity, float par2) {
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            boolean hasAttacked;
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            PlayerAether playerInfo = PlayerAether.get(player);
            if (this.canAttackSlider(player)) {
                if (!this.isAwake() && playerInfo.getParty() != null) {
                    Collection<PlayerAether> neededPlayers = playerInfo.getParty().getAllMembers();
                    List playersInRoom = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 8.0), (double)(this.field_70163_u - 8.0), (double)(this.field_70161_v - 8.0), (double)(this.field_70165_t + 8.0), (double)(this.field_70163_u + 8.0), (double)(this.field_70161_v + 8.0)));
                    for (PlayerAether neededPlayer : neededPlayers) {
                        if (neededPlayer.entityPlayer.field_71093_bK != AetherConfig.DungeonDimensionID || playersInRoom.contains(neededPlayer.entityPlayer)) continue;
                        this.sendMessage(player, "Every member must be in the boss room before you can begin.");
                        return false;
                    }
                }
            } else {
                return false;
            }
            if (!player.field_70128_L) {
                playerInfo.setCurrentBoss(this);
            }
            if (hasAttacked = super.func_70097_a(source, this.getDamage(damage))) {
                if (!this.isAwake()) {
                    if (playerInfo.getDungeon() != null) {
                        this.setDungeon(playerInfo.getDungeon());
                    }
                    if (!this.fightingMembers.contains(player)) {
                        this.fightingMembers.add(player);
                    }
                    this.target = player;
                    if (!this.originSet) {
                        this.originPointX = this.field_70165_t;
                        this.originPointY = this.field_70163_u;
                        this.originPointZ = this.field_70161_v;
                        this.originSet = true;
                    }
                    this.setupDungeon(false);
                    this.field_70170_p.func_72956_a((Entity)this, "aether:aeboss.slider.awake", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.setAwake(true);
                } else {
                    if (this.hasDungeon) {
                        this.fightingMembers = this.getDungeon().getMembers();
                    }
                    if (!this.fightingMembers.contains(player)) {
                        this.fightingMembers.add(player);
                    }
                }
            }
            return hasAttacked;
        }
        return false;
    }

    protected void updateStats() {
        this.field_70747_aH = 0.0f;
        this.field_70177_z = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70761_aq = 0.0f;
        this.field_70143_R = 0.0f;
        this.field_70174_ab = -1;
        this.func_70066_B();
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return entity.field_70121_D;
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    protected String func_70639_aQ() {
        return !this.isAwake() ? "ambient.cave.cave" : null;
    }

    protected String func_70621_aR() {
        return "step.stone";
    }

    protected String func_70673_aS() {
        return "aether:aeboss.slider.die";
    }

    protected boolean func_70780_i() {
        return true;
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70664_aZ() {
    }

    public void func_70024_g(double d, double d1, double d2) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    public void func_70018_K() {
    }

    public void func_70060_a(float p_70060_1_, float p_70060_2_, float p_70060_3_) {
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    @Override
    public void func_70645_a(DamageSource source) {
        if (this.hasDungeon) {
            this.dropLoot();
            this.setDoor(Blocks.field_150350_a);
            this.setupDungeon(true);
            this.getDungeon().finish();
        }
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.3f, false);
        super.func_70645_a(source);
    }

    protected void func_70628_a(boolean var1, int looting) {
        for (int i = 0; i < 20 + this.field_70146_Z.nextInt(10); ++i) {
            this.func_145779_a(Item.func_150898_a((Block)AetherBlocks.DungeonStone), 1);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("isAwake", this.isAwake());
        nbttagcompound.func_74780_a("originPointX", this.originPointX);
        nbttagcompound.func_74780_a("originPointY", this.originPointY);
        nbttagcompound.func_74780_a("originPointZ", this.originPointZ);
        nbttagcompound.func_74757_a("originSet", this.originSet);
        nbttagcompound.func_74778_a("bossName", this.getBossName());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setAwake(nbttagcompound.func_74767_n("isAwake"));
        this.originPointX = nbttagcompound.func_74769_h("originPointX");
        this.originPointY = nbttagcompound.func_74769_h("originPointY");
        this.originPointZ = nbttagcompound.func_74769_h("originPointZ");
        this.originSet = nbttagcompound.func_74767_n("originSet");
        this.setBossName(nbttagcompound.func_74779_i("bossName"));
    }

    public void reset() {
        this.setDoor(Blocks.field_150350_a);
        this.revertSetup();
        this.battlegroundSet = false;
        this.stop();
        this.moveCooldown = 0;
        this.setAwake(false);
        this.fightingMembers.clear();
        if (MinecraftServer.func_71276_C() != null) {
            if (MinecraftServer.func_71276_C().func_71262_S()) {
                this.func_70606_j(this.func_110138_aP());
            } else {
                this.func_70606_j(this.func_110143_aJ());
            }
        } else {
            this.func_70606_j(this.func_110143_aJ());
        }
        this.target = null;
        this.func_70107_b(this.originPointX, this.originPointY, this.originPointZ);
    }

    public void stop() {
        this.moving = false;
        if (this.missObstacleNextTick | this.direction == this.calculateDirection(this.target)) {
            this.moveCooldown = 0;
        } else {
            this.moveCooldown = 12;
            this.slideVelocity = 0.0f;
        }
        this.distanceToSlide = 0.0;
        this.distanceSlided = 0.0;
    }

    public void dropLoot() {
        if (!this.field_70170_p.field_72995_K) {
            boolean spawnMusicDisk = this.field_70146_Z.nextInt(10) == 0;
            int randCoinAmount = this.field_70146_Z.nextInt(25);
            for (int amount = 0; amount < 25 + randCoinAmount; ++amount) {
                this.field_70170_p.func_72838_d((Entity)new EntityAetherCoin(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1));
                if (amount >= 3) continue;
                this.field_70170_p.func_72838_d((Entity)new EntityAetherCoin(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25));
            }
            if (this.getDungeon() != null) {
                for (EntityPlayer member : this.fightingMembers) {
                    int extraAmount = this.field_70146_Z.nextInt(LOOT_AMOUNT_EXTRA + 1);
                    PlayerAether player = PlayerAether.get(member);
                    member.func_71029_a((StatBase)AetherAchievements.defeatSlider);
                    for (int rewardCount = 0; rewardCount < LOOT_AMOUNT_DROPPED + extraAmount; ++rewardCount) {
                        ItemStack reward = AetherLoot.SLIDER_LABYRINTH.getRandomItem(player, this.field_70146_Z);
                        player.addDungeonReward(AetherLoot.SLIDER_LABYRINTH.getChoiceList(), reward);
                        this.field_70170_p.func_72838_d((Entity)new EntityRewardItemStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, reward, PlayerAether.get(member).getProfile().getUsername(), RewardType.WHITELISTED));
                    }
                    if (!spawnMusicDisk) continue;
                    this.field_70170_p.func_72838_d((Entity)new EntityRewardItemStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(AetherItems.LabyrinthMusicDisc, 1, 0), PlayerAether.get(member).getProfile().getUsername(), RewardType.WHITELISTED));
                }
            }
        }
    }

    private void setDoor(Block block) {
        int x = MathHelper.func_76128_c((double)this.originPointX);
        int y = MathHelper.func_76128_c((double)this.originPointY);
        int z = MathHelper.func_76128_c((double)this.originPointZ);
        for (int y1 = 1; y1 < 5; ++y1) {
            for (int z1 = 5; z1 < 10; ++z1) {
                this.field_70170_p.func_147449_b(x - 9, y - 3 + y1, z - 8 + z1, block);
            }
        }
    }

    private void setupDungeon(boolean dungeonFinished) {
        int x = MathHelper.func_76128_c((double)this.originPointX);
        int y = MathHelper.func_76128_c((double)this.originPointY);
        int z = MathHelper.func_76128_c((double)this.originPointZ);
        if (dungeonFinished) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -2; j < 1; ++j) {
                    this.field_70170_p.func_147449_b(x + i, y - 3, z + j, AetherBlocks.DungeonStone);
                }
            }
            if (this.field_70170_p.field_73011_w.field_76574_g == Aether.getDungeonDimensionID()) {
                this.field_70170_p.func_147449_b(x, y - 2, z, AetherBlocks.SliderLabyrinthTotem);
            }
        } else {
            int x1;
            for (x1 = -2; x1 < 3; ++x1) {
                for (int z1 = -3; z1 < 2; ++z1) {
                    this.field_70170_p.func_147449_b(x + x1, y - 2, z + z1, Blocks.field_150350_a);
                }
            }
            for (x1 = -2; x1 < 3; ++x1) {
                for (int y1 = 0; y1 < 2; ++y1) {
                    for (int z1 = -3; z1 < 2; ++z1) {
                        this.field_70170_p.func_147449_b(x + x1, y - 4 + y1, z + z1, AetherBlocks.DivineDungeonStone);
                    }
                }
            }
        }
    }

    private void revertSetup() {
        int x = MathHelper.func_76128_c((double)this.originPointX);
        int y = MathHelper.func_76128_c((double)this.originPointY);
        int z = MathHelper.func_76128_c((double)this.originPointZ);
        for (int x1 = -2; x1 < 2; ++x1) {
            for (int z1 = -2; z1 < 2; ++z1) {
                this.field_70170_p.func_147449_b(x + x1, y - 2, z + z1, AetherBlocks.DivineDungeonStone);
            }
        }
    }

    public int calculateDirection(Entity argTarget) {
        if (argTarget == null) {
            return 0;
        }
        int newDir = 0;
        Vec3 diff = Vec3.func_72443_a((double)(argTarget.field_70165_t - (double)MathHelper.func_76128_c((double)this.field_70165_t)), (double)(argTarget.field_70163_u - (double)MathHelper.func_76128_c((double)this.field_70163_u)), (double)(argTarget.field_70161_v - (double)MathHelper.func_76128_c((double)this.field_70161_v)));
        if (diff.field_72448_b >= 2.0 || diff.field_72448_b <= -1.0) {
            newDir = diff.field_72448_b < 0.0 ? 3 : 2;
        } else if (diff.field_72450_a == 0.0) {
            newDir = diff.field_72449_c < 0.0 ? 4 : 5;
        } else if (diff.field_72449_c == 0.0) {
            newDir = diff.field_72450_a < 0.0 ? 0 : 1;
        } else if (diff.field_72450_a < 0.0 && diff.field_72449_c < 0.0) {
            newDir = diff.field_72450_a < diff.field_72449_c ? 0 : 4;
        } else if (diff.field_72450_a > 0.0 && diff.field_72449_c < 0.0) {
            newDir = diff.field_72450_a > -diff.field_72449_c ? 1 : 4;
        } else if (diff.field_72450_a > 0.0 && diff.field_72449_c > 0.0) {
            newDir = diff.field_72450_a > diff.field_72449_c ? 1 : 5;
        } else if (diff.field_72450_a < 0.0 && diff.field_72449_c > 0.0) {
            int n = newDir = -diff.field_72450_a > diff.field_72449_c ? 0 : 5;
        }
        if (this.missObstacleNextTick) {
            newDir = 3;
        }
        return newDir;
    }

    public double calculateDistanceToSlide(Entity argTarget) {
        double distanceToPlayer;
        Vec3 diff = Vec3.func_72443_a((double)(argTarget.field_70165_t - (double)MathHelper.func_76128_c((double)this.field_70165_t)), (double)(argTarget.field_70163_u - (double)MathHelper.func_76128_c((double)this.field_70163_u)), (double)(argTarget.field_70161_v - (double)MathHelper.func_76128_c((double)this.field_70161_v)));
        double d = this.direction == 0 ? -diff.field_72450_a : (this.direction == 1 ? diff.field_72450_a : (this.direction == 2 ? -diff.field_72448_b : (this.direction == 3 ? diff.field_72448_b : (distanceToPlayer = this.direction == 4 ? -diff.field_72449_c : diff.field_72449_c))));
        if (this.missObstacleNextTick) {
            distanceToPlayer = 1.0;
        }
        return distanceToPlayer;
    }

    public double min(double ... numbers) {
        double min = numbers[0];
        for (int i = 1; i < numbers.length; ++i) {
            min = min <= numbers[i] ? min : numbers[i];
        }
        return min;
    }

    public boolean smash() {
        int j1;
        int i1;
        int l;
        int k;
        int j;
        boolean smashed = false;
        double area = 0.2;
        int i = MathHelper.func_76128_c((double)(this.field_70121_D.field_72340_a - area));
        if (this.field_70170_p.func_72904_c(i, j = MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b - area)), k = MathHelper.func_76128_c((double)(this.field_70121_D.field_72339_c - area)), l = MathHelper.func_76128_c((double)(this.field_70121_D.field_72336_d + area)), i1 = MathHelper.func_76128_c((double)(this.field_70121_D.field_72337_e + area)), j1 = MathHelper.func_76128_c((double)(this.field_70121_D.field_72334_f + area)))) {
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = j; l1 <= i1; ++l1) {
                    for (int i2 = k; i2 <= j1; ++i2) {
                        boolean z2;
                        AxisAlignedBB box;
                        Block blockID = this.field_70170_p.func_147439_a(k1, l1, i2);
                        if (blockID == Blocks.field_150350_a || blockBans.contains(blockID) || (box = blockID.func_149668_a(this.field_70170_p, k1, l1, i2)) == null) continue;
                        box.field_72336_d -= (double)l1;
                        box.field_72337_e -= (double)l1;
                        box.field_72334_f -= (double)i2;
                        double xDif1 = this.field_70165_t - (double)k1 - (1.0 - box.field_72336_d);
                        double yDif1 = this.field_70163_u - (double)l1 - (1.0 - box.field_72337_e);
                        double zDif1 = this.field_70161_v - (double)i2 - (1.0 - box.field_72334_f);
                        double xDif2 = this.field_70165_t - 2.0 - (double)k1 - (1.0 - box.field_72336_d);
                        double yDif2 = this.field_70163_u - 2.0 - (double)l1 - (1.0 - box.field_72337_e);
                        double zDif2 = this.field_70161_v - 2.0 - (double)i2 - (1.0 - box.field_72334_f);
                        double smallestDif = this.min(xDif1, yDif1, zDif1, xDif2, yDif2, zDif2);
                        boolean x1 = xDif1 < 0.1 && xDif1 == smallestDif;
                        boolean y1 = yDif1 < 0.1 && yDif1 == smallestDif;
                        boolean z1 = zDif1 < 0.1 && zDif1 == smallestDif;
                        boolean x2 = xDif2 < 0.1 && xDif2 == smallestDif;
                        boolean y2 = yDif2 < 0.1 && yDif2 == smallestDif;
                        boolean bl = z2 = zDif2 < 0.1 && zDif2 == smallestDif;
                        if (!x1 && !y1 && !z1 && !x2 && !y2 && !z2) continue;
                        int metadata = this.field_70170_p.func_72805_g(k1, l1, i1);
                        blockID.func_149664_b(this.field_70170_p, k1, l1, i2, metadata);
                        this.field_70170_p.func_147449_b(k1, l1, i2, Blocks.field_150350_a);
                        Aether.proxy.addDestroyBlockEffects(k1, l1, i2, blockID, metadata);
                        Aether.proxy.spawnSmoke(this.field_70170_p, k1, l1, i2);
                        smashed = true;
                    }
                }
            }
        }
        return smashed;
    }

    public String getBossName() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setBossName(String name) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)name);
        }
    }

    public boolean isAwake() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setAwake(boolean awake) {
        if (awake) {
            this.field_70180_af.func_75692_b(16, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(16, (Object)0);
        }
    }

    public void setSpawn(double x, double y, double z) {
        this.originPointX = x;
        this.originPointY = y;
        this.originPointZ = z;
        this.originSet = true;
    }

    public Dungeon getDungeon() {
        return DungeonHandler.instance().getDungeon(this.dungeonID);
    }

    public void setDungeon(Dungeon argDungeon) {
        this.dungeonID = argDungeon.dungeonId;
    }

    public float getDamage(float damage) {
        if (this.getDungeon() == null || !this.hasDungeon) {
            return damage;
        }
        int playerCount = this.getDungeon().getMembers().size();
        float dungeonDifficulty = (float)(playerCount - 1) * 0.045f;
        float damageDecrease = damage * dungeonDifficulty;
        return MathHelper.func_76131_a((float)((int)(damage - damageDecrease)), (float)1.0f, (float)damage);
    }

    public boolean isCritical() {
        return this.func_110143_aJ() <= 80.0f;
    }

    @Override
    public int getCoinDrops() {
        return 10;
    }

    @Override
    public String getBossTitle() {
        return this.getBossName() + ", the Slider";
    }

    @Override
    public int getBossStage() {
        return 0;
    }

    @Override
    public EnumBossType getBossType() {
        return EnumBossType.BOSS;
    }

    @Override
    public int spawnEggID() {
        return 21;
    }

    static {
        blockBans.add(AetherBlocks.SliderLabyrinthTotem);
        blockBans.add(AetherBlocks.DivineDungeonStone);
        blockBans.add(AetherBlocks.DivineLightDungeonStone);
        blockBans.add(AetherBlocks.DivineSentryStoneWall);
        blockBans.add(AetherBlocks.BloodMossHolystone);
        blockBans.add(AetherBlocks.SliderLabyrinthDoor);
        LOOT_AMOUNT_DROPPED = 2;
        LOOT_AMOUNT_EXTRA = 2;
    }
}

