/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.bosses;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherNameGen;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.entities.EntitySentry;
import net.aetherteam.aether.entities.bosses.EntityBossMob;
import net.aetherteam.aether.enums.EnumBossType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntitySentryGuardian
extends EntityBossMob {
    private final String bossName;
    private int heightOffsetUpdateTime;
    private float heightOffset = 0.5f;
    public int chatTime;
    private int attackTimer;
    private int cappedAmount;

    public EntitySentryGuardian(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70747_aH = 0.0f;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b()));
        this.bossName = AetherNameGen.gen();
        this.func_70105_a(2.25f, 2.5f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)1.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_70606_j(250.0f);
    }

    public EntitySentryGuardian(World world, int x, int y, int z, int rad, int dir) {
        super(world);
        this.bossName = AetherNameGen.gen();
        this.func_70105_a(2.25f, 2.5f);
        this.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
        this.func_70606_j(250.0f);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public boolean getHasBeenAttacked() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setHasBeenAttacked(boolean attack) {
        if (attack) {
            this.field_70180_af.func_75692_b(16, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(16, (Object)0);
        }
    }

    @Override
    protected Entity func_70782_k() {
        if (this.getHasBeenAttacked()) {
            EntityPlayer var1 = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            return var1 != null && this.func_70685_l((Entity)var1) ? var1 : null;
        }
        return null;
    }

    public void spawnSentry() {
        if (!this.field_70170_p.field_72995_K && this.cappedAmount < 5) {
            EntitySentry sentry = new EntitySentry(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)sentry);
            sentry.field_70181_x = 1.0;
            sentry.field_70143_R = -100.0f;
            sentry.func_70624_b(this.func_70638_az());
            ++this.cappedAmount;
            sentry.setParent(this);
            this.field_70170_p.func_72956_a((Entity)this, "aether:aemob.sentryGuardian.spawn", 2.0f, 1.0f);
        }
    }

    @Override
    public void func_70645_a(DamageSource source) {
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.3f, false);
        this.spawnSentry();
        if (!this.field_70170_p.field_72995_K) {
            Dungeon dungeon;
            if (source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer attackingPlayer = (EntityPlayer)source.func_76346_g();
                dungeon = PlayerAether.get(attackingPlayer).getDungeon();
            } else {
                dungeon = DungeonHandler.instance().getDungeonAt((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            }
            if (dungeon != null) {
                dungeon.addKeyFragment();
            }
        }
        super.func_70645_a(source);
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        this.field_70747_aH = 0.0f;
        if (this.func_110143_aJ() > 0.0f) {
            double a = this.field_70146_Z.nextFloat() - 0.5f;
            double b = this.field_70146_Z.nextFloat();
            double c = this.field_70146_Z.nextFloat() - 0.5f;
            double d = this.field_70165_t + a * b;
            double e = this.field_70121_D.field_72338_b + b - (double)0.3f;
            double f = this.field_70161_v + c * b;
            if (!this.getHasBeenAttacked()) {
                this.field_70170_p.func_72869_a("reddust", d, e, f, (double)0.29f, (double)0.28f, (double)0.48f);
            } else {
                this.field_70170_p.func_72869_a("reddust", d, e, f, (double)0.43f, (double)0.18f, (double)0.28f);
            }
        }
        if (!(this.func_70782_k() instanceof EntityPlayer) && this.getHasBeenAttacked()) {
            this.setHasBeenAttacked(false);
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean var2 = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (var2) {
            par1Entity.field_70181_x += (double)0.4f;
            par1Entity.field_70179_y += (double)0.4f;
            par1Entity.field_70159_w += (double)0.4f;
            par1Entity.field_70133_I = true;
        }
        this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.throw", 1.0f, 1.0f);
        return var2;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public int func_82193_c(Entity par1Entity) {
        return 10;
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return par1PotionEffect.func_76456_a() != Potion.field_76436_u.field_76415_H && super.func_70687_e(par1PotionEffect);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76364_f();
        Entity attacker = source.func_76346_g();
        if (entity != null && source.func_76352_a()) {
            if (attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_71045_bC() != null) {
                this.chatItUp((EntityPlayer)attacker, "Better switch to a sword, my " + ((EntityPlayer)attacker).func_71045_bC().func_77973_b().func_77653_i(((EntityPlayer)attacker).func_71045_bC()) + " doesn't seem to affect it.");
                this.chatTime = 60;
            }
            return false;
        }
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            PlayerAether playerInfo = PlayerAether.get(player);
            if (!player.field_70128_L) {
                playerInfo.setCurrentBoss(this);
            }
        }
        this.setHasBeenAttacked(true);
        return super.func_70097_a(source, damage);
    }

    private void chatItUp(EntityPlayer player, String s) {
        if (this.chatTime <= 0) {
            Aether.proxy.displayMessage(player, s);
            this.chatTime = 60;
        }
    }

    @Override
    public void func_70636_d() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.getHasBeenAttacked()) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70146_Z.nextInt(100) == 1 && this.func_70777_m() != null) {
                this.spawnSentry();
            }
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
            }
            if (this.func_70777_m() != null && this.func_70777_m().field_70163_u + (double)this.func_70777_m().func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                this.field_70181_x += (0.700000011920929 - this.field_70181_x) * 0.700000011920929;
            }
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setHasBeenAttacked(par1NBTTagCompound.func_74767_n("HasBeenAttacked"));
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("HasBeenAttacked", this.getHasBeenAttacked());
    }

    protected String func_70673_aS() {
        return "aether:aemob.sentryGuardian.death";
    }

    protected String func_70639_aQ() {
        return "aether:aemob.sentryGuardian.living";
    }

    protected String func_70621_aR() {
        return "aether:aemob.sentryGuardian.hit";
    }

    protected void func_70069_a(float par1) {
    }

    @Override
    public String getBossTitle() {
        return this.bossName + ", the Sentry Guardian";
    }

    @Override
    public int getBossStage() {
        return 0;
    }

    @Override
    public EnumBossType getBossType() {
        return EnumBossType.MINI;
    }

    public void failedYou() {
        --this.cappedAmount;
    }

    @Override
    public int getCoinDrops() {
        return 3 + this.random.nextInt(4);
    }

    @Override
    public int spawnEggID() {
        return 19;
    }
}

