/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.dungeons.worldgen.rooms;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.dungeons.Dungeon;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class DungeonRoom
extends StructureComponent {
    public List<StructureComponent> linkedRooms = new LinkedList<StructureComponent>();
    protected Dungeon dungeonInstance;
    public List<StructureBoundingBox> entrances = new LinkedList<StructureBoundingBox>();
    int YOffset = 0;

    public DungeonRoom(Dungeon dungeon, int componentType, StructureComponent previousStructure, Random rand, int boxWidth, int boxLength) {
        super(componentType);
        this.dungeonInstance = dungeon;
        if (previousStructure != null) {
            this.linkedRooms.add(previousStructure);
        }
        this.field_74887_e = new StructureBoundingBox(boxWidth, 50, boxLength, boxWidth + 7 + rand.nextInt(6), 60, boxLength + 7 + rand.nextInt(6));
        this.addEntranceToAllFourWalls();
    }

    public DungeonRoom(Dungeon dungeon, int par1, StructureComponent previousStructor, Random par2Random) {
        super(par1);
        this.dungeonInstance = dungeon;
        this.linkedRooms.add(previousStructor);
    }

    public DungeonRoom(Dungeon dungeon, int par1, StructureComponent previousStructor, Random par2Random, StructureBoundingBox structureBoundingBox, int direction) {
        super(par1);
        this.dungeonInstance = dungeon;
        this.linkedRooms.add(previousStructor);
        this.field_74887_e = structureBoundingBox;
        this.addEntranceToAllFourWalls();
    }

    public void addEntranceToAllFourWalls() {
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1 + this.YOffset, this.field_74887_e.field_78896_c - 2, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78896_c));
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1 + this.YOffset, this.field_74887_e.field_78892_f, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f + 2));
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78897_a - 2, this.field_74887_e.field_78895_b + 1 + this.YOffset, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1));
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 1 + this.YOffset, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d + 2, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1));
    }

    public void addStructure(List components, Random random, int i, int j, int k, int direction, int componentType) {
        StructureComponent var7 = this.dungeonInstance.getNextDungeonRoom(this, components, random, i, j, k, direction, componentType);
        if (var7 != null) {
            this.linkedRooms.add(var7);
        }
    }

    protected void func_151550_a(World world, Block blockID, int blockMeta, int x, int y, int z, StructureBoundingBox boundingBox) {
        if (boundingBox.func_78890_b(x, y, z)) {
            world.func_147465_d(x, y, z, blockID, blockMeta, 2);
        }
    }

    public void func_74861_a(StructureComponent previousStructor, List par2List, Random par3Random) {
        this.buildComponent(par2List, par3Random);
    }

    public void buildComponent(List par2List, Random par3Random) {
        int var5;
        int componentType = this.func_74877_c();
        int var6 = 2;
        if (this.field_74887_e.func_78882_c() - var6 <= 0) {
            var6 = 1;
        }
        for (var5 = 0; var5 < this.field_74887_e.func_78883_b() && var5 + 3 <= this.field_74887_e.func_78883_b(); ++var5) {
            this.addStructure(par2List, par3Random, this.field_74887_e.field_78897_a + var5, this.field_74887_e.field_78895_b + par3Random.nextInt(var6) + this.YOffset, this.field_74887_e.field_78896_c - 1, 2, componentType);
        }
        for (var5 = 0; var5 < this.field_74887_e.func_78883_b() && var5 + 3 <= this.field_74887_e.func_78883_b(); ++var5) {
            this.addStructure(par2List, par3Random, this.field_74887_e.field_78897_a + var5, this.field_74887_e.field_78895_b + par3Random.nextInt(var6) + this.YOffset, this.field_74887_e.field_78892_f + 1, 0, componentType);
        }
        for (var5 = 0; var5 < this.field_74887_e.func_78880_d() && var5 + 3 <= this.field_74887_e.func_78880_d(); ++var5) {
            this.addStructure(par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par3Random.nextInt(var6) + this.YOffset, this.field_74887_e.field_78896_c + var5, 1, componentType);
        }
        for (var5 = 0; var5 < this.field_74887_e.func_78880_d() && var5 + 3 >= this.field_74887_e.func_78880_d(); ++var5) {
            this.addStructure(par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par3Random.nextInt(var6) + this.YOffset, this.field_74887_e.field_78896_c + var5, 3, componentType);
        }
    }

    public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
        this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, AetherBlocks.DivineDungeonStone, Blocks.field_150350_a, false);
        this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.cutHolesForEntrances(par1World, par2Random, par3StructureBoundingBox);
        return true;
    }

    public void cutHolesForEntrances(World objWorld, Random random, StructureBoundingBox par3StructureBoundingBox) {
        Iterator<StructureBoundingBox> iterator = this.entrances.iterator();
        while (iterator.hasNext()) {
            StructureBoundingBox entrance;
            StructureBoundingBox myCube = entrance = iterator.next();
            for (StructureComponent linkedRoom : this.linkedRooms) {
                for (StructureBoundingBox entrance1 : ((DungeonRoom)linkedRoom).entrances) {
                    StructureBoundingBox cube = this.findIntercetingCube(myCube, entrance1);
                    if (cube == null) continue;
                    this.func_151549_a(objWorld, par3StructureBoundingBox, cube.field_78897_a, cube.field_78895_b, cube.field_78896_c, cube.field_78893_d, cube.field_78894_e, cube.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                }
            }
        }
    }

    public StructureBoundingBox findIntercetingCube(StructureBoundingBox b1, StructureBoundingBox b2) {
        int minX = Math.max(b1.field_78897_a, b2.field_78897_a);
        int minY = Math.max(b1.field_78895_b, b2.field_78895_b);
        int minZ = Math.max(b1.field_78896_c, b2.field_78896_c);
        int maxX = Math.min(b1.field_78893_d, b2.field_78893_d);
        int maxY = Math.min(b1.field_78894_e, b2.field_78894_e);
        int maxZ = Math.min(b1.field_78892_f, b2.field_78892_f);
        if (minX < maxX && minY < maxY && minZ < maxZ) {
            return new StructureBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return null;
    }

    protected void func_143012_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_143011_b(NBTTagCompound nbttagcompound) {
    }
}

