/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.blocks.util;

import net.aetherteam.aether.blocks.util.Rotation;
import net.aetherteam.aether.tile_entities.util.TileEntityMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class BlockMultiTileEntity
extends BlockContainer {
    protected AxisAlignedBB size = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    protected static final int TILE_ENTITY = 0;
    public static final int DUMMY_BLOCK = 1;
    public boolean useDefaultCollision = false;

    protected BlockMultiTileEntity(Material material) {
        super(material);
    }

    public boolean isDummyBlock(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata == 1;
    }

    public boolean isTileEntity(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata == 0;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 0;
    }

    public TileEntityMultiBlock getLinkedTileEntity(World world, int x, int y, int z) {
        int minX = x - this.getWidth();
        int minY = y - this.getHeight();
        int minZ = z - this.getLength();
        int maxX = x + this.getWidth();
        int maxY = y + this.getHeight();
        int maxZ = z + this.getLength();
        for (int x1 = minX; x1 < maxX; ++x1) {
            for (int y1 = minY; y1 < maxY; ++y1) {
                for (int z1 = minZ; z1 < maxZ; ++z1) {
                    TileEntity tile = world.func_147438_o(x1, y1, z1);
                    if (!(tile instanceof TileEntityMultiBlock)) continue;
                    TileEntityMultiBlock tileEntity = (TileEntityMultiBlock)tile;
                    return tileEntity;
                }
            }
        }
        return null;
    }

    public int getWidth() {
        return (int)(this.size.field_72336_d - this.size.field_72340_a + 1.0);
    }

    public int getHeight() {
        return (int)(this.size.field_72337_e - this.size.field_72338_b + 1.0);
    }

    public int getLength() {
        return (int)(this.size.field_72334_f - this.size.field_72339_c + 1.0);
    }

    public void setBlockSize(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.size = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public AxisAlignedBB getBlockSize() {
        return this.size;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entityliving, stack);
        TileEntityMultiBlock tileEntity = (TileEntityMultiBlock)world.func_147438_o(x, y, z);
        Rotation rotation = null;
        tileEntity.setSize(this.size);
        if (entityliving != null) {
            int direction = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (direction == 0) {
                rotation = Rotation.SOUTH;
            }
            if (direction == 1) {
                rotation = Rotation.WEST;
            }
            if (direction == 2) {
                rotation = Rotation.NORTH;
            }
            if (direction == 3) {
                rotation = Rotation.EAST;
            }
            tileEntity.rotate(world, rotation, x, y, z);
        }
        if (world.func_72805_g(x, y, z) != 1) {
            if (rotation == null) {
                rotation = tileEntity.getCurrentRotation(world, x, y, z);
                tileEntity.setCurrentRotation(world, Rotation.NORTH, x, y, z);
                tileEntity.rotate(world, rotation, x, y, z);
            }
            TileEntityMultiBlock.Action addMultiBlocks = new TileEntityMultiBlock.Action((Block)this){

                @Override
                public Object onAction(World world, int x, int y, int z, Block blockID, int blockMetadata) {
                    if (blockID != this.block && !(world.func_147438_o(x, y, z) instanceof TileEntityMultiBlock)) {
                        world.func_147465_d(x, y, z, this.block, 1, 2);
                    }
                    return null;
                }

                @Override
                public boolean shouldReturnObject(World world, int x, int y, int z) {
                    return false;
                }
            };
            tileEntity.iterateSize(addMultiBlocks, world);
            tileEntity.hasInit = true;
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileEntityMultiBlock tileEntity = this.getLinkedTileEntity(world, x, y, z);
        if (tileEntity != null) {
            tileEntity.setSize(this.size);
            if (tileEntity.rotation == Rotation.WEST || tileEntity.rotation == Rotation.EAST) {
                tileEntity.rotate(world, true, x, y, z);
            }
            int minX = MathHelper.func_76128_c((double)tileEntity.size.field_72340_a);
            int minY = MathHelper.func_76128_c((double)tileEntity.size.field_72338_b);
            int minZ = MathHelper.func_76128_c((double)tileEntity.size.field_72339_c);
            int maxX = MathHelper.func_76128_c((double)tileEntity.size.field_72336_d);
            int maxY = MathHelper.func_76128_c((double)tileEntity.size.field_72337_e);
            int maxZ = MathHelper.func_76128_c((double)tileEntity.size.field_72334_f);
            for (int x1 = minX; x1 < maxX; ++x1) {
                for (int y1 = minY; y1 < maxY; ++y1) {
                    for (int z1 = minZ; z1 < maxZ; ++z1) {
                        if (!world.func_147439_a(x1, y1, z1).func_149727_a(world, x1, y1, z1, entityplayer, par6, par7, par8, par9)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int blockMetadata) {
        TileEntityMultiBlock tileEntity = this.getLinkedTileEntity(world, x, y, z);
        if (tileEntity != null) {
            tileEntity.setSize(this.size);
            if (tileEntity.rotation == Rotation.WEST || tileEntity.rotation == Rotation.EAST) {
                tileEntity.rotate(world, true, x, y, z);
            }
            TileEntityMultiBlock.Action destroyMultiBlocks = new TileEntityMultiBlock.Action((Block)this){

                @Override
                public Object onAction(World world, int x, int y, int z, Block blockID, int blockMetadata) {
                    if (blockID == BlockMultiTileEntity.this) {
                        world.func_147468_f(x, y, z);
                    }
                    return null;
                }

                @Override
                public boolean shouldReturnObject(World world, int x, int y, int z) {
                    return false;
                }
            };
            tileEntity.iterateSize(destroyMultiBlocks, world);
        }
        super.func_149749_a(world, x, y, z, blockID, blockMetadata);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (this.useDefaultCollision) {
            return super.func_149668_a(world, x, y, z);
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityMultiBlock) {
            TileEntityMultiBlock multiTileEntity = (TileEntityMultiBlock)tileEntity;
            AxisAlignedBB blockSize = multiTileEntity.getSize();
            return this.isDummyBlock(world, x, y, z) ? super.func_149668_a(world, x, y, z) : blockSize;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public final TileEntity func_149915_a(World world, int meta) {
        TileEntityMultiBlock tileEntity = this.createMultiTileEntity(world);
        return tileEntity;
    }

    public abstract TileEntityMultiBlock createMultiTileEntity(World var1);
}

