/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.blocks.natural;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.blocks.natural.BlockAercloud;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockAercloudOld
extends BlockAercloud {
    @Override
    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List creativeList) {
        for (Type type : Type.values()) {
            creativeList.add(new ItemStack(item, 1, type.getMetadata()[0]));
        }
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        Type type = Type.get(world, x, y, z);
        return type.getCollisionBox(world, x, y, z);
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        Type type = Type.get(world, x, y, z);
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
            return;
        }
        type.onEntityCollide(world, entity, x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        for (Type type : Type.values()) {
            type.registerIcons(iconRegister);
        }
    }

    @Override
    public IIcon func_149691_a(int side, int blockMetadata) {
        return Type.get(blockMetadata).getIcon(side, blockMetadata);
    }

    public static enum Type {
        COLD("aercloudCold"){

            @Override
            public int[] getMetadata() {
                return new int[]{0};
            }
        }
        ,
        BLUE("aercloudBlue"){

            @Override
            public int[] getMetadata() {
                return new int[]{1};
            }

            @Override
            public void onEntityCollide(World world, Entity entity, int x, int y, int z) {
                if (!entity.func_70115_ae() && !entity.func_70093_af()) {
                    entity.field_70181_x = 2.0;
                    if (Aether.isClient() && !(entity instanceof EntityFX)) {
                        entity.field_70181_x = 2.0;
                        int splashAmount = 50;
                        for (int count = 0; count < 50; ++count) {
                            double xOffset = (double)x + rand.nextDouble();
                            double yOffset = (double)y + rand.nextDouble();
                            double zOffset = (double)z + rand.nextDouble();
                            world.func_72869_a("splash", xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
                        }
                    }
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        player.func_71029_a((StatBase)AetherAchievements.blueCloud);
                        if (player.field_71075_bZ.field_75100_b) {
                            return;
                        }
                    }
                    world.func_72956_a(entity, "aether:aemisc.aercloud", 0.35f, world.field_73012_v.nextFloat());
                } else {
                    super.onEntityCollide(world, entity, x, y, z);
                }
            }

            @Override
            public AxisAlignedBB getCollisionBox(World world, int x, int y, int z) {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
            }
        }
        ,
        GOLDEN("aercloudGolden"){

            @Override
            public int[] getMetadata() {
                return new int[]{2};
            }

            @Override
            public void onEntityCollide(World world, Entity entity, int x, int y, int z) {
                if (!entity.func_70115_ae() && !entity.func_70093_af()) {
                    entity.field_70181_x = -1.5;
                } else {
                    super.onEntityCollide(world, entity, x, y, z);
                }
            }

            @Override
            public AxisAlignedBB getCollisionBox(World world, int x, int y, int z) {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
            }
        }
        ,
        GREEN("aercloudGreen"){

            @Override
            public int[] getMetadata() {
                return new int[]{3};
            }

            @Override
            public void onEntityCollide(World world, Entity entity, int x, int y, int z) {
                if (!entity.func_70115_ae() && !entity.func_70093_af()) {
                    entity.field_70159_w *= 5.0E-10;
                    entity.field_70179_y *= 5.0E-10;
                    int chance = rand.nextInt(4);
                    if (chance == 0) {
                        entity.field_70179_y = -2.5;
                    } else if (chance == 1) {
                        entity.field_70159_w = 2.5;
                    } else if (chance == 2) {
                        entity.field_70179_y = 2.5;
                    } else if (chance == 3) {
                        entity.field_70159_w = -2.5;
                    }
                } else {
                    super.onEntityCollide(world, entity, x, y, z);
                }
            }

            @Override
            public AxisAlignedBB getCollisionBox(World world, int x, int y, int z) {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
            }
        }
        ,
        STORM("aercloudStorm"){

            @Override
            public int[] getMetadata() {
                return new int[]{4};
            }
        };

        private static Random rand;
        protected IIcon icon;
        protected IIcon opaqueIcon;
        protected String name;

        private Type(String name) {
            this.name = name;
        }

        public void onEntityCollide(World world, Entity entity, int x, int y, int z) {
            if (entity.field_70181_x < 0.0) {
                entity.field_70181_x *= 0.005;
            }
        }

        public AxisAlignedBB getCollisionBox(World world, int x, int y, int z) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y, (double)(z + 1));
        }

        public static Type get(World world, int x, int y, int z) {
            int blockMetadata = world.func_72805_g(x, y, z);
            return Type.get(blockMetadata);
        }

        public static Type get(int blockMetadata) {
            for (Type type : Type.values()) {
                for (int meta : type.getMetadata()) {
                    if (meta != blockMetadata) continue;
                    return type;
                }
            }
            return Type.values()[0];
        }

        public void registerIcons(IIconRegister iconRegister) {
            String iconName = Aether.modAddress() + this.name;
            this.icon = iconRegister.func_94245_a(iconName);
            this.opaqueIcon = iconRegister.func_94245_a(iconName + "_opaque");
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon(int side, int blockMetadata) {
            return Minecraft.func_71410_x().field_71474_y.field_74347_j ? this.icon : this.opaqueIcon;
        }

        public abstract int[] getMetadata();

        static {
            rand = new Random();
        }
    }
}

