/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.blocks.dungeon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.util.BlockMultiTileEntity;
import net.aetherteam.aether.client.gui.dungeons.GuiDungeonEntrance;
import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.player.PlayerAether;
import net.aetherteam.aether.tile_entities.TileEntityTotem;
import net.aetherteam.aether.tile_entities.util.TileEntityMultiBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockSliderLabyrinthTotem
extends BlockMultiTileEntity {
    private Random rand;
    private IIcon sideIcon;

    public BlockSliderLabyrinthTotem() {
        super(Material.field_151576_e);
        this.useDefaultCollision = true;
        this.rand = new Random();
        this.func_149711_c(-1.0f);
        this.func_149752_b(1000000.0f);
        this.setBlockSize(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
    }

    public DungeonPosition getDungeonPosition(World world, int x, int y, int z) {
        int radius = 1;
        int minX = x;
        int minZ = z;
        for (int ix = x - radius; ix < x + radius; ++ix) {
            for (int iz = z - radius; iz < z + radius; ++iz) {
                if (world.func_147439_a(ix, y, iz) != this) continue;
                minX = Math.min(minX, ix);
                minZ = Math.min(minZ, iz);
            }
        }
        return new DungeonPosition(minX, y, minZ, world.field_73011_w.field_76574_g);
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui(World world, int x, int y, int z) {
        DungeonPosition dungeonPosition = this.getDungeonPosition(world, x, y, z);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDungeonEntrance(dungeonPosition));
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (entityplayer.field_71093_bK == Aether.getDungeonDimensionID()) {
            if (!world.field_72995_K) {
                world.func_72980_b((double)z, (double)y, (double)z, "aether:aeportal.totemWoosh", 1.0f, 1.0f, true);
                Dungeon dungeon = PlayerAether.get(entityplayer).getDungeon();
                if (dungeon != null) {
                    dungeon.leave((EntityPlayerMP)entityplayer);
                } else {
                    Aether.TELEPORTER.createPortal = false;
                    Aether.teleportPlayerToAether(entityplayer, false);
                    Aether.TELEPORTER.createPortal = true;
                }
            }
        } else if (world.field_72995_K) {
            this.openGui(world, x, y, z);
        }
        return true;
    }

    public IIcon func_149691_a(int i, int meta) {
        return this.sideIcon;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return AetherBlocks.TotemRenderId;
    }

    public void func_149651_a(IIconRegister par1IIconRegister) {
        this.sideIcon = par1IIconRegister.func_94245_a("aether:carvedStone");
    }

    @Override
    public TileEntityMultiBlock createMultiTileEntity(World world) {
        try {
            return new TileEntityTotem();
        }
        catch (Exception var3) {
            throw new RuntimeException(var3);
        }
    }
}

