/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum AetherLoot {
    NORMAL(new Choice(AetherItems.CornstarchBowl, 30), new ChoiceWithRandomAmount(Item.func_150898_a((Block)AetherBlocks.AmbrosiumTorch), 30, 8, 2), new ChoiceWithRandomAmount(Items.field_151015_O, 30, 12, 1), new ChoiceWithRandomAmount(Items.field_151100_aR, 3, 30, 6, 1), new ChoiceWithRandomAmount(AetherItems.SkyrootStick, 30, 12, 1), new ChoiceWithRandomAmount(Item.func_150898_a((Block)AetherBlocks.SkyrootPlank), 30, 10, 1), new ChoiceWithRandomAmount(AetherItems.AmbrosiumShard, 28, 12, 1), new ChoiceWithRandomAmount(Items.field_151106_aX, 24, 8, 1), new ChoiceWithRandomAmount(AetherItems.BlueBerry, 24, 8, 1), new ChoiceWithRandomAmount(Item.func_150898_a((Block)AetherBlocks.DungeonStone), 20, 20, 1), new ChoiceWithRandomAmount(Item.func_150898_a((Block)AetherBlocks.LightDungeonStone), 20, 20, 1), new ChoiceWithRandomAmount(AetherItems.Orange, 16, 8, 1), new ChoiceWithRandomAmount(Items.field_151147_al, 12, 6, 1), new ChoiceWithRandomAmount(AetherItems.GummySwet, 8, 4, 1){

        @Override
        public int getDamage(Random rand) {
            return AetherLoot.getRandomNumber(rand, 3);
        }
    }, new ChoiceWithRandomAmount(AetherItems.ZaniteGemstone, 6, 3, 1), new Choice(AetherItems.PinkBabySwet, 2), new Choice(AetherItems.KraisithCapsule, 2), new Choice(AetherItems.FangrinCapsule, 2), new Choice(AetherItems.Recording892, 1), new Choice(AetherItems.ContinuumOrb, 1), new Choice(AetherItems.ContinuumBomb, 1)),
    SLIDER_LABYRINTH(new Choice(AetherItems.HolySword, 15), new ChoiceWithRandomAmount(AetherItems.LightningKnife, 14, 16, 6), new Choice(AetherItems.IronBubble, 13), new Choice(AetherItems.PigSlayer, 11), new Choice(AetherItems.FlamingSword, 11), new Choice(AetherItems.NeptuneGloves, 10), new Choice(AetherItems.NeptuneBoots, 10), new Choice(AetherItems.NeptuneHelmet, 10), new Choice(AetherItems.NeptuneLeggings, 10), new Choice(AetherItems.NeptuneChestplate, 10), new Choice(AetherItems.SkyrootRing, 10), new Choice(AetherItems.BoneRing, 10), new Choice(AetherItems.SoaringStone, 9), new Choice(AetherItems.DaggerfrostLocket, 9), new Choice(AetherItems.SentryBoots, 9), new Choice(AetherItems.HammerOfNotch, 8), new Choice(AetherItems.LightningSword, 8), new Choice(AetherItems.FleetingStone, 6), new Choice(AetherItems.LuckyBell, 6), new Choice(AetherItems.FrostboundStone, 6), new Choice(AetherItems.FrostpineTotem, 6), new Choice(AetherItems.PhoenixGloves, 5), new Choice(AetherItems.PhoenixHelmet, 5), new Choice(AetherItems.PhoenixBoots, 5), new Choice(AetherItems.PhoenixLeggings, 5), new Choice(AetherItems.PhoenixChestplate, 5), new Choice(AetherItems.EtherealStone, 4), new Choice(AetherItems.CandyRing, 4), new Choice(AetherItems.DeathSeal, 3), new Choice(AetherItems.ShardOfLife, 3), new Choice(AetherItems.RegenerationStone, 3), new Choice(AetherItems.VampireBlade, 2), new Choice(AetherItems.ValkyrieGloves, 2), new Choice(AetherItems.ValkyrieBoots, 2), new Choice(AetherItems.ValkyrieHelmet, 2), new Choice(AetherItems.ValkyrieLeggings, 2), new Choice(AetherItems.ValkyrieChestplate, 2), new Choice(AetherItems.ValkyrieAxe, 2), new Choice(AetherItems.ValkyrieShovel, 2), new Choice(AetherItems.ValkyriePickaxe, 2), new Choice(AetherItems.ValkyrieLance, 2), new Choice(AetherItems.MouseEarCap, 1), new Choice(AetherItems.OrbOfArkenzus, 1)),
    CHRISTMAS_GIFT(new ChoiceWithRandomAmount(AetherItems.GingerBreadMan, 15, 16, 10), new ChoiceWithRandomAmount(AetherItems.CandyCane, 15, 10, 6), new ChoiceWithRandomAmount(AetherItems.Cocoatrice, 13, 4, 1), new ChoiceWithRandomAmount(AetherItems.AechorPetal, 13, 5, 1), new ChoiceWithRandomAmount(AetherItems.Wyndberry, 13, 3, 1), new ChoiceWithRandomAmount(AetherItems.AmbrosiumShard, 13, 6, 1), new ChoiceWithRandomAmount(AetherItems.ZaniteGemstone, 13, 4, 1), new Choice(AetherItems.CandyCaneSword, 10), new Choice(AetherItems.ChainGloves, 10), new ChoiceWithRandomAmount(Items.field_151032_g, 8, 25, 10), new ChoiceWithRandomAmount(Items.field_151034_e, 8, 4, 1), new ChoiceWithRandomAmount(AetherItems.WhiteApple, 8, 3, 1), new Choice(AetherItems.ContinuumOrb, 6), new Choice(AetherItems.ContinuumBomb, 6), new Choice(Items.field_151057_cb, 4), new Choice(Items.field_151141_av, 4), new Choice(AetherItems.AerwhaleMusicDisc, 2), new Choice(AetherItems.LabyrinthMusicDisc, 2), new Choice(AetherItems.MoaMusicDisc, 2), new Choice(AetherItems.LabyrinthMusicDisc, 2), new Choice(AetherItems.SilentFlightDisc, 1));

    private final Choice[] choices;
    private final float total;

    private AetherLoot(Choice ... choices) {
        this.choices = choices;
        this.total = this.getTotalWeight(choices);
    }

    public Choice[] getChoices() {
        return this.choices;
    }

    public List<Choice> getChoiceList() {
        return Arrays.asList(this.choices);
    }

    private float getTotalWeight(Choice[] choices) {
        float weight = 0.0f;
        for (Choice c : choices) {
            weight += c.getWeight();
        }
        return weight;
    }

    private static int getRandomNumber(Random rand, int size) {
        return rand.nextInt(size);
    }

    public ItemStack getRandomItem(Random rand) {
        float randNum = rand.nextFloat() * this.total;
        for (Choice c : this.choices) {
            if (!((randNum -= c.getWeight()) < 0.0f)) continue;
            return c.getStack(rand);
        }
        return null;
    }

    public ItemStack getRandomItem(PlayerAether player, Random rand) {
        ArrayList<Choice> possibleChoices = new ArrayList<Choice>();
        for (Choice c : this.choices) {
            if (player.hasDungeonReward(new ItemStack(c.getItemID(), 1, c.getItemDamage()))) continue;
            possibleChoices.add(c);
        }
        float randNum = rand.nextFloat() * this.getTotalWeight(possibleChoices.toArray(new Choice[possibleChoices.size()]));
        for (Choice c : possibleChoices) {
            if (!((randNum -= c.getWeight()) < 0.0f)) continue;
            return c.getStack(rand);
        }
        return null;
    }

    public static class ChoiceWithRandomAmount
    extends Choice {
        private int min;
        private int max;

        public ChoiceWithRandomAmount(Item item, int damage, int weight, int max, int min) {
            super(item, damage, weight);
            this.min = min;
            this.max = max;
        }

        public ChoiceWithRandomAmount(Item item, int weight, int max, int min) {
            this(item, 0, weight, max, min);
        }

        @Override
        public int getAmount(Random rand) {
            return AetherLoot.getRandomNumber(rand, this.max - this.min) + this.min;
        }
    }

    public static class Choice {
        private Item id;
        private int weight;
        private int damage;

        public Choice(Item stack, int weight) {
            this(stack, 0, weight);
        }

        public Choice(Item stack, int damage, int weight) {
            this.id = stack;
            this.damage = damage;
            this.weight = weight;
        }

        public Choice(Block block, int weight) {
            this(block, 0, weight);
        }

        public Choice(Block block, int damage, int weight) {
            this.id = Item.func_150898_a((Block)block);
            this.weight = weight;
            this.damage = damage;
        }

        public ItemStack getStack(Random rand) {
            return new ItemStack(this.id, this.getAmount(rand), this.getDamage(rand));
        }

        public float getWeight() {
            return this.weight;
        }

        public int getAmount(Random rand) {
            return 1;
        }

        public int getDamage(Random rand) {
            return this.damage;
        }

        public Item getItemID() {
            return this.id;
        }

        public int getItemDamage() {
            return this.damage;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof Choice) {
                Choice choice = (Choice)object;
                if (choice.id == this.id && choice.damage == this.damage) {
                    return true;
                }
            }
            return false;
        }
    }
}

