/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import dan200.QCraft;
import dan200.qcraft.shared.BlockQBlock;
import dan200.qcraft.shared.BlockQuantumComputer;
import dan200.qcraft.shared.BlockQuantumLogic;
import dan200.qcraft.shared.BlockQuantumOre;
import dan200.qcraft.shared.BlockQuantumPortal;
import dan200.qcraft.shared.ConnectionHandler;
import dan200.qcraft.shared.ContainerQuantumComputer;
import dan200.qcraft.shared.CreativeTabQuantumCraft;
import dan200.qcraft.shared.EntangledQBlockRecipe;
import dan200.qcraft.shared.EntangledQuantumComputerRecipe;
import dan200.qcraft.shared.IQCraftProxy;
import dan200.qcraft.shared.ItemEOS;
import dan200.qcraft.shared.ItemMissing;
import dan200.qcraft.shared.ItemQBlock;
import dan200.qcraft.shared.ItemQuantumComputer;
import dan200.qcraft.shared.ItemQuantumDust;
import dan200.qcraft.shared.ItemQuantumGoggles;
import dan200.qcraft.shared.ItemQuantumLogic;
import dan200.qcraft.shared.LostLuggage;
import dan200.qcraft.shared.QBlockRecipe;
import dan200.qcraft.shared.QuantumOreGenerator;
import dan200.qcraft.shared.TileEntityQBlock;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.RecipeSorter;

public abstract class QCraftProxyCommon
implements IQCraftProxy {
    @Override
    public void preLoad() {
        this.registerItems();
    }

    @Override
    public void load() {
        this.registerTileEntities();
        this.registerForgeHandlers();
    }

    @Override
    public abstract boolean isClient();

    @Override
    public abstract Object getQuantumComputerGUI(InventoryPlayer var1, TileEntityQuantumComputer var2);

    @Override
    public abstract void showItemTransferGUI(EntityPlayer var1, TileEntityQuantumComputer var2);

    @Override
    public abstract void travelToServer(LostLuggage.Address var1);

    @Override
    public boolean isPlayerWearingGoggles(EntityPlayer player) {
        ItemStack headGear = player.field_71071_by.func_70440_f(3);
        return headGear != null && headGear.func_77973_b() == QCraft.Items.quantumGoggles;
    }

    @Override
    public boolean isPlayerWearingQuantumGoggles(EntityPlayer player) {
        ItemStack headGear = player.field_71071_by.func_70440_f(3);
        return headGear != null && headGear.func_77973_b() == QCraft.Items.quantumGoggles && headGear.func_77960_j() == 0;
    }

    @Override
    public abstract boolean isLocalPlayerWearingGoggles();

    @Override
    public abstract boolean isLocalPlayerWearingQuantumGoggles();

    @Override
    public abstract void renderQuantumGogglesOverlay(float var1, float var2);

    @Override
    public abstract void renderAOGogglesOverlay(float var1, float var2);

    @Override
    public abstract void spawnQuantumDustFX(World var1, double var2, double var4, double var6);

    private void registerItems() {
        QCraft.creativeTab = new CreativeTabQuantumCraft(CreativeTabs.getNextID(), "qCraft");
        QCraft.Blocks.quantumOre = new BlockQuantumOre(false);
        GameRegistry.registerBlock((Block)QCraft.Blocks.quantumOre, (String)"quantumore");
        QCraft.Blocks.quantumOreGlowing = new BlockQuantumOre(true);
        GameRegistry.registerBlock((Block)QCraft.Blocks.quantumOreGlowing, (String)"quantumoreglowing");
        QCraft.Blocks.quantumLogic = new BlockQuantumLogic();
        GameRegistry.registerBlock((Block)QCraft.Blocks.quantumLogic, ItemQuantumLogic.class, (String)"quantumlogic");
        QCraft.Blocks.qBlock = new BlockQBlock();
        GameRegistry.registerBlock((Block)QCraft.Blocks.qBlock, ItemQBlock.class, (String)"qblock");
        QCraft.Blocks.quantumComputer = new BlockQuantumComputer();
        GameRegistry.registerBlock((Block)QCraft.Blocks.quantumComputer, ItemQuantumComputer.class, (String)"quantumcomputer");
        QCraft.Blocks.quantumPortal = new BlockQuantumPortal();
        GameRegistry.registerBlock((Block)QCraft.Blocks.quantumPortal, (String)"quantumportal");
        QCraft.Items.quantumDust = new ItemQuantumDust();
        GameRegistry.registerItem((Item)QCraft.Items.quantumDust, (String)"dust");
        QCraft.Items.eos = new ItemEOS();
        GameRegistry.registerItem((Item)QCraft.Items.eos, (String)"essence");
        QCraft.Items.quantumGoggles = new ItemQuantumGoggles();
        GameRegistry.registerItem((Item)QCraft.Items.quantumGoggles, (String)"goggles");
        QCraft.Items.missingItem = new ItemMissing();
        GameRegistry.registerItem((Item)QCraft.Items.missingItem, (String)"missing");
        ItemStack observer = new ItemStack((Block)QCraft.Blocks.quantumLogic, 1, 0);
        GameRegistry.addRecipe((ItemStack)observer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150348_b, Character.valueOf('Y'), new ItemStack((Item)QCraft.Items.eos, 1, 1), Character.valueOf('Z'), Items.field_151137_ax});
        ItemStack eos = new ItemStack((Item)QCraft.Items.eos, 1, 0);
        GameRegistry.addRecipe((ItemStack)eos, (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), QCraft.Items.quantumDust});
        ItemStack eoo = new ItemStack((Item)QCraft.Items.eos, 1, 1);
        GameRegistry.addRecipe((ItemStack)eoo, (Object[])new Object[]{" X ", "X X", " X ", Character.valueOf('X'), QCraft.Items.quantumDust});
        ItemStack eoe = new ItemStack((Item)QCraft.Items.eos, 1, 2);
        GameRegistry.addRecipe((ItemStack)eoe, (Object[])new Object[]{"X X", " Y ", "X X", Character.valueOf('X'), QCraft.Items.quantumDust, Character.valueOf('Y'), eos});
        GameRegistry.addRecipe((IRecipe)new QBlockRecipe());
        RecipeSorter.register((String)"qCraft:qBlock", QBlockRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new EntangledQBlockRecipe());
        RecipeSorter.register((String)"qCraft:entangled_qBlock", EntangledQBlockRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        ItemStack regularQuantumComputer = ItemQuantumComputer.create(-1, 1);
        GameRegistry.addRecipe((ItemStack)regularQuantumComputer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), QCraft.Items.quantumDust, Character.valueOf('Z'), Blocks.field_150410_aZ});
        ItemStack entangledQuantumComputer = ItemQuantumComputer.create(0, 1);
        GameRegistry.addRecipe((IRecipe)new EntangledQuantumComputerRecipe());
        RecipeSorter.register((String)"qCraft:entangled_computer", EntangledQuantumComputerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        ItemStack quantumGoggles = new ItemStack((Item)QCraft.Items.quantumGoggles, 1, 0);
        GameRegistry.addRecipe((ItemStack)quantumGoggles, (Object[])new Object[]{"XYX", Character.valueOf('X'), Blocks.field_150410_aZ, Character.valueOf('Y'), QCraft.Items.quantumDust});
        ItemStack aoGoggles = new ItemStack((Item)QCraft.Items.quantumGoggles, 1, 1);
        GameRegistry.addRecipe((ItemStack)aoGoggles, (Object[])new Object[]{"XYX", Character.valueOf('X'), Blocks.field_150410_aZ, Character.valueOf('Y'), new ItemStack((Item)QCraft.Items.eos, 1, 1)});
        if (QCraft.enableWorldGenReplacementRecipes) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)QCraft.Items.quantumDust, 2), (Object[])new Object[]{"XY", Character.valueOf('X'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(Items.field_151100_aR, 1, 10)});
        }
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityQBlock.class, (String)"qblock");
        GameRegistry.registerTileEntity(TileEntityQuantumComputer.class, (String)"qcomputer");
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
        FMLCommonHandler.instance().bus().register((Object)handlers);
        if (QCraft.enableWorldGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new QuantumOreGenerator(), (int)1);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)QCraft.instance, (IGuiHandler)handlers);
        ConnectionHandler connectionHandler = new ConnectionHandler();
        MinecraftForge.EVENT_BUS.register((Object)connectionHandler);
        FMLCommonHandler.instance().bus().register((Object)connectionHandler);
    }

    public static NBTTagCompound loadNBTFromPath(File file) {
        block5: {
            NBTTagCompound nBTTagCompound;
            if (file == null || !file.exists()) break block5;
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)input);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)input).close();
                    throw throwable;
                }
                catch (IOException e) {
                    QCraft.log("Warning: failed to load QCraft entanglement info");
                }
            }
            ((InputStream)input).close();
            return nBTTagCompound;
        }
        return null;
    }

    public static void saveNBTToPath(File file, NBTTagCompound nbt) {
        block5: {
            try {
                if (file == null) break block5;
                file.getParentFile().mkdirs();
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)output);
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            catch (IOException e) {
                QCraft.log("Warning: failed to save QCraft entanglement info");
            }
        }
    }

    public class ForgeHandlers
    implements IGuiHandler {
        private ForgeHandlers() {
        }

        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            TileEntity tile = world.func_147438_o(x, y, z);
            switch (id) {
                case 105: {
                    if (tile == null || !(tile instanceof TileEntityQuantumComputer)) break;
                    TileEntityQuantumComputer computer = (TileEntityQuantumComputer)tile;
                    return new ContainerQuantumComputer(player.field_71071_by, computer);
                }
            }
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            TileEntity tile = world.func_147438_o(x, y, z);
            switch (id) {
                case 105: {
                    if (tile == null || !(tile instanceof TileEntityQuantumComputer)) break;
                    TileEntityQuantumComputer drive = (TileEntityQuantumComputer)tile;
                    return QCraftProxyCommon.this.getQuantumComputerGUI(player.field_71071_by, drive);
                }
            }
            return null;
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            EntityPlayer player = event.player;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                QCraft.clearUnverifiedLuggage(player);
                QCraft.requestLuggage(player);
            }
        }

        @SubscribeEvent
        public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            EntityPlayer player = event.player;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                QCraft.clearUnverifiedLuggage(player);
            }
        }
    }
}

