/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerQuantumComputer
extends Container {
    public static final int PROGRESS_ERRORMSG = 0;
    public static final int PROGRESS_IS_TELEPORTER = 1;
    public static final int PROGRESS_IS_TELEPORTER_ENERGIZED = 2;
    public static final int PROGRESS_CAN_EDIT = 3;
    public static final int PROGRESS_CAN_EDIT_IP = 4;
    private TileEntityQuantumComputer m_computer;
    private TileEntityQuantumComputer.TeleportError m_errorMessage;
    private boolean m_isTeleporter;
    private boolean m_isTeleporterEnergized;
    private boolean m_canEdit;
    private boolean m_canEditIPAddress;

    public ContainerQuantumComputer(InventoryPlayer inventory, TileEntityQuantumComputer computer) {
        this.m_computer = computer;
        this.m_errorMessage = TileEntityQuantumComputer.TeleportError.Ok;
        this.m_isTeleporter = false;
        this.m_isTeleporterEnergized = false;
        this.m_canEdit = false;
        this.m_canEditIPAddress = false;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.m_computer.func_145835_a(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v) <= 64.0;
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_71112_a((Container)this, 0, this.m_errorMessage.ordinal());
        boolean canEdit = false;
        boolean canEditIPAddress = false;
        if (icrafting instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)icrafting;
            canEdit = QCraft.canPlayerCreatePortals(player);
            canEditIPAddress = QCraft.canPlayerEditPortalServers(player);
        }
        icrafting.func_71112_a((Container)this, 1, this.m_isTeleporter ? 1 : 0);
        icrafting.func_71112_a((Container)this, 2, this.m_isTeleporterEnergized ? 1 : 0);
        icrafting.func_71112_a((Container)this, 3, canEdit ? 1 : 0);
        icrafting.func_71112_a((Container)this, 4, canEditIPAddress ? 1 : 0);
    }

    public void func_75142_b() {
        super.func_75142_b();
        TileEntityQuantumComputer.TeleportError error = this.m_computer.canEnergize();
        boolean isTeleporter = this.m_computer.isTeleporter();
        boolean isTeleporterEnergized = this.m_computer.isTeleporterEnergized();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (error != this.m_errorMessage) {
                icrafting.func_71112_a((Container)this, 0, error.ordinal());
            }
            if (isTeleporter != this.m_isTeleporter) {
                icrafting.func_71112_a((Container)this, 1, isTeleporter ? 1 : 0);
            }
            if (isTeleporterEnergized == this.m_isTeleporterEnergized) continue;
            icrafting.func_71112_a((Container)this, 2, isTeleporterEnergized ? 1 : 0);
        }
        this.m_errorMessage = error;
        this.m_isTeleporter = isTeleporter;
        this.m_isTeleporterEnergized = isTeleporterEnergized;
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.m_errorMessage = TileEntityQuantumComputer.TeleportError.values()[j];
                break;
            }
            case 1: {
                this.m_isTeleporter = j > 0;
                break;
            }
            case 2: {
                this.m_isTeleporterEnergized = j > 0;
                break;
            }
            case 3: {
                this.m_canEdit = j > 0;
                break;
            }
            case 4: {
                this.m_canEditIPAddress = j > 0;
            }
        }
    }

    public String getErrorMessage() {
        return TileEntityQuantumComputer.TeleportError.decode(this.m_errorMessage);
    }

    public boolean isTeleporterPresent() {
        return this.m_isTeleporter;
    }

    public boolean isTeleporterEnergized() {
        return this.m_isTeleporterEnergized;
    }

    public boolean canEdit() {
        return this.m_canEdit && !this.m_isTeleporterEnergized;
    }

    public boolean canEditServerAddress() {
        return this.m_canEditIPAddress && !this.m_isTeleporterEnergized;
    }

    public boolean canEnergize() {
        return this.m_canEdit || !this.m_isTeleporter;
    }
}

