/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.integration.buildcraft;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicTile;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.tile.TileMachine;

public class SchematicBlockBase
extends SchematicTile {
    private static final int[] ROTATIONS = new int[]{5, 4, 2, 3};

    public void rotateLeft(IBuilderContext context) {
        if (this.block instanceof BlockBase) {
            BlockBase block = (BlockBase)this.block;
            block0 : switch (block.getRotation()) {
                case SIX: {
                    switch (block.getFrontSide(this.meta)) {
                        case 0: 
                        case 1: {
                            super.rotateLeft(context);
                            break block0;
                        }
                    }
                    this.meta = ROTATIONS[(this.meta & 7) - 2 & 3] | this.meta & 0xFFFFFFF8;
                    break;
                }
                case FOUR: {
                    this.meta = ROTATIONS[this.meta & 3] - 2 & 3 | this.meta & 0xFFFFFFFC;
                    break;
                }
                case NONE: {
                    super.rotateLeft(context);
                }
            }
        }
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        TileEntity tile;
        super.initializeFromObjectAt(context, x, y, z);
        if (this.block.hasTileEntity(this.meta) && (tile = context.world().func_147438_o(x, y, z)) != null && tile instanceof TileMachine) {
            ((TileMachine)tile).removeFromNBTForTransfer(this.tileNBT);
            this.tileNBT = (NBTTagCompound)this.tileNBT.func_74737_b();
        }
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        ArrayList req;
        if (this.block != null && (req = this.block.getDrops(context.world(), x, y, z, context.world().func_72805_g(x, y, z), 0)) != null) {
            this.storedRequirements = new ItemStack[req.size()];
            req.toArray(this.storedRequirements);
        }
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        if (this.block instanceof BlockBase) {
            switch (((BlockBase)this.block).getRotation()) {
                case FOUR: {
                    return this.block == context.world().func_147439_a(x, y, z) && (this.meta & 0xFFFFFFFC) == (context.world().func_72805_g(x, y, z) & 0xFFFFFFFC);
                }
                case SIX: {
                    return this.block == context.world().func_147439_a(x, y, z) && (this.meta & 0xFFFFFFF8) == (context.world().func_72805_g(x, y, z) & 0xFFFFFFF8);
                }
            }
        }
        return this.block == context.world().func_147439_a(x, y, z);
    }
}

