/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util.events;

import com.gildedgames.util.ui.common.Gui;
import com.gildedgames.util.ui.data.rect.BuildIntoRectHolder;
import com.gildedgames.util.ui.data.rect.ModDim2D;
import com.gildedgames.util.ui.data.rect.RectModifier;
import com.gildedgames.util.ui.event.GuiEvent;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.MouseInputPool;
import com.gildedgames.util.ui.util.GuiCanvas;
import com.gildedgames.util.ui.util.InputHelper;
import com.gildedgames.util.ui.util.events.slots.SlotBehavior;
import com.gildedgames.util.ui.util.events.slots.SlotStack;
import com.gildedgames.util.ui.util.events.slots.SlotStackFactory;
import java.util.List;

public class DragBehavior<T>
extends GuiEvent<SlotStack<T>> {
    private List<RectModifier> prevModifiers;
    private int ticksSinceCreation;

    @Override
    public void initEvent() {
        Object gui = this.getGui();
        ModDim2D dim = gui.dim();
        dim.clear(RectModifier.ModifierType.POS);
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        super.draw(graphics, input);
        Object gui = this.getGui();
        ModDim2D dim = gui.dim();
        BuildIntoRectHolder mod = dim.mod();
        mod.center(true).pos(input.getMouseX(), input.getMouseY()).flush();
    }

    @Override
    public void onMouseInput(MouseInputPool pool, InputProvider input) {
        GuiCanvas canvas;
        boolean hoveringSlot = InputHelper.isHovered(new InputHelper.InputCondition(){

            @Override
            public boolean isMet(Gui gui) {
                return gui != null && gui.isVisible() && gui.isEnabled() && (gui.events().contains(SlotBehavior.class) || gui.events().contains(SlotStackFactory.class));
            }
        }, input);
        if (pool.has(ButtonState.PRESS) && !hoveringSlot && (canvas = GuiCanvas.fetch("dragCanvas", 550.0f)) != null) {
            canvas.remove("draggedObject");
        }
        super.onMouseInput(pool, input);
    }

    @Override
    public boolean query(Object ... input) {
        for (Object obj : input) {
            if (obj != DragBehavior.class) continue;
            return true;
        }
        return false;
    }
}

