/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util;

import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.TickInfo;
import com.gildedgames.util.ui.data.rect.Dim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectHolder;
import com.gildedgames.util.ui.data.rect.RectModifier;
import com.gildedgames.util.ui.event.view.MouseEventGui;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.MouseButton;
import com.gildedgames.util.ui.input.MouseInputPool;
import com.gildedgames.util.ui.util.TextureElement;
import com.gildedgames.util.ui.util.decorators.RepeatableGui;
import com.gildedgames.util.ui.util.rect.RectCollection;
import com.gildedgames.util.ui.util.rect.RectGetter;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Mouse;

public class ScrollBar
extends GuiFrame {
    protected GuiFrame topButton;
    protected GuiFrame bottomButton;
    protected TextureElement baseBarTexture;
    protected TextureElement grabbableBarTexture;
    protected RepeatableGui baseBar;
    protected RepeatableGui grabbableBar;
    protected RectCollection scrollingAreas;
    private boolean grabbedBar;
    protected float scrollPercentage = 0.0f;
    protected float scrollSpeed = 0.02f;
    protected double grabbedMouseYOffset;
    protected RectHolder contentArea;

    public ScrollBar(Rect barDim, GuiFrame topButton, GuiFrame bottomButton, TextureElement baseTexture, TextureElement barTexture) {
        super(barDim);
        this.topButton = topButton;
        this.bottomButton = bottomButton;
        this.baseBarTexture = baseTexture;
        this.grabbableBarTexture = barTexture;
        float maxWidth = Math.max(Math.max(this.topButton.dim().clone().clear(new RectModifier.ModifierType[0]).width(), this.bottomButton.dim().clone().clear(new RectModifier.ModifierType[0]).width()), this.baseBarTexture.dim().width());
        this.dim().mod().width(maxWidth).flush();
    }

    public void setScrollSpeed(float scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public float getScrollSpeed() {
        return this.scrollSpeed;
    }

    @Override
    public void initContent(InputProvider input) {
        this.topButton.dim().mod().center(false).resetPos().flush();
        this.bottomButton.dim().mod().center(false).resetPos().flush();
        this.baseBarTexture.dim().mod().center(false).flush();
        this.grabbableBarTexture.dim().mod().center(false).flush();
        this.topButton.events().set("topButtonScrollEvent", new ButtonScrollEvent(this.topButton, this, -0.01f));
        this.bottomButton.events().set("bottomButtonScrollEvent", new ButtonScrollEvent(this.bottomButton, this, 0.01f));
        this.baseBar = new RepeatableGui(Dim2D.build().area(this.baseBarTexture.dim().width(), this.dim().height() - this.topButton.dim().height() - this.bottomButton.dim().height()).flush(), this.baseBarTexture);
        this.grabbableBar = new RepeatableGui(Dim2D.build().area(this.grabbableBarTexture.dim().width(), 20.0f).flush(), this.grabbableBarTexture);
        RectGetter<Object> totalHeightMinusBottomButton = new RectGetter<Object>(){
            private float topButtonHeight = -1.0f;
            private float baseBarHeight = -1.0f;

            @Override
            public Rect assembleRect() {
                this.topButtonHeight = ScrollBar.this.topButton.dim().height();
                this.baseBarHeight = ScrollBar.this.baseBar.dim().height();
                return Dim2D.build().y(this.topButtonHeight + this.baseBarHeight).flush();
            }

            @Override
            public boolean shouldReassemble() {
                return ScrollBar.this.topButton.dim().height() != this.topButtonHeight || ScrollBar.this.baseBar.dim().height() != this.baseBarHeight;
            }
        };
        RectGetter topButtonHeight = new RectGetter(){
            private float topButtonHeight = -1.0f;

            @Override
            public Rect assembleRect() {
                this.topButtonHeight = ScrollBar.this.topButton.dim().height();
                return Dim2D.build().y(this.topButtonHeight).flush();
            }

            @Override
            public boolean shouldReassemble() {
                return ScrollBar.this.topButton.dim().height() != this.topButtonHeight;
            }
        };
        this.bottomButton.dim().add(totalHeightMinusBottomButton, RectModifier.ModifierType.POS, new RectModifier.ModifierType[0]);
        this.baseBar.dim().add(topButtonHeight, RectModifier.ModifierType.POS, new RectModifier.ModifierType[0]);
        this.grabbableBar.dim().add(topButtonHeight, RectModifier.ModifierType.POS, new RectModifier.ModifierType[0]);
        this.content().set("baseBar", this.baseBar);
        this.content().set("grabbableBar", this.grabbableBar);
        this.content().set("topButton", this.topButton);
        this.content().set("bottomButton", this.bottomButton);
        super.initContent(input);
    }

    @Override
    public void onMouseScroll(int scrollDifference, InputProvider input) {
        super.onMouseScroll(scrollDifference, input);
        if (input.isHovered(this.grabbableBar.dim()) || input.isHovered(this.scrollingAreas)) {
            int scrollFactor = -scrollDifference / 120;
            this.increaseScrollPercentage((float)scrollFactor * this.scrollSpeed);
        }
    }

    @Override
    public void onMouseInput(MouseInputPool pool, InputProvider input) {
        super.onMouseInput(pool, input);
        if (this.grabbedBar && !pool.has(ButtonState.PRESS)) {
            this.grabbedBar = false;
        }
        if (pool.has(MouseButton.LEFT)) {
            if (pool.has(ButtonState.PRESS) && input.isHovered(this.baseBar.dim())) {
                this.grabbedBar = true;
                this.grabbedMouseYOffset = input.isHovered(this.grabbableBar.dim()) ? (double)(this.grabbableBar.dim().y() - input.getMouseY()) : (double)(-(this.grabbableBar.dim().height() / 2.0f) + 1.0f);
            } else if (pool.has(ButtonState.RELEASE)) {
                this.grabbedBar = false;
            }
        }
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        if (this.scrollingAreas != null && this.contentArea != null) {
            float baseBarPercentage;
            double contentAndScrollHeightDif = Math.abs(this.contentArea.dim().height() - this.scrollingAreas.dim().height());
            float f = baseBarPercentage = this.contentArea.dim().height() < this.dim().height() ? 0.0f : (float)contentAndScrollHeightDif / this.contentArea.dim().height();
            if (this.baseBar == null) {
                boolean bl = false;
            }
            float barHeight = this.baseBar.dim().height() - (float)((int)(this.baseBar.dim().height() * baseBarPercentage));
            this.grabbableBar.dim().mod().height(Math.max(10.0f, barHeight)).flush();
        }
        if (this.grabbedBar) {
            double basePosY = (double)(input.getMouseY() - this.baseBar.dim().y()) + this.grabbedMouseYOffset;
            float percent = this.contentArea.dim().height() < this.dim().height() ? 0.0f : (float)basePosY / (this.baseBar.dim().height() - this.grabbableBar.dim().height());
            this.setScrollPercentage(percent);
        }
        int posOnBar = (int)((this.baseBar.dim().height() - this.grabbableBar.dim().height()) * this.getScrollPercentage());
        this.grabbableBar.dim().mod().y(posOnBar).flush();
        super.draw(graphics, input);
    }

    private void setScrollPercentage(float percentage) {
        this.scrollPercentage = this.contentArea.dim().height() < this.dim().height() ? 0.0f : Math.max(0.0f, Math.min(percentage, 1.0f));
    }

    private void increaseScrollPercentage(float percentage) {
        this.setScrollPercentage(this.getScrollPercentage() + percentage);
    }

    public float getScrollPercentage() {
        return this.scrollPercentage;
    }

    public void setScrollingAreas(RectCollection scrollingAreas) {
        this.scrollingAreas = scrollingAreas;
    }

    public void setContentArea(RectHolder contentArea) {
        this.contentArea = contentArea;
    }

    public RectHolder getContentArea() {
        return this.contentArea;
    }

    @Override
    public void write(NBTTagCompound output) {
        output.func_74776_a("scrollPercentage", this.scrollPercentage);
    }

    @Override
    public void read(NBTTagCompound input) {
        this.scrollPercentage = input.func_74760_g("scrollPercentage");
    }

    public static class ButtonScrollEvent
    extends MouseEventGui {
        private RectHolder button;
        private ScrollBar scrollBar;
        private float scrollPercentage;

        public ButtonScrollEvent(RectHolder button, ScrollBar scrollBar, float scrollPercentage) {
            this.button = button;
            this.scrollBar = scrollBar;
            this.scrollPercentage = scrollPercentage;
        }

        @Override
        public void tick(TickInfo tickInfo, InputProvider input) {
            if (Mouse.isButtonDown((int)MouseButton.LEFT.getIndex()) && input.isHovered(this.button)) {
                this.scrollBar.increaseScrollPercentage(this.scrollPercentage);
            }
            super.tick(tickInfo, input);
        }

        @Override
        protected void onTrue(InputProvider input, MouseInputPool pool) {
        }

        @Override
        protected void onFalse(InputProvider input, MouseInputPool pool) {
        }

        @Override
        public void initEvent() {
        }
    }
}

