/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.threadedlighting.world;

import com.gildedgames.util.threadedlighting.ThreadedLighting;
import com.gildedgames.util.threadedlighting.world.DummyProfiler;
import com.gildedgames.util.threadedlighting.world.ThreadedChunk;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.WorldSettings;

public class ThreadedWorld
extends WorldClient
implements Runnable {
    private Thread thread;
    private boolean delayedStart = false;
    public ArrayList queue = new ArrayList();
    public ReentrantLock queueLock = new ReentrantLock();

    public ThreadedWorld(NetHandlerPlayClient par1NetClientHandler, WorldSettings par2WorldSettings, int par3, EnumDifficulty par4, Profiler par5Profiler) {
        super(par1NetClientHandler, par2WorldSettings, par3, par4, (Profiler)new DummyProfiler(par5Profiler));
        this.thread = new Thread(this);
        if (this.delayedStart) {
            this.thread.start();
        }
        ((DummyProfiler)this.field_72984_F).threadToIgnore = this.thread.getId();
    }

    public void func_72954_a(IWorldAccess par1IWorldAccess) {
        if (this.field_73021_x.isEmpty()) {
            if (this.thread != null) {
                this.thread.start();
            } else {
                this.delayedStart = true;
            }
        }
        super.func_72954_a(par1IWorldAccess);
    }

    public void func_72848_b(IWorldAccess par1IWorldAccess) {
        super.func_72848_b(par1IWorldAccess);
        if (this.field_73021_x.isEmpty()) {
            this.thread.stop();
        }
    }

    public boolean func_147463_c(EnumSkyBlock type, int x, int y, int z) {
        if (type == EnumSkyBlock.Block) {
            return super.func_147463_c(type, x, y, z);
        }
        if (!this.func_72873_a(x, y, z, 17)) {
            return false;
        }
        this.queueLock.lock();
        this.queue.add(new UpdateSkylight(x, y, z));
        this.queueLock.unlock();
        return true;
    }

    @Override
    public void run() {
        while (true) {
            long start = System.currentTimeMillis();
            this.queueLock.lock();
            if (this.queue.size() > 0) {
                Object[] tempQueue = new Object[this.queue.size()];
                this.queue.toArray(tempQueue);
                this.queue.clear();
                this.queueLock.unlock();
                for (Object object : tempQueue) {
                    Object data;
                    if (object instanceof UpdateSkylight) {
                        data = (UpdateSkylight)object;
                        super.func_147463_c(EnumSkyBlock.Sky, ((UpdateSkylight)data).x, ((UpdateSkylight)data).y, ((UpdateSkylight)data).z);
                        continue;
                    }
                    if (!(object instanceof RelightBlock)) continue;
                    data = (RelightBlock)object;
                    ((RelightBlock)data).chunk.superRelightBlock(((RelightBlock)data).x, ((RelightBlock)data).y, ((RelightBlock)data).z);
                }
            } else {
                this.queueLock.unlock();
            }
            long time = System.currentTimeMillis() - start;
            if (time > 100L) {
                ThreadedLighting.print("prevented lag lasting " + time + " milliseconds.");
            }
            if (time >= 10L) continue;
            try {
                Thread.currentThread();
                Thread.sleep(10L - time);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public class RelightBlock {
        ThreadedChunk chunk;
        int x;
        int y;
        int z;

        RelightBlock(ThreadedChunk chunk, int x, int y, int z) {
            this.chunk = chunk;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    private class UpdateSkylight {
        int x;
        int y;
        int z;

        UpdateSkylight(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

