/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.tab.common.networking.packet;

import com.gildedgames.util.core.CustomPacket;
import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.tab.common.TabAPI;
import com.gildedgames.util.tab.common.util.ITab;
import com.gildedgames.util.tab.common.util.ITabGroup;
import com.gildedgames.util.tab.common.util.ITabGroupHandler;
import com.gildedgames.util.tab.common.util.TabGroupHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;

public class PacketOpenTab
extends CustomPacket<PacketOpenTab> {
    private int tabGroupIndex;
    private int tabIndex;
    private int containerID;
    private boolean openContainer = false;

    public PacketOpenTab() {
    }

    public PacketOpenTab(ITab tab) {
        for (Map.Entry<Integer, ITabGroupHandler> pairs : TabAPI.INSTANCE.getRegisteredTabGroups().entrySet()) {
            int groupIndex = pairs.getKey();
            TabGroupHandler tabGroup = (TabGroupHandler)pairs.getValue();
            int index = 0;
            for (ITab groupTab : tabGroup.getSide(Side.CLIENT).getTabs()) {
                if (tab == groupTab) {
                    this.tabGroupIndex = groupIndex;
                    this.tabIndex = index;
                    return;
                }
                ++index;
            }
        }
    }

    public PacketOpenTab(int tabGroupIndex, int tabIndex, int containerID) {
        this.tabGroupIndex = tabGroupIndex;
        this.tabIndex = tabIndex;
        this.containerID = containerID;
        this.openContainer = true;
    }

    public void fromBytes(ByteBuf buf) {
        this.tabGroupIndex = buf.readInt();
        this.tabIndex = buf.readInt();
        this.containerID = buf.readInt();
        this.openContainer = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tabGroupIndex);
        buf.writeInt(this.tabIndex);
        buf.writeInt(this.containerID);
        buf.writeBoolean(this.openContainer);
    }

    @Override
    public void handleClientSide(PacketOpenTab message, EntityPlayer player) {
        if (message.openContainer) {
            Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c = message.containerID;
        }
    }

    @Override
    public void handleServerSide(PacketOpenTab message, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
            if (this.tabGroupIndex < TabAPI.INSTANCE.getRegisteredTabGroups().size()) {
                ITabGroupHandler tabGroupHandler = TabAPI.INSTANCE.getRegisteredTabGroups().get(this.tabGroupIndex);
                if (tabGroupHandler == null) {
                    return;
                }
                ITabGroup tabGroup = tabGroupHandler.getSide(Side.SERVER);
                if (this.tabIndex < tabGroup.getTabs().size()) {
                    ITab tab = tabGroup.getTabs().get(this.tabIndex);
                    Container container = tab.getCurrentContainer((EntityPlayer)entityPlayer, entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v);
                    if (container != null) {
                        entityPlayer.func_71117_bO();
                        entityPlayer.func_71128_l();
                        int windowID = entityPlayer.field_71139_cq;
                        entityPlayer.field_71070_bA = container;
                        entityPlayer.field_71070_bA.field_75152_c = windowID;
                        UtilCore.NETWORK.sendTo(new PacketOpenTab(this.tabGroupIndex, this.tabIndex, windowID), entityPlayer);
                    }
                    tab.onOpen(player);
                }
            }
        }
    }
}

