/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player.common.player;

import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.player.common.player.IPlayerProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerProfile
implements IPlayerProfile {
    protected EntityPlayer player;
    protected UUID uuid;
    protected String username;
    protected boolean isLoggedIn;
    protected boolean isDirty;

    @Override
    public void entityInit(EntityPlayer player) {
        this.setEntity(player);
        this.setUUID(player.func_110124_au());
        this.username = player.func_70005_c_();
    }

    @Override
    public void onUpdate() {
        if (this.player != null) {
            if (this.getUUID() == null) {
                this.setUUID(this.player.func_110124_au());
            }
            if (this.username == null) {
                this.username = this.player.func_70005_c_();
            }
        }
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public void setLoggedIn(boolean isLoggedIn) {
        this.isLoggedIn = isLoggedIn;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
        this.markDirty();
    }

    @Override
    public EntityPlayer getEntity() {
        return this.player;
    }

    @Override
    public void setEntity(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74772_a("UUIDMost", this.uuid.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", this.uuid.getLeastSignificantBits());
    }

    @Override
    public void read(NBTTagCompound tag) {
        if (tag.func_150297_b("UUIDMost", 4) && tag.func_150297_b("UUIDLeast", 4)) {
            this.uuid = new UUID(tag.func_74763_f("UUIDMost"), tag.func_74763_f("UUIDLeast"));
        } else if (tag.func_150297_b("UUID", 8)) {
            this.uuid = UUID.fromString(tag.func_74779_i("UUID"));
        }
    }

    @Override
    public void syncTo(ByteBuf buf, IOSyncable.SyncSide to) {
        if (to.isClient()) {
            buf.writeLong(this.uuid.getMostSignificantBits());
            buf.writeLong(this.uuid.getLeastSignificantBits());
            buf.writeBoolean(this.isLoggedIn);
        }
    }

    @Override
    public void syncFrom(ByteBuf buf, IOSyncable.SyncSide from) {
        if (from.isServer()) {
            this.uuid = new UUID(buf.readLong(), buf.readLong());
            this.isLoggedIn = buf.readBoolean();
        }
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void markClean() {
        this.isDirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        return obj instanceof PlayerProfile && this.getUUID().equals(((PlayerProfile)obj).getUUID());
    }
}

