/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.menu.client;

import com.gildedgames.util.core.ClientProxy;
import com.gildedgames.util.core.nbt.NBT;
import com.gildedgames.util.core.nbt.NBTFactory;
import com.gildedgames.util.core.nbt.NBTFile;
import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.menu.MenuCore;
import com.gildedgames.util.menu.client.IMenu;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.lwjgl.input.Mouse;

public class MenuClientEvents {
    @SideOnly(value=Side.CLIENT)
    private GuiButton leftButton = new GuiButton(0, 5, 5, 20, 20, "<");
    @SideOnly(value=Side.CLIENT)
    private GuiButton rightButton = new GuiButton(0, 30, 5, 20, 20, ">");
    @SideOnly(value=Side.CLIENT)
    private Minecraft mc = Minecraft.func_71410_x();
    private File configSaveLocation;
    private boolean firstTick = true;

    public MenuClientEvents() {
        this.configSaveLocation = new File(Minecraft.func_71410_x().field_71412_D, "mod-config\\menu.dat");
    }

    private void openMenu(IMenu menu) {
        this.openMenu(menu, true);
    }

    private void openMenu(IMenu menu, boolean shouldSaveToConfig) {
        if (menu == null) {
            menu = ClientProxy.MINECRAFT_MENU;
        }
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        MenuCore.locate().setCurrentMenu(menu);
        this.mc.func_147108_a(menu.getNewInstance());
        menu.onOpen();
        if (!this.firstTick) {
            Mouse.setCursorPosition((int)mouseX, (int)mouseY);
        }
        if (!shouldSaveToConfig) {
            return;
        }
        try {
            MenuConfig config = new MenuConfig();
            config.menuID = menu.getID();
            IOCore.io().writeFile(this.configSaveLocation, new NBTFile(this.configSaveLocation, config, MenuConfig.class), new NBTFactory());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen gui = event.gui;
        if (gui == null) {
            return;
        }
        IMenu menu = MenuCore.locate().getCurrentMenu();
        IMenu hooked = MenuCore.locate().fromGui(gui);
        if ((gui instanceof GuiMainMenu || hooked != null) && menu == null || gui.getClass() == GuiMainMenu.class && menu.getMenuClass() != GuiMainMenu.class) {
            event.setCanceled(true);
            if (this.configSaveLocation.exists()) {
                try {
                    MenuConfig config = new MenuConfig();
                    IOCore.io().readFile(this.configSaveLocation, new NBTFile(this.configSaveLocation, config, MenuConfig.class), new NBTFactory());
                    this.openMenu(MenuCore.locate().getMenuFromID(config.menuID), false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                List<IMenu> menus = MenuCore.locate().getRegisteredMenus();
                if (menus.size() == 1) {
                    this.openMenu(ClientProxy.MINECRAFT_MENU);
                } else {
                    this.openMenu(menus.get(1));
                }
            }
        } else if (gui != null && menu != null && !gui.getClass().isAssignableFrom(menu.getMenuClass())) {
            MenuCore.locate().setCurrentMenu(null);
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IMenu menu;
            if (this.firstTick) {
                this.firstTick = false;
            }
            if ((menu = MenuCore.locate().getCurrentMenu()) != null && this.mc.field_71462_r != null && this.mc.field_71462_r.getClass() == menu.getMenuClass()) {
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                int scaledWidth = scaledresolution.func_78326_a();
                int scaledHeight = scaledresolution.func_78328_b();
                int mouseX = Mouse.getX() * scaledWidth / this.mc.field_71443_c;
                int mouseY = scaledHeight - Mouse.getY() * scaledHeight / this.mc.field_71440_d - 1;
                while (Mouse.next()) {
                    boolean rightButtonMoused;
                    boolean customButtons = menu.useCustomButtons();
                    boolean leftButtonMoused = customButtons ? menu.getLeftButton().isMousedOver(mouseX, mouseY) : this.leftButton.func_146115_a();
                    boolean bl = rightButtonMoused = customButtons ? menu.getRightButton().isMousedOver(mouseX, mouseY) : this.rightButton.func_146115_a();
                    if (Mouse.getEventButtonState() && MenuCore.locate().getRegisteredMenus().size() > 1 && (leftButtonMoused || rightButtonMoused)) {
                        this.leftButton.func_146113_a(this.mc.func_147118_V());
                        if (leftButtonMoused) {
                            this.openMenu(MenuCore.locate().getPreviousMenu());
                            continue;
                        }
                        if (!rightButtonMoused) continue;
                        this.openMenu(MenuCore.locate().getNextMenu());
                        continue;
                    }
                    if (Minecraft.func_71410_x().field_71462_r == null) continue;
                    this.mc.field_71462_r.func_146274_d();
                }
            }
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        IMenu menu;
        if (event.phase == TickEvent.Phase.END && (menu = MenuCore.locate().getCurrentMenu()) != null && this.mc.field_71462_r != null && this.mc.field_71462_r.getClass() == menu.getMenuClass()) {
            boolean disabled;
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            int scaledWidth = scaledresolution.func_78326_a();
            int scaledHeight = scaledresolution.func_78328_b();
            int mouseX = Mouse.getX() * scaledWidth / this.mc.field_71443_c;
            int mouseY = scaledHeight - Mouse.getY() * scaledHeight / this.mc.field_71440_d - 1;
            boolean bl = disabled = MenuCore.locate().getRegisteredMenus().size() <= 1;
            if (!disabled) {
                if (menu.useCustomButtons()) {
                    menu.getLeftButton().render(mouseX, mouseY, "<");
                    menu.getRightButton().render(mouseX, mouseY, ">");
                } else {
                    this.leftButton.func_146112_a(this.mc, mouseX, mouseY);
                    this.rightButton.func_146112_a(this.mc, mouseX, mouseY);
                }
            }
        }
    }

    public static class MenuConfig
    implements NBT {
        private String menuID;

        private MenuConfig() {
        }

        @Override
        public void write(NBTTagCompound output) {
            output.func_74778_a("menuID", this.menuID);
        }

        @Override
        public void read(NBTTagCompound input) {
            this.menuID = input.func_74779_i("menuID");
        }
    }
}

