/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.io_manager.util;

import java.io.IOException;
import java.io.InputStream;

public class BinaryInputStream {
    private static final int END_OF_FILE = -1;
    private static final int BITS_IN_BYTE = 8;
    private final InputStream input;
    private byte buffer;
    private int index;

    public BinaryInputStream(InputStream input) {
        this.input = input;
        this.fillBuffer();
    }

    private void fillBuffer() {
        try {
            this.buffer = (byte)this.input.read();
            this.index = 8;
        }
        catch (IOException e) {
            this.buffer = (byte)-1;
            this.index = -1;
        }
    }

    public boolean isEmpty() {
        return this.buffer == -1;
    }

    public boolean readBit() {
        boolean bit;
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        --this.index;
        boolean bl = bit = (this.buffer >> this.index & 1) == 1;
        if (this.index == 0) {
            this.fillBuffer();
        }
        return bit;
    }
}

