/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.io;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.core.io.MessageSyncToClient;
import com.gildedgames.util.core.io.MessageSyncToServer;
import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.io_manager.io.IOSyncableDispatcher;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public class MCSyncableDispatcher
implements IOSyncableDispatcher<ByteBuf, ByteBuf> {
    private BiMap<String, IOSyncable<ByteBuf, ByteBuf>> serverSyncables = HashBiMap.create();
    private BiMap<String, IOSyncable<ByteBuf, ByteBuf>> clientSyncables = HashBiMap.create();
    private String id;

    public MCSyncableDispatcher(String id) {
        this.id = id;
    }

    private BiMap<String, IOSyncable<ByteBuf, ByteBuf>> getSyncables(IOSyncable.SyncSide side) {
        return side.isServer() ? this.serverSyncables : this.clientSyncables;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void dispatchDirtySyncables(IOSyncable.SyncSide from) {
        for (Map.Entry pair : this.getSyncables(from).entrySet()) {
            IOSyncable syncable = (IOSyncable)pair.getValue();
            if (syncable == null || !syncable.isDirty()) continue;
            if (from.isClient()) {
                UtilCore.NETWORK.sendToServer(new MessageSyncToServer(this, syncable));
                continue;
            }
            UtilCore.NETWORK.sendToServer(new MessageSyncToClient(this, syncable));
        }
    }

    @Override
    public void track(String key, IOSyncable<ByteBuf, ByteBuf> syncable, IOSyncable.SyncSide ... sides) {
        for (IOSyncable.SyncSide side : sides) {
            this.getSyncables(side).put((Object)key, syncable);
        }
    }

    @Override
    public void untrack(String key, IOSyncable.SyncSide side) {
        this.getSyncables(side).remove((Object)key);
    }

    @Override
    public void untrack(IOSyncable<ByteBuf, ByteBuf> syncable, IOSyncable.SyncSide side) {
        this.getSyncables(side).inverse().remove(syncable);
    }

    @Override
    public IOSyncable<ByteBuf, ByteBuf> getSyncable(String key, IOSyncable.SyncSide side) {
        return (IOSyncable)this.getSyncables(side).get((Object)key);
    }

    @Override
    public String getKey(IOSyncable<ByteBuf, ByteBuf> syncable, IOSyncable.SyncSide side) {
        return (String)this.getSyncables(side).inverse().get(syncable);
    }

    @Override
    public void write(ByteBuf output) {
    }

    @Override
    public void read(ByteBuf input) {
    }
}

