/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.gui.util;

import com.gildedgames.util.core.gui.util.MinecraftAssetLocation;
import com.gildedgames.util.core.gui.util.decorators.MinecraftButtonSounds;
import com.gildedgames.util.core.gui.util.wrappers.MinecraftButton;
import com.gildedgames.util.ui.common.Gui;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.AssetLocation;
import com.gildedgames.util.ui.data.DrawingData;
import com.gildedgames.util.ui.data.Pos2D;
import com.gildedgames.util.ui.data.rect.Dim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.graphics.ResizableUVBehavior;
import com.gildedgames.util.ui.graphics.Sprite;
import com.gildedgames.util.ui.util.Button;
import com.gildedgames.util.ui.util.Font;
import com.gildedgames.util.ui.util.RectangleElement;
import com.gildedgames.util.ui.util.ScrollBar;
import com.gildedgames.util.ui.util.Text;
import com.gildedgames.util.ui.util.TextBox;
import com.gildedgames.util.ui.util.TextureElement;
import com.gildedgames.util.ui.util.decorators.ScrollableGui;
import com.gildedgames.util.ui.util.rect.RectCollection;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;

public class GuiFactory {
    private static final MinecraftAssetLocation SCROLL_BAR = new MinecraftAssetLocation("gilded-games-util", "textures/gui/test/scrollBar.png");
    private static final MinecraftAssetLocation PANEL = new MinecraftAssetLocation("gilded-games-util", "textures/gui/test/resizablePane.png");
    private static final MinecraftAssetLocation PANEL_EMBEDDED = new MinecraftAssetLocation("gilded-games-util", "textures/gui/test/resizablePaneEmbedded.png");

    private GuiFactory() {
    }

    public static GuiFrame rect(Rect rect, DrawingData color) {
        return new RectangleElement(rect, color);
    }

    public static GuiFrame rect(Rect rect, DrawingData startColor, DrawingData endColor) {
        return new RectangleElement(rect, startColor, endColor);
    }

    public static GuiFrame pressSound(Gui button) {
        return new MinecraftButtonSounds(button);
    }

    public static GuiFrame upArrowButton() {
        return GuiFactory.downArrowButton(Dim2D.flush());
    }

    public static GuiFrame upArrowButton(Rect dim) {
        Sprite buttonDefaultSprite = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().minU(20.0f).area(10.0f, 10.0f).flush());
        Sprite buttonHoveredSprite = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().minU(30.0f).area(10.0f, 10.0f).flush());
        Sprite buttonClickedSprite = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().minU(40.0f).area(10.0f, 10.0f).flush());
        Rect newDim = Dim2D.build().pos(dim.x(), dim.y()).area(10.0f, 10.0f).center(dim.isCenteredX(), dim.isCenteredY()).flush();
        Button button = new Button(newDim, new TextureElement(buttonDefaultSprite, newDim), new TextureElement(buttonHoveredSprite, newDim), new TextureElement(buttonClickedSprite, newDim));
        return GuiFactory.pressSound(button);
    }

    public static GuiFrame downArrowButton() {
        return GuiFactory.downArrowButton(Dim2D.flush());
    }

    public static GuiFrame downArrowButton(Rect dim) {
        Sprite buttonDefaultSprite = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().minU(50.0f).area(10.0f, 10.0f).flush());
        Sprite buttonHoveredSprite = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().minU(60.0f).area(10.0f, 10.0f).flush());
        Sprite buttonClickedSprite = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().minU(70.0f).area(10.0f, 10.0f).flush());
        Rect newDim = Dim2D.build().pos(dim.x(), dim.y()).area(10.0f, 10.0f).center(dim.isCenteredX(), dim.isCenteredY()).flush();
        Button button = new Button(newDim, new TextureElement(buttonDefaultSprite, newDim), new TextureElement(buttonHoveredSprite, newDim), new TextureElement(buttonClickedSprite, newDim));
        return GuiFactory.pressSound(button);
    }

    public static GuiFrame button(Pos2D pos, float width, String text) {
        return GuiFactory.button(pos, width, text, true);
    }

    public static GuiFrame button(Pos2D pos, float width, String text, boolean centered) {
        Rect dim = Dim2D.build().area(width, 20.0f).center(centered).pos(pos.x(), pos.y()).flush();
        MinecraftButton button = new MinecraftButton(dim, text);
        return GuiFactory.pressSound(button);
    }

    public static GuiFrame button(GuiButton button) {
        return GuiFactory.button(button, true);
    }

    public static GuiFrame button(GuiButton button, boolean centered) {
        return GuiFactory.pressSound(new MinecraftButton(button, centered));
    }

    public static ScrollBar scrollBar(Pos2D pos, float height, Rect scrollableArea) {
        return GuiFactory.scrollBar(pos, height, scrollableArea, true);
    }

    public static ScrollBar scrollBar(Pos2D pos, float height, Rect scrollableArea, boolean centered) {
        Sprite bar = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().min(0.0f, 0.0f).area(10.0f, 10.0f).flush());
        Sprite base = Sprite.create((AssetLocation)SCROLL_BAR, Sprite.UV.build().min(10.0f, 0.0f).area(10.0f, 10.0f).flush());
        Rect spriteDimensions = Dim2D.build().area(10.0f, 10.0f).center(centered).flush();
        Rect barDimensions = Dim2D.build().area(10.0f, height).center(centered).flush();
        GuiFrame topButton = GuiFactory.upArrowButton(Dim2D.build().center(centered).flush());
        GuiFrame bottomButton = GuiFactory.downArrowButton(Dim2D.build().center(centered).flush());
        ScrollBar scrollBar = new ScrollBar(barDimensions, topButton, bottomButton, new TextureElement(base, spriteDimensions), new TextureElement(bar, spriteDimensions));
        scrollBar.setScrollingAreas(RectCollection.build().addDim(scrollableArea).flush());
        return scrollBar;
    }

    public static TextureElement panel(Rect dim) {
        return GuiFactory.createResizableTexture(PANEL, dim, Sprite.UV.build().area(4.0f, 4.0f).flush(), Sprite.UV.build().area(4.0f, 20.0f).flush(), Sprite.UV.build().area(20.0f, 4.0f).flush());
    }

    public static TextureElement panelEmbedded(Rect dim) {
        return GuiFactory.createResizableTexture(PANEL_EMBEDDED, dim, Sprite.UV.build().area(4.0f, 4.0f).flush(), Sprite.UV.build().area(4.0f, 20.0f).flush(), Sprite.UV.build().area(20.0f, 4.0f).flush());
    }

    public static ScrollBar createScrollBar() {
        return GuiFactory.scrollBar(Pos2D.flush(), 0.0f, Dim2D.flush());
    }

    public static TextureElement streamedTexture(Sprite sprite) {
        return new TextureElement(sprite, Dim2D.flush());
    }

    public static TextureElement texture(Sprite sprite) {
        return new TextureElement(sprite, Dim2D.flush());
    }

    public static TextureElement texture(Sprite sprite, Rect dim) {
        return new TextureElement(sprite, dim);
    }

    public static TextureElement texture(AssetLocation asset) {
        return GuiFactory.texture(asset, Dim2D.flush());
    }

    public static TextureElement texture(AssetLocation asset, Sprite.UV uv) {
        Sprite sprite = Sprite.create(asset, uv);
        return GuiFactory.texture(sprite, Dim2D.build().area(uv.width(), uv.height()).flush());
    }

    public static TextureElement texture(AssetLocation asset, Rect dim) {
        Sprite sprite = Sprite.create(asset);
        return GuiFactory.texture(sprite, dim.rebuild().area(sprite.getAssetWidth(), sprite.getAssetHeight()).flush());
    }

    public static TextureElement createResizableTexture(AssetLocation asset, Rect dim, Sprite.UV corners, Sprite.UV verticalSides, Sprite.UV horizontalSides) {
        return GuiFactory.texture(Sprite.create(asset, new ResizableUVBehavior(corners, verticalSides, horizontalSides)), dim);
    }

    public static TextureElement createTexture(AssetLocation asset) {
        return GuiFactory.texture(asset, Dim2D.flush());
    }

    public static Text text(String text, Color color) {
        return new Text(text, color, GuiFactory.font());
    }

    public static Text text(String text, Color color, float scale) {
        return new Text(text, color, scale, GuiFactory.font());
    }

    public static GuiFrame textBox(Rect dim, boolean hasSlider, Text ... text) {
        TextBox box = new TextBox(dim, false, text);
        if (!hasSlider) {
            return box;
        }
        return new ScrollableGui(dim, box, GuiFactory.createScrollBar());
    }

    public static GuiFrame centeredTextBox(Rect dim, boolean hasSlider, Text ... text) {
        TextBox box = new TextBox(dim, true, text);
        if (!hasSlider) {
            return box;
        }
        return new ScrollableGui(dim, box, GuiFactory.createScrollBar());
    }

    public static Font font() {
        final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        return new Font(){

            @Override
            public float getWidth(String text) {
                return fontRenderer.func_78256_a(text);
            }

            @Override
            public float getHeight(String text) {
                return fontRenderer.field_78288_b;
            }

            @Override
            public List<String> splitStringsIntoArea(String text, float width) {
                return fontRenderer.func_78271_c(text, (int)width);
            }
        };
    }
}

