/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.core.io.MCSyncableDispatcher;
import com.gildedgames.util.core.nbt.NBTFile;
import com.gildedgames.util.io_manager.overhead.IOManager;
import com.gildedgames.util.io_manager.overhead.IORegistry;
import com.gildedgames.util.io_manager.util.IOManagerDefault;
import com.gildedgames.util.menu.client.MenuClientEvents;
import com.gildedgames.util.ui.data.AssetLocation;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class UtilServices {
    private IOManager io;
    private static final String MANAGER_NAME = "GildedGamesUtil";

    private void startIOManager() {
        this.io = new IOManagerDefault(MANAGER_NAME);
        IORegistry registry = this.io.getRegistry();
        registry.registerClass(NBTFile.class, 0);
        registry.registerClass(MenuClientEvents.MenuConfig.class, 2);
        registry.registerClass(MCSyncableDispatcher.class, 3);
    }

    public IOManager getIOManager() {
        if (this.io == null) {
            this.startIOManager();
        }
        return this.io;
    }

    public IORegistry getIORegistry() {
        return this.getIOManager().getRegistry();
    }

    public IResource getResourceFrom(AssetLocation asset) {
        ResourceLocation resource = new ResourceLocation(asset.getDomain(), asset.getPath());
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getStreamFromAsset(AssetLocation asset) throws ZipException, IOException {
        if (asset.getDomain().equals("minecraft")) {
            return this.getResourceFrom(asset).func_110527_b();
        }
        File source = null;
        String path = "assets/" + asset.getDomain() + "/" + asset.getPath();
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equals(asset.getDomain())) continue;
            source = container.getSource();
        }
        if (source != null) {
            if (source.isFile()) {
                ZipFile zipfile = new ZipFile(source);
                ZipEntry zipentry = zipfile.getEntry(path);
                return zipfile.getInputStream(zipentry);
            }
            return new FileInputStream(new File(source, path));
        }
        return null;
    }

    public BufferedImage getBufferedImage(AssetLocation asset) {
        try {
            return ImageIO.read(UtilCore.locate().getStreamFromAsset(asset));
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

