/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectFilter {
    private ObjectFilter() {
    }

    public static <T> List<T> getTypesFrom(Object[] array, Class<? extends T> typeClass) {
        return ObjectFilter.getTypesFrom(Arrays.asList(array), typeClass);
    }

    public static <T> List<T> getTypesFrom(T[] array, FilterCondition<T> condition) {
        return ObjectFilter.getTypesFrom(Arrays.asList(array), condition);
    }

    public static <T> T getFirstFrom(Object[] array, Class<? extends T> typeClass) {
        return ObjectFilter.getFirstFrom(Arrays.asList(array), typeClass);
    }

    public static <T, K> Map<K, T> getTypesFromKeys(Map<?, ?> map, Class<? extends K> keyClass, Class<? extends T> typeClass) {
        HashMap returnMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || !typeClass.isAssignableFrom(key.getClass())) continue;
            returnMap.put(key, value);
        }
        return returnMap;
    }

    public static <T, K> Map<K, T> getTypesFromValues(Map<?, ?> map, Class<? extends K> keyClass, Class<? extends T> typeClass) {
        HashMap returnMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !typeClass.isAssignableFrom(value.getClass())) continue;
            returnMap.put(key, value);
        }
        return returnMap;
    }

    public static <T> List<T> getTypesFrom(Iterable<?> iterable, Class<? extends T> typeClass) {
        return ObjectFilter.getTypesFrom(Lists.newArrayList(iterable), typeClass);
    }

    public static <T> List<T> getTypesFrom(Collection<?> list, Class<? extends T> typeClass) {
        ArrayList returnList = new ArrayList();
        for (Object obj : list) {
            if (obj == null || !typeClass.isAssignableFrom(obj.getClass())) continue;
            returnList.add(obj);
        }
        return returnList;
    }

    public static <T> List<T> getTypesFrom(Collection<T> list, FilterCondition<T> condition) {
        ArrayList<T> returnList = new ArrayList<T>();
        for (T obj : list) {
            if (obj == null || !condition.isType(obj)) continue;
            returnList.add(obj);
        }
        return returnList;
    }

    public static <T> T getFirstFrom(Collection<?> list, Class<? extends T> typeClass) {
        for (Object obj : list) {
            if (obj == null || !typeClass.isAssignableFrom(obj.getClass())) continue;
            return (T)obj;
        }
        return null;
    }

    public static <T> T cast(Object object, Class<? extends T> typeClass) {
        Object returnObject = null;
        if (object != null && typeClass.isAssignableFrom(object.getClass())) {
            returnObject = object;
        }
        return (T)returnObject;
    }

    public static abstract class FilterCondition<T> {
        private List<T> data;

        public FilterCondition(List<T> data) {
            this.data = data;
        }

        public List<T> data() {
            return this.data;
        }

        public abstract boolean isType(T var1);
    }
}

