/*
 * Decompiled with CFR 0.152.
 */
package openeye.struct;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import openeye.Log;
import openeye.protocol.reports.IReport;
import openeye.protocol.reports.ReportAnalytics;
import openeye.protocol.reports.ReportCrash;
import openeye.protocol.reports.ReportFileContents;
import openeye.protocol.reports.ReportFileInfo;
import openeye.protocol.reports.ReportKnownFiles;
import openeye.protocol.reports.ReportPing;
import openeye.responses.IExecutableResponse;
import openeye.responses.ResponseErrorAction;
import openeye.responses.ResponseFileContentsAction;
import openeye.responses.ResponseFileInfoAction;
import openeye.responses.ResponseKnownCrashAction;
import openeye.responses.ResponseModMsgAction;
import openeye.responses.ResponsePongAction;
import openeye.responses.ResponseRemoveFileAction;
import openeye.responses.ResponseSuspendAction;

public class TypedCollections {
    private static final BiMap<String, Class<? extends IReport>> REPORTS_TYPES = HashBiMap.create();
    private static final BiMap<String, Class<? extends IExecutableResponse>> RESPONSE_TYPES = HashBiMap.create();
    public static final Object REPORT_LIST_CONVERTER = new TypedListConverter<IReport>(REPORTS_TYPES){

        @Override
        protected Collection<IReport> createCollection() {
            return new ReportsList();
        }
    };
    public static final Object RESPONSE_LIST_CONVERTER = new TypedListConverter<IExecutableResponse>(RESPONSE_TYPES){

        @Override
        protected Collection<IExecutableResponse> createCollection() {
            return new ResponseList();
        }
    };

    static {
        REPORTS_TYPES.put((Object)"analytics", ReportAnalytics.class);
        REPORTS_TYPES.put((Object)"file_info", ReportFileInfo.class);
        REPORTS_TYPES.put((Object)"crashlog", ReportCrash.class);
        REPORTS_TYPES.put((Object)"ping", ReportPing.class);
        REPORTS_TYPES.put((Object)"known_files", ReportKnownFiles.class);
        REPORTS_TYPES.put((Object)"file_contents", ReportFileContents.class);
        RESPONSE_TYPES.put((Object)"file_info", ResponseFileInfoAction.class);
        RESPONSE_TYPES.put((Object)"pong", ResponsePongAction.class);
        RESPONSE_TYPES.put((Object)"file_contents", ResponseFileContentsAction.class);
        RESPONSE_TYPES.put((Object)"remove_file_suggestion", ResponseRemoveFileAction.class);
        RESPONSE_TYPES.put((Object)"note", ResponseModMsgAction.class);
        RESPONSE_TYPES.put((Object)"error", ResponseErrorAction.class);
        RESPONSE_TYPES.put((Object)"known_crash", ResponseKnownCrashAction.class);
        RESPONSE_TYPES.put((Object)"suspend", ResponseSuspendAction.class);
    }

    public static class ResponseList
    extends ArrayList<IExecutableResponse> {
        private static final long serialVersionUID = 4069373518963113118L;
    }

    public static class ReportsList
    extends ArrayList<IReport> {
        private static final long serialVersionUID = -6580030458427773185L;
    }

    private static abstract class TypedListConverter<T>
    implements JsonSerializer<Collection<T>>,
    JsonDeserializer<Collection<T>> {
        private final BiMap<String, Class<? extends T>> mapping;

        private TypedListConverter(BiMap<String, Class<? extends T>> mapping) {
            this.mapping = mapping;
        }

        public JsonElement serialize(Collection<T> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            for (T entry : src) {
                Class<?> entryClass = entry.getClass();
                String type = (String)this.mapping.inverse().get(entryClass);
                if (type != null) {
                    JsonObject serializedReport = context.serialize(entry).getAsJsonObject();
                    serializedReport.addProperty("type", type);
                    result.add((JsonElement)serializedReport);
                    continue;
                }
                Log.warn("Trying to serialize class without mapping: %s", entryClass);
            }
            return result;
        }

        public Collection<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray requests = json.getAsJsonArray();
            Collection<T> result = this.createCollection();
            for (JsonElement e : requests) {
                try {
                    JsonObject obj = e.getAsJsonObject();
                    JsonElement type = obj.get("type");
                    String typeId = type.getAsString();
                    Class cls = (Class)this.mapping.get((Object)typeId);
                    if (cls != null) {
                        Object request = context.deserialize((JsonElement)obj, (Type)cls);
                        result.add(request);
                        continue;
                    }
                    Log.warn("Invalid request type: %s", typeId);
                }
                catch (Throwable t) {
                    Log.warn(t, "Failed to deserialize request %s", e);
                }
            }
            return result;
        }

        protected abstract Collection<T> createCollection();
    }
}

