/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import openeye.logic.ModState;
import openeye.logic.StateHolder;
import openeye.logic.Storages;
import openeye.net.GenericSender;
import openeye.notes.NoteCategory;
import openeye.notes.ScreenNotificationHolder;
import openeye.notes.entries.MsgNoteEntry;
import openeye.notes.entries.NoteEntry;
import openeye.notes.entries.RemoveFileEntry;
import openeye.notes.entries.ReportedCrashEntry;
import openeye.notes.entries.ResolvedCrashEntry;
import openeye.notes.entries.SystemNoteEntry;
import openeye.responses.ResponseKnownCrashAction;
import openeye.responses.ResponseModMsgAction;
import openeye.responses.ResponseRemoveFileAction;

public class NoteCollector {
    private static final Comparator<NoteEntry> NOTE_COMPARATOR = new Comparator<NoteEntry>(){

        @Override
        public int compare(NoteEntry o1, NoteEntry o2) {
            int result = o2.level - o1.level;
            if (result != 0) {
                return result;
            }
            return o1.file.compareTo(o2.file);
        }
    };
    private final ScreenNotificationHolder menuLine = new ScreenNotificationHolder();
    private boolean important;
    public static final NoteCollector INSTANCE = new NoteCollector();
    private final List<NoteEntry> notes = Lists.newArrayList();
    private NoteCategory maxCategory = NoteCategory.INFO;

    private NoteCollector() {
    }

    public synchronized void addNote(NoteEntry entry) {
        this.notes.add(entry);
        this.maxCategory = (NoteCategory)((Object)Ordering.natural().max((Object)this.maxCategory, (Object)entry.category));
        this.important |= entry.category.important;
    }

    public void addNote(File file, ResponseModMsgAction note) {
        MsgNoteEntry entry = new MsgNoteEntry(file, note);
        this.addNote(entry);
    }

    public void addNote(File file, ResponseRemoveFileAction note) {
        this.addNote(new RemoveFileEntry(file, note));
        this.menuLine.signalDangerousFile();
    }

    public void addNote(ResponseKnownCrashAction note) {
        if (Strings.isNullOrEmpty((String)note.note)) {
            this.addNote(new ReportedCrashEntry(note));
            this.menuLine.signalCrashReported();
        } else {
            this.addNote(new ResolvedCrashEntry(note));
            this.menuLine.signalKnownCrash();
        }
    }

    public void addNote(GenericSender.EncryptionState encryptionState) {
        switch (encryptionState) {
            case NO_ROOT_CERTIFICATE: {
                this.addNote(new SystemNoteEntry(NoteCategory.WARNING, 11, (IChatComponent)new ChatComponentTranslation("openeye.note.title.old_java", new Object[0]), (IChatComponent)new ChatComponentTranslation("openeye.note.content.old_java_recoverable", new Object[0]), "http://lmgtfy.com/?q=download+java"));
                break;
            }
            case NOT_SUPPORTED: {
                this.addNote(new SystemNoteEntry(NoteCategory.ALERT, 22, (IChatComponent)new ChatComponentTranslation("openeye.note.title.old_java", new Object[0]), (IChatComponent)new ChatComponentTranslation("openeye.note.content.old_java_total_failure", new Object[0]), "http://lmgtfy.com/?q=download+java"));
                break;
            }
        }
    }

    public void addSuspendNote(long suspendUntilTimestamp, String reason) {
        Date suspendEndDate = new Date(suspendUntilTimestamp);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String suspendPrintable = dateFormat.format(suspendEndDate);
        this.addNote(new SystemNoteEntry(NoteCategory.INFO, 32, (IChatComponent)new ChatComponentTranslation("openeye.note.title.suspended", new Object[0]), (IChatComponent)(Strings.isNullOrEmpty((String)reason) ? new ChatComponentTranslation("openeye.note.content.suspended_no_reason", new Object[]{suspendPrintable, reason}) : new ChatComponentTranslation("openeye.note.content.suspended", new Object[]{suspendPrintable, reason})), "https://openeye.openmods.info"));
    }

    public boolean isEmpty() {
        return this.notes.isEmpty();
    }

    public NoteCategory getMaxLevel() {
        return this.maxCategory;
    }

    public IChatComponent getScreenMsg() {
        return this.menuLine.getSelectedLine();
    }

    public boolean hasImportantNotes() {
        return this.important;
    }

    public List<NoteEntry> getNotes() {
        Collections.sort(this.notes, NOTE_COMPARATOR);
        return ImmutableList.copyOf(this.notes);
    }

    private void addIntroNote(int id, String url) {
        String title = "openeye.note.title.intro" + id;
        String content = "openeye.note.content.intro" + id;
        this.addNote(new SystemNoteEntry(272 - id, (IChatComponent)new ChatComponentTranslation(title, new Object[0]), (IChatComponent)new ChatComponentTranslation(content, new Object[0]), url));
    }

    public void finishNoteCollection() {
        ModState state = StateHolder.state();
        if (!state.infoNotesDisplayed) {
            this.addIntroNote(1, "https://openeye.openmods.info");
            this.addIntroNote(2, "https://openeye.openmods.info");
            this.addIntroNote(3, "https://openeye.openmods.info/storage-policy");
            Storages storages = Storages.instance();
            if (storages != null) {
                this.addIntroNote(4, storages.reportsDir.toURI().toString());
            }
            this.addIntroNote(5, "https://github.com/OpenMods/OpenData");
            this.addIntroNote(6, "https://openeye.openmods.info/configuration");
            state.infoNotesDisplayed = true;
        }
        if (!state.mainMenuInfoDisplayed) {
            this.menuLine.signalIntroStuff();
            state.mainMenuInfoDisplayed = true;
        }
    }
}

