/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.lang.reflect.Type;
import openeye.struct.TypedCollections;

public class GsonUtils {
    public static final JsonSerializer<ArtifactVersion> VERSION_SERIALIZER = new JsonSerializer<ArtifactVersion>(){

        public JsonElement serialize(ArtifactVersion src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("label", src.getLabel());
            obj.addProperty("version", src.getRangeString());
            return obj;
        }
    };
    public static final Gson NET_GSON = GsonUtils.setupCommonBuilder().create();
    public static final Gson PRETTY_GSON = GsonUtils.setupCommonBuilder().setPrettyPrinting().create();

    public static GsonBuilder setupCommonBuilder() {
        return new GsonBuilder().registerTypeAdapter(TypedCollections.ReportsList.class, TypedCollections.REPORT_LIST_CONVERTER).registerTypeAdapter(TypedCollections.ResponseList.class, TypedCollections.RESPONSE_LIST_CONVERTER).registerTypeAdapter(ArtifactVersion.class, VERSION_SERIALIZER);
    }
}

