/*
 * Decompiled with CFR 0.152.
 */
package openeye.config;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Table;
import com.google.common.io.Closer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import openeye.Log;
import openeye.config.IConfigProcessingEngine;
import openeye.config.IConfigPropertyHolder;

public class GsonConfigProcessingEngine
implements IConfigProcessingEngine {
    private static final String VALUE_TAG = "value";
    private static final String COMMENT_TAG = "comment";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonElement parse(File file) {
        JsonElement jsonElement;
        FileInputStream stream = new FileInputStream(file);
        try {
            InputStreamReader fileReader = new InputStreamReader((InputStream)stream, Charsets.UTF_8);
            JsonReader jsonReader = new JsonReader((Reader)fileReader);
            jsonReader.setLenient(true);
            jsonElement = Streams.parse((JsonReader)jsonReader);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        ((InputStream)stream).close();
        return jsonElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(File file, JsonElement element) {
        try {
            Closer closer = Closer.create();
            try {
                FileOutputStream stream = (FileOutputStream)closer.register((Closeable)new FileOutputStream(file));
                Writer fileWriter = (Writer)closer.register((Closeable)new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8));
                JsonWriter jsonWriter = (JsonWriter)closer.register((Closeable)new JsonWriter(fileWriter));
                jsonWriter.setIndent("    ");
                Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
            }
            finally {
                closer.close();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static JsonElement dumpConfig(Table<String, String, IConfigPropertyHolder> properties) {
        JsonObject result = new JsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
        for (Map.Entry category : properties.rowMap().entrySet()) {
            JsonObject categoryNode = new JsonObject();
            for (Map.Entry property : ((Map)category.getValue()).entrySet()) {
                JsonObject propertyNode = new JsonObject();
                IConfigPropertyHolder propertyHolder = (IConfigPropertyHolder)property.getValue();
                String comment = propertyHolder.comment();
                if (!Strings.isNullOrEmpty((String)comment)) {
                    propertyNode.addProperty(COMMENT_TAG, comment);
                }
                try {
                    Object value = propertyHolder.getValue();
                    JsonElement serialized = gson.toJsonTree(value);
                    propertyNode.add(VALUE_TAG, serialized);
                }
                catch (Exception e) {
                    Log.warn(e, "Failed to serialize property %s:%s", propertyHolder.category(), propertyHolder.name());
                }
                categoryNode.add((String)property.getKey(), (JsonElement)propertyNode);
            }
            result.add((String)category.getKey(), (JsonElement)categoryNode);
        }
        return result;
    }

    private static boolean loadConfig(JsonElement parsed, Table<String, String, IConfigPropertyHolder> properties) {
        if (!parsed.isJsonObject()) {
            return true;
        }
        Gson gson = new Gson();
        JsonObject rootNode = parsed.getAsJsonObject();
        boolean missingFields = false;
        for (Map.Entry e : properties.rowMap().entrySet()) {
            JsonElement categoryTmp = rootNode.get((String)e.getKey());
            missingFields |= GsonConfigProcessingEngine.parseCategory(categoryTmp, (Map)e.getValue(), gson);
        }
        return missingFields;
    }

    private static boolean parseCategory(JsonElement categoryElement, Map<String, IConfigPropertyHolder> properties, Gson gson) {
        if (!(categoryElement instanceof JsonObject)) {
            return true;
        }
        JsonObject categoryNode = categoryElement.getAsJsonObject();
        boolean missingFields = false;
        for (Map.Entry<String, IConfigPropertyHolder> e : properties.entrySet()) {
            JsonElement propertyValue = categoryNode.get(e.getKey());
            missingFields |= GsonConfigProcessingEngine.parseProperty(propertyValue, e.getValue(), gson);
        }
        return missingFields;
    }

    private static boolean parseProperty(JsonElement propertyElement, IConfigPropertyHolder property, Gson gson) {
        if (!(propertyElement instanceof JsonObject)) {
            return true;
        }
        JsonObject propertyNode = propertyElement.getAsJsonObject();
        JsonElement value = propertyNode.get(VALUE_TAG);
        if (value == null) {
            return true;
        }
        try {
            Object parsedValue = gson.fromJson(value, property.getType());
            property.setValue(parsedValue);
        }
        catch (Exception e) {
            Log.warn(e, "Failed to parse value of field %s:%s", property.category(), property.name());
            return true;
        }
        JsonElement comment = propertyNode.get(COMMENT_TAG);
        String expectedComment = property.comment();
        if (comment == null) {
            return !Strings.isNullOrEmpty((String)expectedComment);
        }
        if (comment.isJsonPrimitive()) {
            String commentValue = comment.getAsString();
            return !expectedComment.equals(commentValue);
        }
        return true;
    }

    @Override
    public boolean loadConfig(File source, Table<String, String, IConfigPropertyHolder> properties) {
        if (source.exists()) {
            try {
                JsonElement parsed = GsonConfigProcessingEngine.parse(source);
                return GsonConfigProcessingEngine.loadConfig(parsed, properties);
            }
            catch (Exception e) {
                Log.warn(e, "Failed to parse file %s, using defaults", source);
            }
        }
        return true;
    }

    @Override
    public void dumpConfig(File source, Table<String, String, IConfigPropertyHolder> properties) {
        try {
            JsonElement serialized = GsonConfigProcessingEngine.dumpConfig(properties);
            GsonConfigProcessingEngine.write(source, serialized);
        }
        catch (Exception e) {
            Log.warn(e, "Failed to save config to file %s", source);
        }
    }
}

