/*
 * Decompiled with CFR 0.152.
 */
package openeye.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import openeye.Log;
import openeye.config.ConfigPropertyCollector;
import openeye.config.GsonConfigProcessingEngine;
import openeye.config.IConfigProcessingEngine;
import openeye.config.IConfigPropertyHolder;

public class ConfigProcessing {
    public static final IConfigProcessingEngine GSON = new GsonConfigProcessingEngine();

    private static Table<String, String, IConfigPropertyHolder> categorizeProperties(Collection<IConfigPropertyHolder> properties) {
        TreeBasedTable result = TreeBasedTable.create();
        for (IConfigPropertyHolder property : properties) {
            IConfigPropertyHolder prev = (IConfigPropertyHolder)result.put((Object)property.category(), (Object)property.name(), (Object)property);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicated property %s:%s", (Object[])new Object[]{property.category(), property.name()});
        }
        return result;
    }

    private static void loadAndDump(File configFile, IConfigProcessingEngine engine, List<IConfigPropertyHolder> holders) {
        Table<String, String, IConfigPropertyHolder> properties = ConfigProcessing.categorizeProperties(holders);
        boolean modified = engine.loadConfig(configFile, properties);
        if (modified) {
            Log.info("Detected missing/malformed fields in file %s, updating", configFile);
            engine.dumpConfig(configFile, properties);
        }
    }

    public static void processConfig(File configFile, Class<?> cls, IConfigProcessingEngine engine) {
        List<IConfigPropertyHolder> holders = ConfigPropertyCollector.collectFromClass(cls);
        ConfigProcessing.loadAndDump(configFile, engine, holders);
    }

    public static void processConfig(File configFile, Object target, boolean excludeStatic, IConfigProcessingEngine engine) {
        Preconditions.checkNotNull((Object)target);
        List<IConfigPropertyHolder> holders = ConfigPropertyCollector.collectFromInstance(target, excludeStatic);
        ConfigProcessing.loadAndDump(configFile, engine, holders);
    }
}

