/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCoFHBase;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import org.apache.logging.log4j.Level;

public class BlockFluidAerotheum
extends BlockFluidCoFHBase {
    Random random = new Random();
    public static final int LEVELS = 6;
    public static final Material materialFluidAerotheum = new MaterialLiquid(MapColor.field_151660_b);
    private static boolean effect = true;
    private static boolean enableSourceDissipate = true;
    private static boolean enableSourceFloat = true;
    private static int maxHeight = 120;

    public BlockFluidAerotheum() {
        super("thermalfoundation", TFFluids.fluidAerotheum, materialFluidAerotheum, "aerotheum");
        this.setQuantaPerBlock(6);
        this.setTickRate(8);
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.setParticleColor(0.65f, 0.65f, 0.48f);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, (String)"FluidAerotheum");
        String string = "Fluid.Aerotheum";
        String string2 = "Enable this for Fluid Aerotheum to do...things.";
        effect = ThermalFoundation.config.get(string, "Effect", true, string2);
        string2 = "Enable this for Fluid Aerotheum Source blocks to dissipate back into air above a given y-value.";
        enableSourceDissipate = ThermalFoundation.config.get(string, "Dissipate", enableSourceDissipate, string2);
        string2 = "Enable this for Fluid Aerotheum Source blocks to gradually float upwards.";
        enableSourceFloat = ThermalFoundation.config.get(string, "Float", enableSourceFloat, string2);
        string2 = "This adjusts the y-value where Fluid Aerotheum will *always* dissipate, if that is enabled.";
        int n = ThermalFoundation.config.get(string, "MaxHeight", maxHeight, string2);
        if (n >= maxHeight / 2) {
            maxHeight = n;
        } else {
            ThermalFoundation.log.log(Level.INFO, "'Fluid.Aerotheum.MaxHeight' config value is out of acceptable range. Using default: " + maxHeight + ".");
        }
        return true;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (!effect) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            if (entity.field_70159_w > 0.1) {
                entity.field_70159_w = 0.1;
            }
            if (entity.field_70179_y > 0.1) {
                entity.field_70179_y = 0.1;
            }
            if (entity.field_70181_x < -0.2) {
                entity.field_70181_x *= 0.5;
                entity.field_70143_R = entity.field_70143_R > 20.0f ? 20.0f : (float)((double)entity.field_70143_R * 0.5);
            }
        } else if (entity instanceof IProjectile) {
            entity.field_70159_w *= this.random.nextGaussian() * 1.5;
            entity.field_70179_y *= this.random.nextGaussian() * 1.5;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 60, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 600, 0));
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return TFFluids.fluidAerotheum.getLuminosity();
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        if (world.func_72805_g(n, n2, n3) == 0) {
            if (random.nextInt(3) == 0) {
                if (this.shouldSourceBlockCondense(world, n, n2, n3)) {
                    world.func_147468_f(n, n2, n3);
                    return;
                }
                if (this.shouldSourceBlockFloat(world, n, n2, n3)) {
                    world.func_147465_d(n, n2 + ((BlockFluidBase)this).densityDir, n3, (Block)this, 0, 3);
                    world.func_147468_f(n, n2, n3);
                    return;
                }
            }
        } else if (n2 + ((BlockFluidBase)this).densityDir > maxHeight) {
            int n4 = ((BlockFluidBase)this).quantaPerBlock - world.func_72805_g(n, n2, n3);
            int n5 = -101;
            int n6 = n2 - ((BlockFluidBase)this).densityDir;
            if (world.func_147439_a(n, n6, n3) == this || world.func_147439_a(n - 1, n6, n3) == this || world.func_147439_a(n + 1, n6, n3) == this || world.func_147439_a(n, n6, n3 - 1) == this || world.func_147439_a(n, n6, n3 + 1) == this) {
                n5 = ((BlockFluidBase)this).quantaPerBlock - 1;
            } else {
                int n7 = -100;
                n7 = this.getLargerQuanta((IBlockAccess)world, n - 1, n2, n3, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n + 1, n2, n3, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n, n2, n3 - 1, n7);
                n7 = this.getLargerQuanta((IBlockAccess)world, n, n2, n3 + 1, n7);
                n5 = n7 - 1;
            }
            if (n5 != n4) {
                n4 = n5;
                if (n5 <= 0) {
                    world.func_147468_f(n, n2, n3);
                } else {
                    world.func_72921_c(n, n2, n3, ((BlockFluidBase)this).quantaPerBlock - n5, 3);
                    world.func_147464_a(n, n2, n3, (Block)this, ((BlockFluidBase)this).tickRate);
                    world.func_147459_d(n, n2, n3, (Block)this);
                }
            }
            return;
        }
        super.func_149674_a(world, n, n2, n3, random);
    }

    protected boolean shouldSourceBlockCondense(World world, int n, int n2, int n3) {
        return enableSourceDissipate && (n2 + ((BlockFluidBase)this).densityDir > maxHeight || n2 + ((BlockFluidBase)this).densityDir > world.func_72800_K());
    }

    protected boolean shouldSourceBlockFloat(World world, int n, int n2, int n3) {
        return enableSourceFloat && world.func_147439_a(n, n2 + ((BlockFluidBase)this).densityDir, n3) == this && world.func_72805_g(n, n2 + ((BlockFluidBase)this).densityDir, n3) != 0;
    }
}

